/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeProcessorPlan;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class TestQueryProcessor {
    public void helpTestProcessor(FakeProcessorPlan plan, List[] expectedResults) throws TeiidException {
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        FakeDataManager dataManager = new FakeDataManager();
        CommandContext context = new CommandContext((Object)"pid", "group", null, null, (Object)1);
        QueryProcessor processor = new QueryProcessor((ProcessorPlan)plan, context, bufferMgr, (ProcessorDataManager)dataManager);
        BatchCollector collector = processor.createBatchCollector();
        TupleBuffer tsID = null;
        while (true) {
            try {
                tsID = collector.collectTuples();
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        Assert.assertEquals((String)"Did not get expected # of rows", (long)expectedResults.length, (long)tsID.getRowCount());
        TupleBuffer.TupleBufferTupleSource actual = tsID.createIndexedTupleSource();
        if (expectedResults.length > 0) {
            for (int i = 0; i < expectedResults.length; ++i) {
                List actRecord = actual.nextTuple();
                List expRecord = expectedResults[i];
                Assert.assertEquals((String)("Did not match row at row index " + i), (Object)expRecord, (Object)actRecord);
            }
        }
        tsID.remove();
    }

    @Test
    public void testNoResults() throws Exception {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER));
        FakeProcessorPlan plan = new FakeProcessorPlan(elements, null);
        this.helpTestProcessor(plan, new List[0]);
    }

    @Test
    public void testBlockNoResults() throws Exception {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER));
        ArrayList<BlockedException> batches = new ArrayList<BlockedException>();
        batches.add(BlockedException.INSTANCE);
        TupleBatch batch = new TupleBatch(1L, new List[0]);
        batch.setTerminationFlag(true);
        batches.add((BlockedException)batch);
        FakeProcessorPlan plan = new FakeProcessorPlan(elements, batches);
        this.helpTestProcessor(plan, new List[0]);
    }

    @Test
    public void testProcessWithOccasionalBlocks() throws Exception {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER));
        HashSet<Integer> blocked = new HashSet<Integer>(Arrays.asList(new Integer(0), new Integer(2), new Integer(7)));
        int numBatches = 10;
        int batchRow = 1;
        int rowsPerBatch = 50;
        List[] expectedResults = new List[rowsPerBatch * (numBatches - blocked.size())];
        ArrayList<BlockedException> batches = new ArrayList<BlockedException>();
        for (int b = 0; b < numBatches; ++b) {
            if (blocked.contains(new Integer(b))) {
                batches.add(BlockedException.INSTANCE);
                continue;
            }
            List[] rows = new List[rowsPerBatch];
            for (int i = 0; i < rowsPerBatch; ++i) {
                rows[i] = new ArrayList();
                rows[i].add(new Integer(batchRow));
                expectedResults[batchRow - 1] = rows[i];
                ++batchRow;
            }
            TupleBatch batch = new TupleBatch((long)(batchRow - rows.length), rows);
            if (b == numBatches - 1) {
                batch.setTerminationFlag(true);
            }
            batches.add((BlockedException)batch);
        }
        FakeProcessorPlan plan = new FakeProcessorPlan(elements, batches);
        this.helpTestProcessor(plan, expectedResults);
    }

    @Test
    public void testCloseBeforeInitialization() throws TeiidComponentException {
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        FakeDataManager dataManager = new FakeDataManager();
        CommandContext context = new CommandContext((Object)"pid", "group", null, null, (Object)1);
        QueryProcessor processor = new QueryProcessor(null, context, bufferMgr, (ProcessorDataManager)dataManager);
        processor.closeProcessing();
    }
}

