/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class ExtensibleBufferedInputStream
extends InputStream {
    ByteBuffer buf;

    @Override
    public int read() throws IOException {
        if (!this.ensureBytes()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    private boolean ensureBytes() throws IOException {
        if (this.buf == null || this.buf.remaining() == 0) {
            this.buf = this.nextBuffer();
            if (this.buf == null) {
                return false;
            }
        }
        return true;
    }

    protected abstract ByteBuffer nextBuffer() throws IOException;

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.ensureBytes()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(b, off, len);
        return len;
    }

    @Override
    public void reset() throws IOException {
        if (this.buf != null) {
            this.buf.rewind();
        }
    }

    public ByteBuffer getBuffer() throws IOException {
        if (!this.ensureBytes()) {
            return null;
        }
        return this.buf;
    }
}

