/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.function.aggregate.SingleArgumentAggregateFunction;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.util.CommandContext;

public class Min
extends SingleArgumentAggregateFunction {
    private Object minValue;
    private Class<?> outputType;

    @Override
    public void reset() {
        this.minValue = null;
    }

    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
        this.outputType = inputType;
    }

    @Override
    public void addInputDirect(Object value, List<?> tuple, CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        if (this.minValue == null) {
            this.minValue = value;
        } else {
            Comparable valueComp = (Comparable)value;
            if (Constant.COMPARATOR.compare(valueComp, this.minValue) < 0) {
                this.minValue = valueComp;
            }
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) {
        return this.minValue;
    }

    @Override
    public List<? extends Class<?>> getStateTypes() {
        return Arrays.asList(this.outputType);
    }

    @Override
    public void getState(List<Object> state) {
        state.add(this.minValue);
    }

    @Override
    public int setState(List<?> state, int index) {
        this.minValue = state.get(index);
        return index++;
    }
}

