/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.teiid.core.util.FileUtils;
import org.teiid.test.client.ResultsGenerator;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.util.TestResultSetUtil;

public class ResultsGeneratorImpl
implements ResultsGenerator {
    private static final SimpleDateFormat FILE_NAME_DATE_FORMATER = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private String outputDir = "";
    private String generateDir = "";
    private static final int MAX_COL_WIDTH = 65;

    public ResultsGeneratorImpl(String testname, Properties props) {
        this.outputDir = props.getProperty("outputdir", ".");
        Assert.assertNotNull((String)"Property outputdir was not specified", (Object)this.outputDir);
        this.outputDir = this.outputDir + "/" + testname;
        this.generateDir = props.getProperty("generatedir", ".");
        Assert.assertNotNull((String)"Property generatedir was not specified", (Object)this.generateDir);
        File d = new File(this.outputDir);
        this.outputDir = d.getAbsolutePath();
        d = new File(this.outputDir);
        if (d.exists()) {
            FileUtils.removeDirectoryAndChildren((File)d);
        }
        if (!d.exists()) {
            d.mkdirs();
        }
        d = new File(this.generateDir, testname);
        this.generateDir = d.getAbsolutePath();
        d = new File(this.generateDir);
        if (d.exists()) {
            FileUtils.removeDirectoryAndChildren((File)d);
        }
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    @Override
    public String getGenerateDir() {
        return this.generateDir;
    }

    @Override
    public String getOutputDir() {
        return this.outputDir;
    }

    @Override
    public void generateQueryResultFile(String querySetID, String queryID, String query, ResultSet result, Throwable ex, int testStatus) throws QueryTestFailedException {
        File fos = this.createNewResultsFile(queryID, querySetID, this.getGenerateDir());
        FileOutputStream actualOut = null;
        try {
            actualOut = new FileOutputStream(fos);
            PrintStream filePrintStream = new PrintStream(actualOut);
            if (ex != null) {
                TestResultSetUtil.printThrowable(ex, query, filePrintStream);
            } else if (result != null) {
                result.beforeFirst();
                TestResultSetUtil.printResultSet(result, query, 65, true, filePrintStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new QueryTestFailedException(e);
        }
        finally {
            if (actualOut != null) {
                try {
                    actualOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String generateErrorFile(String querySetID, String queryID, String sql, ResultSet resultSet, Throwable queryError, Object results) throws QueryTestFailedException {
        String errorFileName = null;
        try {
            errorFileName = this.generateErrorFileName(queryID, querySetID);
            File errorFile = new File(this.getOutputDir(), errorFileName);
            if (resultSet == null) {
                FileOutputStream actualOut = null;
                try {
                    actualOut = new FileOutputStream(errorFile);
                    PrintStream filePrintStream = new PrintStream(actualOut);
                    TestResultSetUtil.printThrowable(queryError, sql, filePrintStream);
                    filePrintStream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new QueryTestFailedException(e);
                }
                finally {
                    if (actualOut != null) {
                        try {
                            actualOut.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return errorFileName;
            }
            resultSet.beforeFirst();
            this.generateErrorResults(querySetID, queryID, sql, errorFile, resultSet, results != null ? (List)results : null);
        }
        catch (Throwable e) {
            throw new QueryTestFailedException(e.getMessage());
        }
        return errorFileName;
    }

    private File createNewResultsFile(String queryID, String querySetID, String genDir) {
        String resultFileName = queryID + ".txt";
        String targetDirname = genDir + File.separator + querySetID;
        File targetDir = new File(targetDirname);
        targetDir.mkdirs();
        return new File(targetDir, resultFileName);
    }

    private String generateErrorFileName(String queryID, String querySetID) {
        return queryID + ".txt";
    }

    private void generateErrorResults(String querySetID, String queryID, String sql, File resultsFile, ResultSet actualResult, List<String> results) throws QueryTestFailedException {
        FileOutputStream actualOut = null;
        try {
            actualOut = new FileOutputStream(resultsFile);
            PrintStream filePrintStream = new PrintStream(actualOut);
            TestResultSetUtil.printResultSet(actualResult, sql, 65, true, filePrintStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new QueryTestFailedException(e);
        }
        finally {
            if (actualOut != null) {
                try {
                    actualOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

