/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RulePushNonJoinCriteria
implements OptimizerRule {
    private boolean firstRun = true;

    public RulePushNonJoinCriteria(boolean firstRun) {
        this.firstRun = firstRun;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean treeChanged = false;
        boolean removeCopiedFlag = false;
        boolean pushRuleRaiseNull = false;
        for (PlanNode node : NodeEditor.findAllNodes(plan, 4)) {
            List criteria = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            JoinType joinType = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
            if (joinType == JoinType.JOIN_FULL_OUTER || joinType == JoinType.JOIN_CROSS) continue;
            Iterator crits = criteria.iterator();
            while (crits.hasNext()) {
                Criteria crit = (Criteria)crits.next();
                if (crit.equals(QueryRewriter.FALSE_CRITERIA) || crit.equals(QueryRewriter.UNKNOWN_CRITERIA)) {
                    if (joinType == JoinType.JOIN_INNER) {
                        FrameUtil.replaceWithNullNode(node);
                    } else {
                        FrameUtil.replaceWithNullNode(JoinUtil.getInnerSideJoinNodes(node)[0]);
                        removeCopiedFlag = true;
                    }
                    pushRuleRaiseNull = true;
                    treeChanged = true;
                    break;
                }
                if (crit.equals(QueryRewriter.TRUE_CRITERIA)) {
                    crits.remove();
                    break;
                }
                if (!this.pushCriteria(node, crit, crits, metadata)) continue;
                treeChanged = true;
            }
            if (criteria.isEmpty() && joinType == JoinType.JOIN_INNER) {
                node.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
                treeChanged = true;
            }
            if (!removeCopiedFlag) continue;
            for (PlanNode parent = node.getParent(); parent != null && parent.getType() == 16; parent = parent.getParent()) {
                parent.setProperty(NodeConstants.Info.IS_COPIED, Boolean.FALSE);
            }
        }
        if (treeChanged) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        if (pushRuleRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    private boolean pushCriteria(PlanNode joinNode, Criteria tgtCrit, Iterator iter, QueryMetadataInterface metadata) {
        PlanNode newCritNode = RelationalPlanner.createSelectNode(tgtCrit, false);
        Set<GroupSymbol> groups = newCritNode.getGroups();
        PlanNode[] innerJoinNodes = JoinUtil.getInnerSideJoinNodes(joinNode);
        boolean pushed = false;
        for (int i = 0; i < innerJoinNodes.length; ++i) {
            if (FrameUtil.findOriginatingNode(innerJoinNodes[i], groups) == null) continue;
            if (pushed) {
                newCritNode = RelationalPlanner.createSelectNode(tgtCrit, false);
            }
            innerJoinNodes[i].addAsParent(newCritNode);
            pushed = true;
        }
        if (pushed) {
            iter.remove();
        } else if (this.firstRun && tgtCrit instanceof CompareCriteria) {
            CompareCriteria crit = (CompareCriteria)tgtCrit;
            Expression leftExpr = crit.getLeftExpression();
            Expression rightExpr = crit.getRightExpression();
            for (int i = 0; i < innerJoinNodes.length; ++i) {
                PlanNode node = FrameUtil.findJoinSourceNode(innerJoinNodes[i]);
                boolean outer = false;
                for (PlanNode child : NodeEditor.findAllNodes(node, 4)) {
                    if (!((JoinType)child.getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter()) continue;
                    outer = true;
                    break;
                }
                if (!outer) continue;
                Set<GroupSymbol> leftExprGroups = GroupsUsedByElementsVisitor.getGroups(leftExpr);
                Set<GroupSymbol> rightExprGroups = GroupsUsedByElementsVisitor.getGroups(rightExpr);
                ArrayList<ElementSymbol> notNull = new ArrayList<ElementSymbol>(2);
                if (node.getGroups().containsAll(leftExprGroups)) {
                    this.collectNotNull(leftExpr, notNull);
                } else if (node.getGroups().containsAll(rightExprGroups)) {
                    this.collectNotNull(rightExpr, notNull);
                }
                if (notNull.isEmpty()) continue;
                pushed = true;
                for (ElementSymbol es : notNull) {
                    IsNullCriteria inc = new IsNullCriteria(es);
                    inc.setNegated(true);
                    PlanNode notNullCrit = RelationalPlanner.createSelectNode(inc, false);
                    notNullCrit.setProperty(NodeConstants.Info.IS_TEMPORARY, true);
                    innerJoinNodes[i].addAsParent(notNullCrit);
                }
            }
        }
        return pushed;
    }

    private void collectNotNull(Expression leftExpr, ArrayList<ElementSymbol> notNull) {
        Function f;
        if (leftExpr instanceof ElementSymbol) {
            notNull.add((ElementSymbol)leftExpr);
        } else if (leftExpr instanceof Function && !(f = (Function)leftExpr).getFunctionDescriptor().isNullDependent()) {
            for (Expression arg : f.getArgs()) {
                this.collectNotNull(arg, notNull);
            }
        }
    }

    public String toString() {
        return "PushNonJoinCriteria";
    }
}

