/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.xquery.saxon;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.teiid.query.xquery.saxon.NodeWrapper;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected long documentNumber;
    private HashMap idIndex;
    private Map<String, Object> userData = new HashMap<String, Object>();

    public DocumentWrapper(Node root, String baseURI, Configuration config) {
        super(root, null, 0);
        if (root.getParent() != null) {
            throw new IllegalArgumentException("root node must not have a parent node");
        }
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.setConfiguration(config);
    }

    public NodeInfo wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String id, boolean getParent) {
        NodeInfo result;
        if (this.idIndex == null) {
            Element elem;
            switch (this.nodeKind) {
                case 9: {
                    elem = ((Document)this.node).getRootElement();
                    break;
                }
                case 1: {
                    elem = (Element)this.node;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.idIndex = new HashMap(50);
            this.buildIDIndex(elem);
        }
        if ((result = (NodeInfo)this.idIndex.get(id)) != null && getParent && result.isId() && result.getStringValue().equals(id)) {
            result = result.getParent();
        }
        return result;
    }

    private void buildIDIndex(Element elem) {
        int i = elem.getChildCount();
        while (--i >= 0) {
            Node child = elem.getChild(i);
            if (!(child instanceof Element)) continue;
            this.buildIDIndex((Element)child);
        }
        i = elem.getAttributeCount();
        while (--i >= 0) {
            Attribute att = elem.getAttribute(i);
            if (att.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(att.getValue(), this.wrap((Node)elem));
        }
    }

    public String[] getUnparsedEntity(String name) {
        return null;
    }

    public Iterator getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    public Object getUserData(String arg0) {
        return this.userData.get(arg0);
    }

    public void setUserData(String arg0, Object arg1) {
        this.userData.put(arg0, arg1);
    }

    public boolean isTyped() {
        return false;
    }
}

