/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TestParser;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.translator.CacheDirective;

public class TestOptionsAndHints {
    @Test
    public void testOptionMakeNotDepInline4() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("c", "db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)b);
        From from = new From();
        UnaryFromClause clause = new UnaryFromClause(g1);
        clause.setMakeNotDep(true);
        from.addClause((FromClause)clause);
        UnaryFromClause clause1 = new UnaryFromClause(g2);
        clause1.setMakeNotDep(true);
        from.addClause((FromClause)clause1);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g1 MAKENOTDEP, db.g2 AS c MAKENOTDEP WHERE a = b", "SELECT a FROM /*+ MAKENOTDEP */ db.g1, /*+ MAKENOTDEP */ db.g2 AS c WHERE a = b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline1() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getRightClause().setMakeDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 JOIN db.g2 MAKEDEP ON a = b", "SELECT a FROM db.g1 INNER JOIN /*+ MAKEDEP */ db.g2 ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline2() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 MAKEDEP JOIN db.g2 ON a = b", "SELECT a FROM /*+ MAKEDEP */ db.g1 INNER JOIN db.g2 ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline3() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeDep(true);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        jp2.getRightClause().setMakeDep(true);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From (db.g1 MAKEDEP JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 MAKEDEP ON a = c", "SELECT a FROM (/*+ MAKEDEP */ db.g1 INNER JOIN db.g2 ON a = b) LEFT OUTER JOIN /*+ MAKEDEP */ db.g3 ON a = c", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline4() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("c", "db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)b);
        From from = new From();
        UnaryFromClause clause = new UnaryFromClause(g1);
        clause.setMakeDep(true);
        from.addClause((FromClause)clause);
        UnaryFromClause clause1 = new UnaryFromClause(g2);
        clause1.setMakeDep(true);
        from.addClause((FromClause)clause1);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g1 MAKEDEP, db.g2 AS c MAKEDEP WHERE a = b", "SELECT a FROM /*+ MAKEDEP */ db.g1, /*+ MAKEDEP */ db.g2 AS c WHERE a = b", (Command)query);
    }

    @Test
    public void testOptionMakedep() throws Exception {
        String sql = "SELECT A.alert_id FROM (FSK_ALERT AS A MAKEDEP INNER JOIN Core.FSC_PARTY_DIM AS C ON A.primary_entity_key = C.PARTY_KEY) LEFT OUTER JOIN FSK_SCENARIO AS S ON A.scenario_id = S.scenario_id ";
        Query command = (Query)new QueryParser().parseCommand(sql);
        JoinPredicate predicate = (JoinPredicate)command.getFrom().getClauses().get(0);
        Assert.assertTrue((boolean)((JoinPredicate)predicate.getLeftClause()).getLeftClause().isMakeDep());
    }

    @Test
    public void testOptionMakeNotDepInline1() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getRightClause().setMakeNotDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 JOIN db.g2 MAKENOTDEP ON a = b", "SELECT a FROM db.g1 INNER JOIN /*+ MAKENOTDEP */ db.g2 ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeNotDepInline2() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeNotDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 MAKENOTDEP JOIN db.g2 ON a = b", "SELECT a FROM /*+ MAKENOTDEP */ db.g1 INNER JOIN db.g2 ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeNotDepInline3() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeNotDep(true);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        jp2.getRightClause().setMakeNotDep(true);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From (db.g1 MAKENOTDEP JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 MAKENOTDEP ON a = c", "SELECT a FROM (/*+ MAKENOTDEP */ db.g1 INNER JOIN db.g2 ON a = b) LEFT OUTER JOIN /*+ MAKENOTDEP */ db.g3 ON a = c", (Command)query);
    }

    @Test
    public void testDepOptions2() {
        GroupSymbol a = new GroupSymbol("a");
        GroupSymbol b = new GroupSymbol("b");
        ElementSymbol x = new ElementSymbol("a.x", true);
        ElementSymbol y = new ElementSymbol("b.y", true);
        CompareCriteria criteria = new CompareCriteria((Expression)x, 1, (Expression)new Function("func", new Expression[]{y}));
        JoinPredicate predicate = new JoinPredicate((FromClause)new UnaryFromClause(a), (FromClause)new UnaryFromClause(b), JoinType.JOIN_INNER, Arrays.asList(criteria));
        From from = new From(Arrays.asList(predicate));
        predicate.getLeftClause().setMakeNotDep(true);
        predicate.getRightClause().setMakeDep(true);
        Select select = new Select(Arrays.asList(x, y));
        Query query = new Query(select, from, null, null, null, null, null);
        TestParser.helpTest("Select a.x, b.y From a MAKENOTDEP INNER JOIN b MAKEDEP ON a.x = func(b.y)", "SELECT a.x, b.y FROM /*+ MAKENOTDEP */ a INNER JOIN /*+ MAKEDEP */ b ON a.x = func(b.y)", (Command)query);
    }

    @Test
    public void testOptionNoCache1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup("a.b.c");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option nocache a.b.c", "SELECT a FROM db.g OPTION NOCACHE a.b.c", (Command)query);
    }

    @Test
    public void testOptionNoCache2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup("a.b.c");
        option.addNoCacheGroup("d.e.f");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option nocache a.b.c, d.e.f", "SELECT a FROM db.g OPTION NOCACHE a.b.c, d.e.f", (Command)query);
    }

    @Test
    public void testOptionNoCache3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.setNoCache(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option nocache", "SELECT a FROM db.g OPTION NOCACHE", (Command)query);
    }

    @Test
    public void testFailsIllegalOption() {
        TestParser.helpException("SELECT a from g OPTION xyx");
    }

    @Test
    public void testInsertWithOption() {
        Insert insert = new Insert();
        insert.setGroup(new GroupSymbol("m.g"));
        ArrayList<ElementSymbol> vars = new ArrayList<ElementSymbol>();
        vars.add(new ElementSymbol("a"));
        insert.setVariables(vars);
        ArrayList<Reference> values = new ArrayList<Reference>();
        values.add(new Reference(0));
        insert.setValues(values);
        Option option = new Option();
        option.setNoCache(true);
        insert.setOption(option);
        TestParser.helpTest("INSERT INTO m.g (a) VALUES (?) OPTION NOCACHE", "INSERT INTO m.g (a) VALUES (?) OPTION NOCACHE", (Command)insert);
    }

    @Test
    public void testDeleteWithOption() {
        Delete delete = new Delete();
        delete.setGroup(new GroupSymbol("m.g"));
        Option option = new Option();
        option.setNoCache(true);
        delete.setOption(option);
        TestParser.helpTest("DELETE FROM m.g OPTION NOCACHE", "DELETE FROM m.g OPTION NOCACHE", (Command)delete);
    }

    @Test
    public void testUpdateWithOption() {
        Update update = new Update();
        update.setGroup(new GroupSymbol("m.g"));
        update.addChange(new ElementSymbol("a"), (Expression)new Reference(0));
        Option option = new Option();
        option.setNoCache(true);
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("b"), 1, (Expression)new Reference(1));
        update.setCriteria((Criteria)crit);
        update.setOption(option);
        TestParser.helpTest("UPDATE m.g SET a = ? WHERE b = ? OPTION NOCACHE", "UPDATE m.g SET a = ? WHERE b = ? OPTION NOCACHE", (Command)update);
    }

    @Test
    public void testOptionalFromClause1() {
        String sql = "SELECT * FROM /*+ optional */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_1() {
        String sql = "SELECT * FROM /*+ optional*/ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_2() {
        String sql = "SELECT * FROM /*+optional */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_3() {
        String sql = "SELECT * FROM /*+ optional  */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_4() {
        String sql = "SELECT * /*+ optional */ FROM /*+ OptiOnal  */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_5() {
        String sql = "SELECT * FROM /*+ OptiOnal  */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause2() {
        String sql = "SELECT * FROM t1, /*+ optional */ t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("t1"));
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t2"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1, /*+ optional */ t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause3() {
        String sql = "SELECT * FROM /*+ optional */ t1 AS a, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("a", "t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /*+ optional */ t1 AS a, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause4() {
        String sql = "SELECT * FROM t1, /*+ optional */ t2 as a";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("t1"));
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("a", "t2"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1, /*+ optional */ t2 AS a", (Command)query);
    }

    @Test
    public void testOptionalFromClause5() {
        String sql = "SELECT * FROM t1, /*+ optional */ (select * from t1, t2) as x";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        Query query2 = new Query();
        select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query2.setSelect(select);
        From from2 = new From();
        from2.addGroup(new GroupSymbol("t1"));
        from2.addGroup(new GroupSymbol("t2"));
        query2.setFrom(from2);
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)query2);
        sfc.setOptional(true);
        from.addGroup(new GroupSymbol("t1"));
        from.addClause((FromClause)sfc);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1, /*+ optional */ (SELECT * FROM t1, t2) AS x", (Command)query);
    }

    @Test
    public void testOptionalFromClause6() {
        String sql = "SELECT * FROM t1 INNER JOIN /*+ optional */ (select a from t1, t2) AS x ON t1.a=x.a";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        Query query2 = new Query();
        select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        From from2 = new From();
        from2.addGroup(new GroupSymbol("t1"));
        from2.addGroup(new GroupSymbol("t2"));
        query2.setSelect(select);
        query2.setFrom(from2);
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)query2);
        sfc.setOptional(true);
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t1.a"), 1, (Expression)new ElementSymbol("x.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)ufc, (FromClause)sfc, JoinType.JOIN_INNER, criteria);
        from.addClause((FromClause)joinPredicate);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1 INNER JOIN /*+ optional */ (SELECT a FROM t1, t2) AS x ON t1.a = x.a", (Command)query);
    }

    @Test
    public void testOptionalFromClause7() {
        String sql = "SELECT b FROM t1, /*+ optional */ (t2 INNER JOIN t3 ON t2.a = t3.a)";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t2"));
        UnaryFromClause ufc2 = new UnaryFromClause();
        ufc2.setGroup(new GroupSymbol("t3"));
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t2.a"), 1, (Expression)new ElementSymbol("t3.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)ufc, (FromClause)ufc2, JoinType.JOIN_INNER, criteria);
        joinPredicate.setOptional(true);
        UnaryFromClause ufc3 = new UnaryFromClause();
        ufc3.setGroup(new GroupSymbol("t1"));
        from.addClause((FromClause)ufc3);
        from.addClause((FromClause)joinPredicate);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT b FROM t1, /*+ optional */ (t2 INNER JOIN t3 ON t2.a = t3.a)", (Command)query);
    }

    @Test
    public void testOptionalFromClause8() {
        String sql = "SELECT b FROM t1, /*+ optional */ (/*+ optional */ (SELECT * FROM t1, t2) AS x INNER JOIN t3 ON x.a = t3.a)";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        Query query2 = new Query();
        select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        From from2 = new From();
        from2.addGroup(new GroupSymbol("t1"));
        from2.addGroup(new GroupSymbol("t2"));
        query2.setSelect(select);
        query2.setFrom(from2);
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)query2);
        sfc.setOptional(true);
        UnaryFromClause ufc2 = new UnaryFromClause();
        ufc2.setGroup(new GroupSymbol("t3"));
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("x.a"), 1, (Expression)new ElementSymbol("t3.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)sfc, (FromClause)ufc2, JoinType.JOIN_INNER, criteria);
        joinPredicate.setOptional(true);
        UnaryFromClause ufc3 = new UnaryFromClause();
        ufc3.setGroup(new GroupSymbol("t1"));
        from.addClause((FromClause)ufc3);
        from.addClause((FromClause)joinPredicate);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT b FROM t1, /*+ optional */ (/*+ optional */ (SELECT * FROM t1, t2) AS x INNER JOIN t3 ON x.a = t3.a)", (Command)query);
    }

    @Test
    public void testOptionalFromClause9() {
        String sql = "SELECT b FROM (t1 LEFT OUTER JOIN /*+ optional */t2 on t1.a = t2.a) LEFT OUTER JOIN /*+ optional */t3 on t1.a = t3.a";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        UnaryFromClause ufc2 = new UnaryFromClause();
        ufc2.setGroup(new GroupSymbol("t2"));
        ufc2.setOptional(true);
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t1.a"), 1, (Expression)new ElementSymbol("t2.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)ufc, (FromClause)ufc2, JoinType.JOIN_LEFT_OUTER, criteria);
        UnaryFromClause ufc3 = new UnaryFromClause();
        ufc3.setGroup(new GroupSymbol("t3"));
        ufc3.setOptional(true);
        criteria = new ArrayList();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t1.a"), 1, (Expression)new ElementSymbol("t3.a")));
        JoinPredicate joinPredicate2 = new JoinPredicate((FromClause)joinPredicate, (FromClause)ufc3, JoinType.JOIN_LEFT_OUTER, criteria);
        from.addClause((FromClause)joinPredicate2);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT b FROM (t1 LEFT OUTER JOIN /*+ optional */ t2 ON t1.a = t2.a) LEFT OUTER JOIN /*+ optional */ t3 ON t1.a = t3.a", (Command)query);
    }

    @Test
    public void testStoredQueryWithOption() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        Option option = new Option();
        option.setNoCache(true);
        storedQuery.setOption(option);
        TestParser.helpTest("exec proc1() option nocache", "EXEC proc1() OPTION NOCACHE", (Command)storedQuery);
    }

    @Test
    public void testOptionMakeDependent1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.addDependentGroup("a.b.c");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makedep a.b.c", "SELECT a FROM db.g OPTION MAKEDEP a.b.c", (Command)query);
    }

    @Test
    public void testOptionMakeDependent2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.addDependentGroup("a.b.c");
        option.addDependentGroup("d.e.f");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makedep a.b.c, d.e.f", "SELECT a FROM db.g OPTION MAKEDEP a.b.c, d.e.f", (Command)query);
    }

    @Test
    public void testOptionMakeDependent3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.addDependentGroup("a.b.c");
        option.addDependentGroup("d.e.f");
        option.addDependentGroup("x.y.z");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makedep a.b.c, d.e.f, x.y.z", "SELECT a FROM db.g OPTION MAKEDEP a.b.c, d.e.f, x.y.z", (Command)query);
    }

    @Test
    public void testOptionMakeNotDependent1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.addNotDependentGroup("a.b.c");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makenotdep a.b.c", "SELECT a FROM db.g OPTION MAKENOTDEP a.b.c", (Command)query);
    }

    @Test
    public void testOptionMakeNotDependent2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.addNotDependentGroup("a.b.c");
        option.addNotDependentGroup("d.e.f");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makeNOTdep a.b.c, d.e.f", "SELECT a FROM db.g OPTION MAKENOTDEP a.b.c, d.e.f", (Command)query);
    }

    @Test
    public void testOptionMakeNotDependent3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Option option = new Option();
        option.addNotDependentGroup("a.b.c");
        option.addNotDependentGroup("d.e.f");
        option.addNotDependentGroup("x.y.z");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makenotdep a.b.c, d.e.f, x.y.z", "SELECT a FROM db.g OPTION MAKENOTDEP a.b.c, d.e.f, x.y.z", (Command)query);
    }

    @Test
    public void testDepOptions1() {
        GroupSymbol a = new GroupSymbol("a");
        GroupSymbol b = new GroupSymbol("b");
        ElementSymbol x = new ElementSymbol("a.x", true);
        ElementSymbol y = new ElementSymbol("b.y", true);
        From from = new From(Arrays.asList(new UnaryFromClause(a), new UnaryFromClause(b)));
        Option option = new Option();
        option.addDependentGroup("a");
        option.addNotDependentGroup("b");
        Select select = new Select(Arrays.asList(x, y));
        CompareCriteria criteria = new CompareCriteria((Expression)x, 1, (Expression)y);
        Query query = new Query(select, from, (Criteria)criteria, null, null, null, option);
        TestParser.helpTest("Select a.x, b.y From a, b WHERE a.x = b.y option makedep a makenotdep b", "SELECT a.x, b.y FROM a, b WHERE a.x = b.y OPTION MAKEDEP a MAKENOTDEP b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline5() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.setMakeDep(true);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From (db.g1 JOIN db.g2 ON a = b) makedep LEFT OUTER JOIN db.g3 ON a = c", "SELECT a FROM /*+ MAKEDEP */ (db.g1 INNER JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 ON a = c", (Command)query);
        TestParser.helpTest(query.toString(), query.toString(), (Command)query);
    }

    @Test
    public void testOptionMakeDepOptionsComment() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        Option.MakeDep makeDep = new Option.MakeDep();
        makeDep.setMax(Integer.valueOf(5));
        makeDep.setJoin(Boolean.valueOf(false));
        jp.setMakeDep(makeDep);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From /*+ MAKEDEP(max:5 no join) */ (db.g1 JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 ON a = c", "SELECT a FROM /*+ MAKEDEP(MAX:5 NO JOIN) */ (db.g1 INNER JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 ON a = c", (Command)query);
        TestParser.helpTest(query.toString(), query.toString(), (Command)query);
    }

    @Test
    public void testCache() {
        String sql = "/*+ cache */ SELECT * FROM t1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t1"));
        query.setFrom(from);
        query.setCacheHint(new CacheHint());
        TestParser.helpTest(sql, "/*+ cache */ SELECT * FROM t1", (Command)query);
    }

    @Test
    public void testCacheMultipleComments() {
        String sql = "/* hello */ /*+ cache */ /* world */ SELECT * FROM t1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t1"));
        query.setFrom(from);
        query.setCacheHint(new CacheHint());
        TestParser.helpTest(sql, "/*+ cache */ SELECT * FROM t1", (Command)query);
    }

    @Test
    public void testCacheProc() {
        String sql = "/*+ cache */ CREATE VIRTUAL PROCEDURE BEGIN END";
        CreateProcedureCommand command = new CreateProcedureCommand(new Block());
        command.setCacheHint(new CacheHint());
        TestParser.helpTest(sql, "/*+ cache */ BEGIN\nEND", (Command)command);
    }

    @Test
    public void testCacheScope() {
        String sql = "/*+ cache(pref_mem scope:session) */ SELECT * FROM t1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t1"));
        query.setFrom(from);
        CacheHint hint = new CacheHint();
        hint.setScope(CacheDirective.Scope.SESSION);
        hint.setPrefersMemory(Boolean.valueOf(true));
        query.setCacheHint(hint);
        TestParser.helpTest(sql, "/*+ cache(pref_mem scope:SESSION) */ SELECT * FROM t1", (Command)query);
    }

    @Test
    public void testCache1() {
        String sql = "/*+ cache */ execute foo()";
        StoredProcedure sp = new StoredProcedure();
        sp.setCacheHint(new CacheHint());
        sp.setProcedureName("foo");
        TestParser.helpTest(sql, "/*+ cache */ EXEC foo()", (Command)sp);
    }

    @Test
    public void testExpandedCacheHint() {
        String sql = "/*+ cache( pref_mem ttl:2000) */ SELECT * FROM t1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t1"));
        query.setFrom(from);
        CacheHint hint = new CacheHint();
        hint.setPrefersMemory(Boolean.valueOf(true));
        hint.setTtl(Long.valueOf(2000L));
        query.setCacheHint(hint);
        TestParser.helpTest(sql, "/*+ cache(pref_mem ttl:2000) */ SELECT * FROM t1", (Command)query);
    }

    @Test
    public void testCacheHintUnion() {
        String sql = "/*+ cache( pref_mem) */ SELECT * FROM t1 union select * from t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t1"));
        query.setFrom(from);
        Query query1 = new Query();
        select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query1.setSelect(select);
        from = new From();
        ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t2"));
        query1.setFrom(from);
        SetQuery sq = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)query, (QueryCommand)query1);
        CacheHint hint = new CacheHint();
        hint.setPrefersMemory(Boolean.valueOf(true));
        sq.setCacheHint(hint);
        TestParser.helpTest(sql, "/*+ cache(pref_mem) */ SELECT * FROM t1 UNION SELECT * FROM t2", (Command)sq);
    }

    @Test
    public void testCacheHintCallableStatement() {
        String sql = "/*+ cache */ { ? = call proc() }";
        StoredProcedure sp = new StoredProcedure();
        SPParameter param = new SPParameter(1, null);
        param.setParameterType(4);
        sp.setParameter(param);
        sp.setProcedureName("proc");
        sp.setCallableStatement(true);
        CacheHint hint = new CacheHint();
        sp.setCacheHint(hint);
        TestParser.helpTest(sql, "/*+ cache */ ? = EXEC proc()", (Command)sp);
    }

    @Test
    public void testMergeJoinHint() {
        String sql = "SELECT e1 FROM m.g2 WHERE EXISTS /*+ MJ */ (SELECT e1 FROM m.g1)";
        Query q = TestParser.exampleExists(true);
        TestParser.helpTest(sql, "SELECT e1 FROM m.g2 WHERE EXISTS /*+ MJ */ (SELECT e1 FROM m.g1)", (Command)q);
    }

    @Test
    public void testMergeJoinHint1() {
        String sql = "SELECT a FROM db.g WHERE b IN /*+ MJ */ (SELECT a FROM db.g WHERE a2 = 5)";
        Query q = TestParser.exampleIn(true);
        TestParser.helpTest(sql, "SELECT a FROM db.g WHERE b IN /*+ MJ */ (SELECT a FROM db.g WHERE a2 = 5)", (Command)q);
    }

    @Test
    public void testNoUnnest() throws QueryParserException {
        String sql = "SELECT a FROM /*+ no_unnest */ (SELECT a FROM db.g WHERE a2 = 5) x";
        Assert.assertEquals((Object)"SELECT a FROM /*+ NO_UNNEST */ (SELECT a FROM db.g WHERE a2 = 5) AS x", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testNoUnnest1() throws QueryParserException {
        String sql = "SELECT a FROM db.g WHERE a2 = all /*+ no_unnest */ (select a from db.g)";
        Assert.assertEquals((Object)"SELECT a FROM db.g WHERE a2 = ALL /*+ NO_UNNEST */ (SELECT a FROM db.g)", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testNoUnnest2() throws QueryParserException {
        String sql = "SELECT a FROM db.g WHERE a2 = /*+ no_unnest */ (select a from db.g)";
        Assert.assertEquals((Object)"SELECT a FROM db.g WHERE a2 = /*+ NO_UNNEST */ (SELECT a FROM db.g)", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testNonStrictLimit() throws QueryParserException {
        String sql = "SELECT a FROM x /*+ non_strict */ limit 1";
        Assert.assertEquals((Object)"SELECT a FROM x /*+ NON_STRICT */ LIMIT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
        sql = "SELECT a FROM x /*+ non_strict */ offset 1 row";
        Assert.assertEquals((Object)"SELECT a FROM x /*+ NON_STRICT */ OFFSET 1 ROWS", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
        sql = "SELECT a FROM x /*+ non_strict */ fetch first 1 rows only";
        Assert.assertEquals((Object)"SELECT a FROM x /*+ NON_STRICT */ LIMIT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testNestedComments() throws QueryParserException {
        String sql = "/*+ /*nested*/ */ SELECT a FROM x limit 1";
        Assert.assertEquals((Object)"SELECT a FROM x LIMIT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testSourceHint() throws QueryParserException {
        String sql = "SELECT /*+ sh:'foo' oracle:'leading' */ a FROM x limit 1";
        Assert.assertEquals((Object)"SELECT /*+sh:'foo' oracle:'leading' */ a FROM x LIMIT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
        sql = "(SELECT /*+ sh:'foo' oracle:'leading' */ a FROM x limit 1) union all select 1";
        Assert.assertEquals((Object)"(SELECT /*+sh:'foo' oracle:'leading' */ a FROM x LIMIT 1) UNION ALL SELECT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
        sql = "(SELECT /*+ sh keep aliases:'foo' oracle keep aliases:'leading' */ a FROM x limit 1) union all select 1";
        Assert.assertEquals((Object)"(SELECT /*+sh KEEP ALIASES:'foo' oracle KEEP ALIASES:'leading' */ a FROM x LIMIT 1) UNION ALL SELECT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
        sql = "(SELECT /*+ sh keep aliases oracle:'leading' */ a FROM x limit 1) union all select 1";
        Assert.assertEquals((Object)"(SELECT /*+sh KEEP ALIASES oracle:'leading' */ a FROM x LIMIT 1) UNION ALL SELECT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testNestedSourceHint() throws QueryParserException {
        String sql = "WITH x as (SELECT /*+ sh:'x' */ 1) SELECT /*+ sh:'foo' bar:'leading' */ e1 from pm1.g1 order by e1 limit 1";
        Assert.assertEquals((Object)"WITH x AS (SELECT /*+sh:'x' */ 1) SELECT /*+sh:'foo' bar:'leading' */ e1 FROM pm1.g1 ORDER BY e1 LIMIT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
        sql = "create virtual procedure begin loop on (select /*+ sh:'y' */ 1) as x begin end end";
        Assert.assertEquals((Object)"BEGIN\nLOOP ON (SELECT /*+sh:'y' */ 1) AS x\nBEGIN\nEND\nEND", (Object)QueryParser.getQueryParser().parseDesignerCommand(sql).toString());
    }

    @Test
    public void testNoInline() throws QueryParserException {
        String sql = "WITH x as /*+no_inline*/ (SELECT 1) SELECT e1 from pm1.g1 order by e1 limit 1";
        Assert.assertEquals((Object)"WITH x AS /*+ no_inline */ (SELECT 1) SELECT e1 FROM pm1.g1 ORDER BY e1 LIMIT 1", (Object)QueryParser.getQueryParser().parseCommand(sql, ParseInfo.DEFAULT_INSTANCE).toString());
    }

    @Test
    public void testMakedepOptions() throws QueryParserException {
        String sql = "Select a From db.g1 JOIN db.g2 MAKEDEP(max:300) ON a = b";
        Assert.assertEquals((Object)"SELECT a FROM db.g1 INNER JOIN /*+ MAKEDEP(MAX:300) */ db.g2 ON a = b", (Object)QueryParser.getQueryParser().parseCommand(sql, new ParseInfo()).toString());
    }

    @Test
    public void testMakeindOptions() throws QueryParserException {
        String sql = "Select a From db.g1 JOIN db.g2 MAKEIND(max:300 no join) ON a = b";
        Assert.assertEquals((Object)"SELECT a FROM db.g1 INNER JOIN /*+ MAKEIND(MAX:300 NO JOIN) */ db.g2 ON a = b", (Object)QueryParser.getQueryParser().parseCommand(sql, new ParseInfo()).toString());
    }
}

