/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.Arrays;
import org.junit.Test;
import org.teiid.query.parser.TestParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;

public class TestLimitParsing {
    @Test
    public void testLimit() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit(null, (Expression)new Constant((Object)new Integer(100))));
        TestParser.helpTest("Select * from a limit 100", "SELECT * FROM a LIMIT 100", (Command)query);
    }

    @Test
    public void testLimitWithOffset() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Constant((Object)new Integer(50)), (Expression)new Constant((Object)new Integer(100))));
        TestParser.helpTest("Select * from a limit 50,100", "SELECT * FROM a LIMIT 50, 100", (Command)query);
    }

    @Test
    public void testLimitWithReferences1() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Reference(0), (Expression)new Constant((Object)new Integer(100))));
        TestParser.helpTest("Select * from a limit ?,100", "SELECT * FROM a LIMIT ?, 100", (Command)query);
    }

    @Test
    public void testLimitWithReferences2() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Constant((Object)new Integer(50)), (Expression)new Reference(0)));
        TestParser.helpTest("Select * from a limit 50,?", "SELECT * FROM a LIMIT 50, ?", (Command)query);
    }

    @Test
    public void testLimitWithReferences3() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Reference(0), (Expression)new Reference(1)));
        TestParser.helpTest("Select * from a limit ?,?", "SELECT * FROM a LIMIT ?, ?", (Command)query);
    }

    @Test
    public void testSetQueryLimit() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        SetQuery setQuery = new SetQuery(SetQuery.Operation.UNION, true, (QueryCommand)query, (QueryCommand)query);
        setQuery.setLimit(new Limit((Expression)new Reference(0), (Expression)new Reference(1)));
        TestParser.helpTest("Select * from a union all Select * from a limit ?,?", "SELECT * FROM a UNION ALL SELECT * FROM a LIMIT ?, ?", (Command)setQuery);
    }

    @Test
    public void testOffset() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Reference(0), null));
        TestParser.helpTest("Select * from a offset ? rows", "SELECT * FROM a OFFSET ? ROWS", (Command)query);
    }

    @Test
    public void testFetchFirst() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit(null, (Expression)new Constant((Object)2)));
        TestParser.helpTest("Select * from a fetch first 2 rows only", "SELECT * FROM a LIMIT 2", (Command)query);
    }

    @Test
    public void testFetchFirstRow() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit(null, (Expression)new Constant((Object)1)));
        TestParser.helpTest("Select * from a fetch first row only", "SELECT * FROM a LIMIT 1", (Command)query);
    }

    @Test
    public void testOffsetFetch() {
        Query query = new Query();
        Select select = new Select(Arrays.asList(new MultipleElementSymbol()));
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("a"))));
        query.setSelect(select);
        query.setFrom(from);
        query.setLimit(new Limit((Expression)new Constant((Object)2), (Expression)new Constant((Object)5)));
        TestParser.helpTest("Select * from a offset 2 rows fetch first 5 rows only", "SELECT * FROM a LIMIT 2, 5", (Command)query);
    }
}

