/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.aggregate.SingleArgumentAggregateFunction;
import org.teiid.query.util.CommandContext;

public class ArrayAgg
extends SingleArgumentAggregateFunction {
    private ArrayList<Object> result;
    private Class<?> componentType;

    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
        this.componentType = inputType;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple, CommandContext commandContext) throws TeiidComponentException, TeiidProcessingException {
        if (this.result == null) {
            this.result = new ArrayList();
        }
        this.result.add(input);
        if (this.result.size() > 1000) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31205, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31205, new Object[]{1000}));
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        if (this.result == null) {
            return null;
        }
        if (this.componentType == DataTypeManager.DefaultDataClasses.OBJECT) {
            return new ArrayImpl(this.result.toArray());
        }
        Object array = Array.newInstance(this.componentType, this.result.size());
        for (int i = 0; i < this.result.size(); ++i) {
            Object[] val = this.result.get(i);
            if (val instanceof ArrayImpl) {
                val = ((ArrayImpl)val).getValues();
            }
            Array.set(array, i, val);
        }
        return new ArrayImpl((Object[])array);
    }

    @Override
    public void reset() {
        this.result = null;
    }

    @Override
    public boolean respectsNull() {
        return true;
    }
}

