/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.TestProcedureProcessor;
import org.teiid.query.processor.relational.DependentProcedureExecutionNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestProcedureRelational {
    @Test
    public void testProcInExistsSubquery() throws Exception {
        String sql = "select pm1.g1.e1 from pm1.g1 where exists (select * from (EXEC pm1.vsp9(pm1.g1.e2 + 1)) x where x.e1 = pm1.g1.e1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcTableFunction() throws Exception {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 as x, texttable('abc' columns a string) as y where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcInSelectScalarSubquery() throws Exception {
        String sql = "select (EXEC pm1.vsp36(pm1.g1.e2)) from pm1.g1 where pm1.g1.e1 = 'a'";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTable() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertFalse((boolean)plan.requiresTransaction(false));
        Assert.assertTrue((boolean)plan.requiresTransaction(true));
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAliasedProcAsTable() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 as x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAliasedJoin() {
        String sql = "select x.param1, x.param2, y.param1, y.param2, x.e1 from pm1.vsp26 as x, pm1.vsp26 as y where x.param1=1 and x.param2='a' and y.param1 = 2 and y.param2 = 'b'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", new Integer(2), "b", "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testAliasedJoin1() {
        String sql = "select x.param1, x.param2, y.param1, y.param2, x.e1 from pm1.vsp26 as x, pm1.vsp26 as y where x.param1=1 and x.param2='a' and y.param1 = x.param1 and y.param2 = x.param2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", new Integer(1), "a", "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTable1() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=1";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTable2() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1<1 and param2='a'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTable3() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1 in (1,2,3) and param2 in ('a', 'b') order by param1, param2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a", "a", new Integer(3)), Arrays.asList(new Integer(1), "b", "b", new Integer(2)), Arrays.asList(new Integer(2), "a", "a", new Integer(3)), Arrays.asList(new Integer(2), "b", "b", new Integer(2)), Arrays.asList(new Integer(3), "a", "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTable4() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=1 and not(param2 = 'a')";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTable5() {
        String sql = "select param1, param2, e1, e2 from pm1.vsp26 where param1=e2 and param2 = 'a'";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, TestOptimizer.getGenericFinder(), null, false);
    }

    @Test
    public void testProcAsTableInJoin() {
        String sql = "select param1, param2, pm1.vsp26.e2 from pm1.vsp26, pm1.g1 where param1 = pm1.g1.e2 and param2 = pm1.g1.e1 order by param1, param2, e2";
        List[] expected = new List[]{Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(0)), Arrays.asList(new Integer(0), "a", new Integer(3)), Arrays.asList(new Integer(0), "a", new Integer(3)), Arrays.asList(new Integer(1), "c", new Integer(1)), Arrays.asList(new Integer(2), "b", new Integer(2)), Arrays.asList(new Integer(3), "a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTableInJoinWithOutJoinPredicate() {
        String sql = "select param1, param2, pm1.vsp26.e2, pm1.g1.e2 from pm1.vsp26, pm1.g1 where pm1.vsp26.e2 = pm1.g1.e2 and param1 = pm1.g1.e2 and param2 = pm1.g1.e1 order by param1, param2, pm1.vsp26.e2";
        List[] expected = new List[]{Arrays.asList(new Integer(0), "a", new Integer(0), 0), Arrays.asList(new Integer(0), "a", new Integer(0), 0), Arrays.asList(new Integer(0), "a", new Integer(0), 0), Arrays.asList(new Integer(0), "a", new Integer(0), 0), Arrays.asList(new Integer(1), "c", new Integer(1), 1), Arrays.asList(new Integer(2), "b", new Integer(2), 2), Arrays.asList(new Integer(3), "a", new Integer(3), 3)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsTableInSubquery() {
        String sql = "select param1, param2, pm1.vsp26.e2, (select count(e1) from pm1.vsp26 where param1 = 1 and param2 = 'a') x from pm1.vsp26, pm1.g1 where param1 = pm1.g1.e2 and param2 = pm1.g1.e1 order by param1, param2, e2";
        List[] expected = new List[]{Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(3), new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(3), new Integer(1)), Arrays.asList(new Integer(1), "c", new Integer(1), new Integer(1)), Arrays.asList(new Integer(2), "b", new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), "a", new Integer(3), new Integer(1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private void helpTestProcRelational(String userQuery, String inputCriteria, String atomicQuery) {
        ProcessorPlan plan = TestOptimizer.helpPlan(userQuery, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0]);
        RelationalPlan rplan = (RelationalPlan)plan;
        RelationalNode root = rplan.getRootNode();
        while (root.getChildren() != null && !((root = root.getChildren()[0]) instanceof DependentProcedureExecutionNode)) {
        }
        DependentProcedureExecutionNode dep = (DependentProcedureExecutionNode)root;
        Assert.assertEquals((Object)inputCriteria, (Object)dep.getInputCriteria().toString());
        ProcedurePlan pp = (ProcedurePlan)dep.getProcessorPlan();
        CreateCursorResultSetInstruction ccrsi = (CreateCursorResultSetInstruction)pp.getOriginalProgram().getInstructionAt(0);
        plan = ccrsi.getCommand();
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        TestOptimizer.checkAtomicQueries(new String[]{atomicQuery}, plan);
    }

    @Test
    public void testProcInVirtualGroup1() {
        String userQuery = "select e1 from pm1.vsp26 where param1=1 and param2='a'";
        String inputCriteria = "(pm1.vsp26.param1 = 1) AND (pm1.vsp26.param2 = 'a')";
        String atomicQuery = "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE (g_0.e2 >= pm1.vsp26.param1) AND (g_0.e1 = pm1.vsp26.param2)";
        this.helpTestProcRelational(userQuery, inputCriteria, atomicQuery);
    }

    @Test
    public void testCase3403() {
        String userQuery = "select e1 from pm1.vsp26 where param1=2 and param2='a' and 'x'='x'";
        String inputCriteria = "(pm1.vsp26.param1 = 2) AND (pm1.vsp26.param2 = 'a')";
        String atomicQuery = "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE (g_0.e2 >= pm1.vsp26.param1) AND (g_0.e1 = pm1.vsp26.param2)";
        this.helpTestProcRelational(userQuery, inputCriteria, atomicQuery);
    }

    @Test
    public void testCase3448() {
        String userQuery = "select e1 from pm1.vsp26 where (param1=1 and e2=2) and param2='a'";
        String inputCriteria = "(pm1.vsp26.param1 = 1) AND (pm1.vsp26.param2 = 'a')";
        String atomicQuery = "SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0 WHERE (g_0.e2 >= pm1.vsp26.param1) AND (g_0.e1 = pm1.vsp26.param2)";
        this.helpTestProcRelational(userQuery, inputCriteria, atomicQuery);
    }

    @Test
    public void testProcAsVirtualGroup2() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup3() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup4() {
        String sql = "SELECT P.e1 as ve3 FROM pm1.vsp26 as P, pm1.g2 where P.e1=g2.e1 and param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup5() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2='a' and e1='a'";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup6() {
        String sql = "SELECT P.e1 as ve3 FROM pm1.vsp26 as P, vm1.g1 where P.e1=g1.e1 and param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup7() {
        String sql = "SELECT e1 FROM (SELECT p.e1, param1, param2 FROM pm1.vsp26 as P, vm1.g1 where P.e1=g1.e1) x where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup10_Defect20164() {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where (param1=1 and param2='a') and e1='c'";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup8() {
        String sql = "SELECT P.e1 as ve3, P.e2 as ve4 FROM pm1.vsp26 as P where param1=1 and param2='a' and e2=3";
        List[] expected = new List[]{Arrays.asList("a", new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup9() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "FOO")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void defer_testProcAsVirtualGroup9a() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(2112), "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    public void defer_testProcAsVirtualGroup9b() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P";
        List[] expected = new List[]{Arrays.asList(new Integer(2112), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testParameterPassing() throws Exception {
        MetadataStore metadataStore = new MetadataStore();
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("v1.rs1", new String[]{"e1"}, new String[]{"string"});
        QueryNode n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN declare string VARIABLES.x = '1'; SELECT e1 FROM v1.vp2 where v1.vp2.in = VARIABLES.x; END");
        Procedure vt1 = RealMetadataFactory.createVirtualProcedure("vp1", v1, null, n1);
        vt1.setResultSet(rs1);
        ProcedureParameter p1 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode n2 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN declare string VARIABLES.x; declare string VARIABLES.y; VARIABLES.x = '2'; VARIABLES.y = v1.vp2.in; select VARIABLES.y; end");
        Procedure vt2 = RealMetadataFactory.createVirtualProcedure("vp2", v1, Arrays.asList(p1), n2);
        vt2.setResultSet(RealMetadataFactory.createResultSet("v1.rs1", new String[]{"e1"}, new String[]{"string"}));
        String sql = "select * from (exec v1.vp1()) foo";
        List[] expected = new List[]{Arrays.asList("1")};
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "foo", new FunctionTree[0]);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        TestProcedureProcessor.helpTestProcess(plan, expected, new FakeDataManager(), (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCase6395ProcAsVirtualGroup9() {
        String sql = "SELECT P.e2 as ve3, P.e1 as ve4 FROM pm1.vsp47 as P where param1=1 and param2='a'";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "FOO")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup2WithNull() throws Exception {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2 is null";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        try {
            ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
            TestProcessor.doProcess(plan, dataManager, expected, TestProcessor.createCommandContext());
            Assert.fail((String)"QueryPlannerException was expected.");
        }
        catch (QueryValidatorException e) {
            Assert.assertEquals((Object)"TEIID30164 The procedure parameter pm1.vsp26.param2 is not nullable, but is set to null.", (Object)e.getMessage());
        }
    }

    @Test
    public void testProcAsVirtualGroup2WithNull2() throws Exception {
        String sql = "select * from pm1.vsp47 where param1 is null and param2 is null";
        List[] expected = new List[]{Arrays.asList(null, new Integer(2112), null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcAsVirtualGroup2WithNull3() throws Exception {
        String sql = "select e1 from (SELECT * FROM pm1.vsp26 as P where P.e1='a') x where param1=1 and param2 = commandpayload()";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testIssue119() throws Exception {
        MetadataStore metadataStore = new MetadataStore();
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        ProcedureParameter in = RealMetadataFactory.createParameter("in1", 1, "integer");
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("v1.vp1.rs1", new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"integer", "integer", "integer", "integer", "integer"});
        QueryNode n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT vp1.in1 e1, x.in1 e2, x.e1 e3, y.in1 e4, y.e1 e5 FROM pm1.sp119 x, pm1.sp119 y where x.in1 = vp1.in1 and y.in1 = x.e1; END");
        Procedure vt1 = RealMetadataFactory.createVirtualProcedure("vp1", v1, Arrays.asList(in), n1);
        vt1.setResultSet(rs1);
        ProcedureParameter in1 = RealMetadataFactory.createParameter("in1", 1, "integer");
        ColumnSet<Procedure> rs3 = RealMetadataFactory.createResultSet("pm1.sp119.rs1", new String[]{"e1"}, new String[]{"integer"});
        Procedure sp1 = RealMetadataFactory.createStoredProcedure("sp119", pm1, Arrays.asList(in1));
        sp1.setResultSet(rs3);
        String sql = "select * from (exec v1.vp1(1)) foo order by e4, e5";
        List[] expected = new List[]{Arrays.asList(1, 1, 3, 3, 5), Arrays.asList(1, 1, 3, 3, 8), Arrays.asList(1, 1, 6, 6, 8), Arrays.asList(1, 1, 6, 6, 11)};
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "foo", new FunctionTree[0]);
        ProcessorPlan plan = TestProcedureProcessor.getProcedurePlan(sql, (QueryMetadataInterface)metadata);
        HardcodedDataManager dataManager = new HardcodedDataManager(){

            @Override
            public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException {
                if (command instanceof StoredProcedure) {
                    StoredProcedure proc = (StoredProcedure)command;
                    List params = proc.getInputParameters();
                    Assert.assertEquals((long)1L, (long)params.size());
                    int value = (Integer)((Constant)((SPParameter)params.get(0)).getExpression()).getValue();
                    return new FakeTupleSource(command.getProjectedSymbols(), new List[]{Arrays.asList(value + 2), Arrays.asList(value + 5)});
                }
                return super.registerRequest(context, command, modelName, parameterObject);
            }
        };
        TestProcedureProcessor.helpTestProcess(plan, expected, dataManager, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testProcRelationalWithNoInputs() {
        String sql = "select e1 from pm1.vsp2 order by e1 desc limit 1";
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testProcRelationalWithNoInputs1() {
        String sql = "select e1 from pm1.sp1";
        List[] expected = new List[]{Arrays.asList("c")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", expected);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.createTransformationMetadata(RealMetadataFactory.example1Store(), "e1", new FunctionTree[0]));
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

