/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import junit.framework.TestCase;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.FileStore;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.NodeDescriptor;

public class TestSAXDocumentInProgress
extends TestCase {
    public static String originalText = "  Hello\t\t my \n    \n tests for preserve, \t \r\n replace, collapse.\n  ";

    public TestSAXDocumentInProgress(String name) {
        super(name);
    }

    public void testLargeDocument() throws Exception {
        FileStore fs = BufferManagerFactory.getStandaloneBufferManager().createFileStore("test");
        DocumentInProgress doc = new DocumentInProgress(fs, "UTF-8");
        doc.setDocumentFormat(true);
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"Root", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        doc.addElement(descriptor, (NodeDescriptor)null);
        doc.moveToLastChild();
        descriptor = NodeDescriptor.createNodeDescriptor((String)"a1", null, (boolean)false, null, null, null, (boolean)false, null, (String)"preserve");
        doc.addAttribute(descriptor, "test1");
        descriptor = NodeDescriptor.createNodeDescriptor((String)"a1", null, (boolean)false, null, null, null, (boolean)false, null, (String)"preserve");
        doc.addAttribute(descriptor, "test2");
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Child", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        for (int i = 0; i < 50; ++i) {
            doc.addElement(descriptor, "test content");
        }
        doc.moveToParent();
        doc.markAsFinished();
    }

    public void testNormalizationPreserve() throws Exception {
        TestSAXDocumentInProgress.assertEquals((String)DocumentInProgress.normalizeText((String)originalText, (String)"preserve"), (String)originalText);
    }

    public void testNormalizationReplace() throws Exception {
        String expectedResult = "  Hello   my        tests for preserve,      replace, collapse.   ";
        TestSAXDocumentInProgress.assertEquals((String)DocumentInProgress.normalizeText((String)originalText, (String)"replace"), (String)expectedResult);
    }

    public void testNormalizationCollapse() throws Exception {
        String expectedResult = "Hello my tests for preserve, replace, collapse.";
        TestSAXDocumentInProgress.assertEquals((String)DocumentInProgress.normalizeText((String)originalText, (String)"collapse"), (String)expectedResult);
    }
}

