/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.crypto.BasicCryptor;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.util.ArgCheck;

public class SymmetricCryptor
extends BasicCryptor {
    public static final String DEFAULT_SYM_KEY_ALGORITHM = "AES";
    public static final String ECB_SYM_ALGORITHM = "AES/ECB/PKCS5Padding";
    public static final String CBC_SYM_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_BITS = 128;
    public static final String DEFAULT_STORE_PASSWORD = "changeit";
    public static final String DEFAULT_ALIAS = "cluster_key";
    private static KeyGenerator keyGen;

    public static SymmetricCryptor getSymmectricCryptor(boolean cbc) throws CryptoException {
        SecretKey key = SymmetricCryptor.generateKey();
        return new SymmetricCryptor(key, cbc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey generateKey() throws CryptoException {
        try {
            Class<SymmetricCryptor> clazz = SymmetricCryptor.class;
            synchronized (SymmetricCryptor.class) {
                if (keyGen == null) {
                    keyGen = KeyGenerator.getInstance(DEFAULT_SYM_KEY_ALGORITHM);
                }
                keyGen.init(128);
                // ** MonitorExit[var0] (shouldn't be in output)
                return keyGen.generateKey();
            }
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10021, (Throwable)e);
        }
    }

    public static SymmetricCryptor getSymmectricCryptor(URL keyResource) throws CryptoException, IOException {
        ArgCheck.isNotNull(keyResource);
        InputStream stream = keyResource.openStream();
        try {
            KeyStore store = KeyStore.getInstance("JCEKS");
            store.load(stream, DEFAULT_STORE_PASSWORD.toCharArray());
            Key key = store.getKey(DEFAULT_ALIAS, DEFAULT_STORE_PASSWORD.toCharArray());
            SymmetricCryptor symmetricCryptor = new SymmetricCryptor(key, true);
            return symmetricCryptor;
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10022, (Throwable)e);
        }
        finally {
            stream.close();
        }
    }

    public static SymmetricCryptor getSymmectricCryptor(byte[] key, boolean cbc) throws CryptoException {
        SecretKeySpec secretKey = new SecretKeySpec(key, DEFAULT_SYM_KEY_ALGORITHM);
        return new SymmetricCryptor(secretKey, cbc);
    }

    public static void generateAndSaveKey(String file) throws CryptoException, IOException {
        SecretKey key = SymmetricCryptor.generateKey();
        SymmetricCryptor.saveKey(file, key);
    }

    private static void saveKey(String file, SecretKey key) throws CryptoException, IOException {
        ArgCheck.isNotNull(file);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            KeyStore store = KeyStore.getInstance("JCEKS");
            store.load(null, null);
            store.setKeyEntry(DEFAULT_ALIAS, key, DEFAULT_STORE_PASSWORD.toCharArray(), null);
            store.store(fos, DEFAULT_STORE_PASSWORD.toCharArray());
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10023, (Throwable)e);
        }
        finally {
            fos.close();
        }
    }

    SymmetricCryptor(Key key, boolean cbc) throws CryptoException {
        super(key, key, cbc ? CBC_SYM_ALGORITHM : ECB_SYM_ALGORITHM, cbc ? new IvParameterSpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}) : null);
    }

    public byte[] getEncodedKey() {
        return this.decryptKey.getEncoded();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("The file to create must be supplied as the only argument.");
            System.exit(-1);
        }
        SymmetricCryptor.generateAndSaveKey(args[0]);
    }
}

