/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.xml.AddNodeInstruction;
import org.teiid.query.processor.xml.Condition;
import org.teiid.query.processor.xml.CriteriaCondition;
import org.teiid.query.processor.xml.EndDocumentInstruction;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.FakeXMLProcessorEnvironment;
import org.teiid.query.processor.xml.IfInstruction;
import org.teiid.query.processor.xml.InitializeDocumentInstruction;
import org.teiid.query.processor.xml.MoveCursorInstruction;
import org.teiid.query.processor.xml.MoveDocInstruction;
import org.teiid.query.processor.xml.NodeDescriptor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.WhileInstruction;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestInstructions
extends TestCase {
    public TestInstructions(String name) {
        super(name);
    }

    public QueryMetadataInterface exampleMetadata() {
        MetadataStore metadataStore = new MetadataStore();
        Schema stock = RealMetadataFactory.createPhysicalModel("stock", metadataStore);
        Schema xmltest = RealMetadataFactory.createVirtualModel("xmltest", metadataStore);
        Table items = RealMetadataFactory.createPhysicalGroup("items", stock);
        RealMetadataFactory.createElements(items, new String[]{"itemNum", "itemName", "itemQuantity"}, new String[]{"string", "string", "integer"});
        QueryNode rsQuery = new QueryNode("SELECT itemNum, itemName, itemQuantity FROM stock.items");
        Table rs = RealMetadataFactory.createVirtualGroup("rs", xmltest, rsQuery);
        RealMetadataFactory.createElements(rs, new String[]{"itemNum", "itemName", "itemQuantity"}, new String[]{"string", "string", "integer"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example", new FunctionTree[0]);
    }

    private Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws TeiidComponentException, TeiidProcessingException {
        QueryParser parser = new QueryParser();
        Command command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, null);
        return command;
    }

    private Criteria helpGetCriteria(String sql, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException {
        QueryParser parser = new QueryParser();
        Criteria crit = parser.parseCriteria(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)crit, null, (QueryMetadataInterface)metadata);
        return crit;
    }

    public void helpProcessInstructions(Program prog, XMLProcessorEnvironment env, String expected) throws Exception {
        env.pushProgram(prog);
        XMLPlan plan = new XMLPlan(env);
        TestProcessor.doProcess((ProcessorPlan)plan, new FakeDataManager(), new List[]{Arrays.asList(expected)}, new CommandContext());
    }

    public Program exampleProgram() throws Exception {
        InitializeDocumentInstruction i0 = new InitializeDocumentInstruction("UTF-8", true);
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"Catalogs", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i1 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i2 = new MoveDocInstruction(1);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Catalog", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i3 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i4 = new MoveDocInstruction(1);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Items", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i5 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i6 = new MoveDocInstruction(1);
        ResultSetInfo info = new ResultSetInfo("xmltest.rs");
        ExecSqlInstruction i7 = new ExecSqlInstruction("xmltest.rs", info);
        MoveCursorInstruction i8 = new MoveCursorInstruction("xmltest.rs");
        WhileInstruction i9 = new WhileInstruction("xmltest.rs");
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Item", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i10 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i11 = new MoveDocInstruction(1);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"ItemID", null, (boolean)false, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i12 = new AddNodeInstruction(descriptor, new ElementSymbol("xmltest.rs.itemNum"));
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Name", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i13 = new AddNodeInstruction(descriptor, new ElementSymbol("xmltest.rs.itemName"));
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Quantity", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i14 = new AddNodeInstruction(descriptor, new ElementSymbol("xmltest.rs.itemQuantity"));
        MoveDocInstruction i15 = new MoveDocInstruction(0);
        MoveCursorInstruction i16 = new MoveCursorInstruction("xmltest.rs");
        MoveDocInstruction i17 = new MoveDocInstruction(0);
        MoveDocInstruction i18 = new MoveDocInstruction(0);
        MoveDocInstruction i19 = new MoveDocInstruction(0);
        EndDocumentInstruction i20 = new EndDocumentInstruction();
        Program program = new Program();
        program.addInstruction((ProcessorInstruction)i0);
        program.addInstruction((ProcessorInstruction)i1);
        program.addInstruction((ProcessorInstruction)i2);
        program.addInstruction((ProcessorInstruction)i3);
        program.addInstruction((ProcessorInstruction)i4);
        program.addInstruction((ProcessorInstruction)i5);
        program.addInstruction((ProcessorInstruction)i6);
        program.addInstruction((ProcessorInstruction)i7);
        program.addInstruction((ProcessorInstruction)i8);
        program.addInstruction((ProcessorInstruction)i9);
        Program subProgram = new Program();
        i9.setBlockProgram(subProgram);
        subProgram.addInstruction((ProcessorInstruction)i10);
        subProgram.addInstruction((ProcessorInstruction)i11);
        subProgram.addInstruction((ProcessorInstruction)i12);
        subProgram.addInstruction((ProcessorInstruction)i13);
        subProgram.addInstruction((ProcessorInstruction)i14);
        subProgram.addInstruction((ProcessorInstruction)i15);
        subProgram.addInstruction((ProcessorInstruction)i16);
        program.addInstruction((ProcessorInstruction)i17);
        program.addInstruction((ProcessorInstruction)i18);
        program.addInstruction((ProcessorInstruction)i19);
        program.addInstruction((ProcessorInstruction)i20);
        return program;
    }

    public Program exampleProgram2(Criteria crit) throws Exception {
        InitializeDocumentInstruction i0 = new InitializeDocumentInstruction("UTF-8", true);
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"Catalogs", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i1 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i2 = new MoveDocInstruction(1);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Catalog", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i3 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i4 = new MoveDocInstruction(1);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Items", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i5 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i6 = new MoveDocInstruction(1);
        ResultSetInfo info = new ResultSetInfo("xmltest.rs");
        ExecSqlInstruction i7 = new ExecSqlInstruction("xmltest.rs", info);
        MoveCursorInstruction i8 = new MoveCursorInstruction("xmltest.rs");
        WhileInstruction i9 = new WhileInstruction("xmltest.rs");
        MoveCursorInstruction i17 = new MoveCursorInstruction("xmltest.rs");
        IfInstruction i10 = new IfInstruction();
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Item", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i11 = new AddNodeInstruction(descriptor);
        MoveDocInstruction i12 = new MoveDocInstruction(1);
        descriptor = NodeDescriptor.createNodeDescriptor((String)"ItemID", null, (boolean)false, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i13 = new AddNodeInstruction(descriptor, new ElementSymbol("xmltest.rs.itemNum"));
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Name", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i14 = new AddNodeInstruction(descriptor, new ElementSymbol("xmltest.rs.itemName"));
        descriptor = NodeDescriptor.createNodeDescriptor((String)"Quantity", null, (boolean)true, null, null, null, (boolean)false, null, (String)"preserve");
        AddNodeInstruction i15 = new AddNodeInstruction(descriptor, new ElementSymbol("xmltest.rs.itemQuantity"));
        MoveDocInstruction i16 = new MoveDocInstruction(0);
        MoveDocInstruction i18 = new MoveDocInstruction(0);
        MoveDocInstruction i19 = new MoveDocInstruction(0);
        MoveDocInstruction i20 = new MoveDocInstruction(0);
        EndDocumentInstruction i21 = new EndDocumentInstruction();
        Program program = new Program();
        program.addInstruction((ProcessorInstruction)i0);
        program.addInstruction((ProcessorInstruction)i1);
        program.addInstruction((ProcessorInstruction)i2);
        program.addInstruction((ProcessorInstruction)i3);
        program.addInstruction((ProcessorInstruction)i4);
        program.addInstruction((ProcessorInstruction)i5);
        program.addInstruction((ProcessorInstruction)i6);
        program.addInstruction((ProcessorInstruction)i7);
        program.addInstruction((ProcessorInstruction)i8);
        program.addInstruction((ProcessorInstruction)i9);
        Program whileProgram = new Program();
        i9.setBlockProgram(whileProgram);
        whileProgram.addInstruction((ProcessorInstruction)i10);
        Program thenProgram = new Program();
        CriteriaCondition cond = new CriteriaCondition(crit, thenProgram);
        i10.addCondition((Condition)cond);
        thenProgram.addInstruction((ProcessorInstruction)i11);
        thenProgram.addInstruction((ProcessorInstruction)i12);
        thenProgram.addInstruction((ProcessorInstruction)i13);
        thenProgram.addInstruction((ProcessorInstruction)i14);
        thenProgram.addInstruction((ProcessorInstruction)i15);
        thenProgram.addInstruction((ProcessorInstruction)i16);
        whileProgram.addInstruction((ProcessorInstruction)i17);
        program.addInstruction((ProcessorInstruction)i18);
        program.addInstruction((ProcessorInstruction)i19);
        program.addInstruction((ProcessorInstruction)i20);
        program.addInstruction((ProcessorInstruction)i21);
        return program;
    }

    public void testProcess1() throws Exception {
        QueryMetadataInterface metadata = this.exampleMetadata();
        String resultSetName = "xmltest.rs";
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        Program program = this.exampleProgram();
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        XMLPlan temp = new XMLPlan((XMLProcessorEnvironment)env);
        CommandContext context = new CommandContext((Object)"pid", null, null, null, (Object)1);
        temp.initialize(context, null, bufferMgr);
        ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>();
        schema.add(new ElementSymbol(resultSetName + "." + "itemNum"));
        schema.add(new ElementSymbol(resultSetName + "." + "itemName"));
        schema.add(new ElementSymbol(resultSetName + "." + "itemQuantity"));
        env.addData(resultSetName, schema, new List[]{Arrays.asList("001", "Lamp", new Integer(5)), Arrays.asList("002", "Screwdriver", new Integer(100)), Arrays.asList("003", "Goat", new Integer(4))});
        this.helpProcessInstructions(program, env, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Catalogs>\n   <Catalog>\n      <Items>\n         <Item ItemID=\"001\">\n            <Name>Lamp</Name>\n            <Quantity>5</Quantity>\n         </Item>\n         <Item ItemID=\"002\">\n            <Name>Screwdriver</Name>\n            <Quantity>100</Quantity>\n         </Item>\n         <Item ItemID=\"003\">\n            <Name>Goat</Name>\n            <Quantity>4</Quantity>\n         </Item>\n      </Items>\n   </Catalog>\n</Catalogs>");
    }

    public void testProcess2() throws Exception {
        QueryMetadataInterface metadata = this.exampleMetadata();
        String resultSetName = "xmltest.rs";
        String sql = "SELECT itemNum, itemName, itemQuantity FROM xmltest.rs";
        QueryCommand command = (QueryCommand)this.helpGetCommand(sql, metadata);
        Criteria crit = this.helpGetCriteria("xmltest.rs.itemName = 'Screwdriver'", metadata);
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        Program program = this.exampleProgram2(crit);
        BufferManager bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
        XMLPlan temp = new XMLPlan((XMLProcessorEnvironment)env);
        CommandContext context = new CommandContext((Object)"pid", null, null, null, (Object)1);
        temp.initialize(context, null, bufferMgr);
        env.addData(resultSetName, command.getProjectedSymbols(), new List[]{Arrays.asList("001", "Lamp", new Integer(5)), Arrays.asList("002", "Screwdriver", new Integer(100)), Arrays.asList("003", "Goat", new Integer(4))});
        this.helpProcessInstructions(program, env, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Catalogs>\n   <Catalog>\n      <Items>\n         <Item ItemID=\"002\">\n            <Name>Screwdriver</Name>\n            <Quantity>100</Quantity>\n         </Item>\n      </Items>\n   </Catalog>\n</Catalogs>");
    }
}

