/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.testcases;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.query.AbstractQueryTransactionTest;
import org.teiid.test.framework.query.QueryExecution;
import org.teiid.test.testcases.BaseAbstractTransactionTestCase;

public abstract class CommonTransactionTests
extends BaseAbstractTransactionTestCase {
    @Test
    public void testSingleSourceSelect() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceSelect"){

            public void testCase() throws Exception {
                this.execute("select * from pm1.g1 where pm1.g1.e1 < 100");
                this.assertRowCount(100);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testSingleSourceUpdate() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceUpdate"){

            public void testCase() throws Exception {
                this.execute("insert into pm1.g1 (e1, e2) values(100, '100')");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 = 100");
        test.assertRowCount(1);
    }

    @Test
    public void testSingleSourcePreparedUpdate() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourcePreparedUpdate"){

            public void testCase() throws Exception {
                this.execute("insert into pm1.g1 (e1, e2) values(?, ?)", new Object[]{new Integer(102), "102"});
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 = 102");
        test.assertRowCount(1);
    }

    @Test
    public void testSingleSourceMultipleCommands() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceMultipleCommands"){

            public void testCase() throws Exception {
                this.execute("delete from pm1.g1 where pm1.g1.e1 >= ?", new Object[]{new Integer(100)});
                this.execute("select * from pm1.g1");
                this.assertRowCount(100);
                for (int i = 100; i < 110; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into pm1.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                }
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 100");
        test.assertRowCount(10);
        test.execute("select * from g2 where e1 >= 100");
        test.assertRowCount(10);
    }

    @Test
    public void testSingleSourcePartialProcessing() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourcePartialProcessing"){

            public void testCase() throws Exception {
                this.execute("select * from pm1.g1 where pm1.g1.e1 < 100 limit 10");
                this.assertRowCount(10);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testMultipleSourceSelect() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceSelect"){

            public void testCase() throws Exception {
                this.execute("select * from pm1.g1 join pm2.g1 on pm1.g1.e1 = pm2.g1.e1 where pm1.g1.e1 < 100");
                this.assertRowCount(100);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testMultipleSourceVirtualSelect() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceVirtualSelect"){

            public void testCase() throws Exception {
                this.execute("select * from vm.g1 where vm.g1.pm1e1 < 100");
                this.assertRowCount(100);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testMultipleSourceUpdate() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceUpdate"){

            public void testCase() throws Exception {
                this.execute("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(500, '500', 500, '500')");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e2 = '500'");
        test.assertRowCount(1);
        test.closeConnection();
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e2 = '500'");
        test.assertRowCount(1);
    }

    @Test
    public void testMultipleSourceSelectInto() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceSelectInto"){

            public void testCase() throws Exception {
                this.execute("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(501, '501', 501, '501')");
                this.execute("select pm1.g1.e1, pm1.g1.e2 into pm2.g2 from pm1.g1 where pm1.g1.e1 = 501");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e2 = '501'");
        test.assertRowCount(1);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e2 = '501'");
        test.assertRowCount(1);
    }

    @Test
    public void testMultipleSourceBulkRowInsert() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceBulkRowInsert"){

            public void testCase() throws Exception {
                for (int i = 100; i < 112; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(?,?,?,?)", new Object[]{val, val.toString(), val, val.toString()});
                }
                this.execute("select pm1.g1.e1, pm1.g1.e2 into pm2.g2 from pm1.g1 where pm1.g1.e1 >= 100");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 100 and e1 < 112");
        test.assertRowCount(12);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e1 >= 100 and e1 < 112");
        test.assertRowCount(12);
        test.execute("select * from g2 where e1 >= 100 and e1 < 112");
        test.assertRowCount(12);
    }

    @Test
    public void testMultipleSourcePreparedUpdate() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourcePreparedUpdate"){

            public void testCase() throws Exception {
                Integer value = new Integer(500);
                this.execute("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(?,?,?,?)", new Object[]{value, value.toString(), value, value.toString()});
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 = 500");
        test.assertRowCount(1);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e1 = 500");
        test.assertRowCount(1);
    }

    @Test
    public void testMultipleSourceMultipleCommands() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceMultipleCommands"){

            public void testCase() throws Exception {
                this.execute("delete from pm1.g2 where e1 >= ?", new Object[]{new Integer(100)});
                this.execute("delete from pm1.g1 where e1 >= ?", new Object[]{new Integer(100)});
                this.execute("delete from pm2.g2 where e1 >= ?", new Object[]{new Integer(100)});
                this.execute("delete from pm2.g1 where e1 >= ?", new Object[]{new Integer(100)});
                this.execute("select * from pm1.g1");
                this.assertRowCount(100);
                for (int i = 100; i < 115; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into pm1.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm2.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm2.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                }
                this.execute("update pm1.g1 set e2='blah' where e1 > 100");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1")){

            protected boolean compareCaseSensitive() {
                return false;
            }
        };
        test.execute("select * from g1 where e1 >= 100 and e1 < 115");
        test.assertRowCount(15);
        test.execute("select * from g2 where e1 >= 100 and e1 < 115");
        test.assertRowCount(15);
        test.execute("select distinct e2 from g1 where e1 > 100");
        if (userTxn.getSource("pm1").getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") > -1) {
            test.assertResultsSetEquals(new String[]{"e2[varchar2]", "blah"});
        } else {
            test.assertResultsSetEquals(new String[]{"e2[varchar]", "blah"});
        }
    }

    @Test
    public void testMultipleSourceMultipleVirtualCommands() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceMultipleVirtualCommands"){

            public void testCase() throws Exception {
                for (int i = 200; i < 207; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(?,?,?,?)", new Object[]{val, val.toString(), val, val.toString()});
                    this.execute("insert into vm.g2 (pm1e1, pm1e2, pm2e1, pm2e2) values(?,?,?,?)", new Object[]{val, val.toString(), val, val.toString()});
                }
                this.execute("update vm.g1 set pm1e2='blah' where pm1e1 >= 200");
                this.execute("delete from vm.g2 where vm.g2.pm1e1 >= 205");
                this.execute("delete from vm.g1 where vm.g1.pm1e1 >= 205");
                this.execute("select * from vm.g1 where pm1e1 >= 200 and pm1e1 < 207");
                this.assertRowCount(5);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1")){

            protected boolean compareCaseSensitive() {
                return false;
            }
        };
        test.execute("select * from g1 where e1 >= 200 and e1 < 207");
        test.assertRowCount(5);
        test.execute("select * from g2 where e1 >= 200 and e1 < 207");
        test.assertRowCount(5);
        test.execute("select distinct e2 from g1 where e1 >= 200 and e1 < 207");
        test.assertResultsSetEquals(new String[]{"e2[varchar2]", "blah"});
    }

    @Test
    public void testMultipleSourceMultipleCommandsCancel() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceMultipleCommandsCancel"){

            public void testCase() throws Exception {
                Thread t = new Thread("Cancel Thread"){

                    @Override
                    public void run() {
                        try {
                            try {
                                Thread.sleep(500L);
                                this.cancelQuery();
                            }
                            catch (SQLException sQLException) {}
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                t.start();
                this.executeBatch(CommonTransactionTests.getMultipleSourceBatch());
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 600 and e1 < 650");
        test.assertRowCount(0);
        test.execute("select * from g2 where e1 >= 600 and e1 < 650");
        test.assertRowCount(0);
        test.execute("select distinct e2 from g1 where e1 >= 600 and e1 < 650");
        test.assertRowCount(0);
    }

    @Test
    public void testMultipleSourceTimeout() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceTimeout"){

            public void testCase() throws Exception {
                this.executeBatch(CommonTransactionTests.getMultipleSourceBatch(), 1);
            }

            public boolean exceptionExpected() {
                return true;
            }

            public void after() {
                if (!this.exceptionOccurred()) {
                    Assert.assertTrue((String)"should have failed with time out exception", (boolean)false);
                } else if (this.getLastException() != null) {
                    String msg = "NA";
                    SQLException s = this.getLastException();
                    Throwable t = s.getCause();
                    if (t instanceof TimeoutException) {
                        msg = t.getMessage();
                    } else if (s instanceof TeiidSQLException) {
                        TeiidSQLException mm = (TeiidSQLException)t;
                        if (mm.getNextException() != null) {
                            SQLException next = mm.getNextException();
                            msg = next.getMessage();
                        } else {
                            msg = mm.getMessage();
                        }
                    } else {
                        msg = s.getMessage();
                    }
                    boolean isfound = msg.indexOf("Operation timed out before completion") != -1;
                    Assert.assertTrue((String)("Exception Message didnt match 'Operation timed out before completion' found: " + msg), (boolean)isfound);
                } else {
                    Assert.assertTrue((String)"Program Error: it indicates exception occured, but no exception is found", (boolean)false);
                }
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 600 and e1 < 750");
        test.assertRowCount(0);
        test.execute("select * from g2 where e1 >= 600 and e1 < 750");
        test.assertRowCount(0);
        test.execute("select distinct e2 from g1 where e1 >= 600 and e1 < 750");
        test.assertRowCount(0);
    }

    static String[] getMultipleSourceBatch() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 600; i < 750; ++i) {
            list.add("insert into pm1.g1 (e1, e2) values(" + i + ",'" + i + "')");
            list.add("insert into pm1.g2 (e1, e2) values (" + i + ",'" + i + "')");
            list.add("insert into pm2.g1 (e1, e2) values(" + i + ",'" + i + "')");
            list.add("insert into pm2.g2 (e1, e2) values (" + i + ",'" + i + "')");
        }
        list.add("update pm1.g1 set e2='blah' where pm1.g1.e1 >= 600");
        list.add("update pm2.g1 set e2='blah' where pm2.g1.e1 >= 600");
        list.add("delete from pm1.g2 where pm1.g2.e1 >= 610");
        list.add("delete from pm1.g1 where pm1.g1.e1 >= 610");
        list.add("delete from pm2.g2 where pm2.g2.e1 >= 610");
        list.add("delete from pm2.g1 where pm2.g1.e1 >= 610");
        return list.toArray(new String[list.size()]);
    }

    @Test
    public void testMultipleSourcePartialProcessingUsingLimit() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourcePartialProcessingUsingLimit"){

            public void testCase() throws Exception {
                this.execute("select * from vm.g1 where pm1e1 < 100 limit 10");
                this.assertRowCount(10);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testMultipleSourcePartialProcessingUsingMakedep() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourcePartialProcessingUsingMakedep"){

            public void testCase() throws Exception {
                this.execute("select pm1.g1.e1, pm1.g1.e2 from pm1.g1 LEFT OUTER JOIN pm2.g1 MAKENOTDEP ON pm1.g1.e2 = pm2.g1.e2 where pm2.g1.e1 >= 50 and pm2.g1.e1 < 100");
                this.assertRowCount(50);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }
}

