/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.datasource;

import java.sql.Connection;
import java.sql.Statement;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.exception.QueryTestFailedException;

public class DataStore {
    public static void initialize(ConnectionStrategy connStrategy) {
        if (connStrategy.isDataStoreDisabled()) {
            return;
        }
        try {
            DataStore.load(DataStore.getConnection("pm1", connStrategy));
            DataStore.load(DataStore.getConnection("pm2", connStrategy));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Connection getConnection(String identifier, ConnectionStrategy connStrategy) throws QueryTestFailedException {
        Connection conn = connStrategy.createDriverConnection(identifier);
        try {
            conn.setAutoCommit(true);
        }
        catch (Exception sqle) {
            throw new QueryTestFailedException(sqle);
        }
        return conn;
    }

    private static void load(Connection c) throws Exception {
        Statement stmt = c.createStatement();
        try {
            int i;
            stmt.execute("delete from g2");
            stmt.execute("delete from g1");
            for (i = 0; i < 100; ++i) {
                stmt.execute("insert into g1 (e1, e2) values(" + i + ",'" + i + "')");
            }
            for (i = 0; i < 50; ++i) {
                stmt.execute("insert into g2 (e1, e2) values(" + i + ",'" + i + "')");
            }
        }
        finally {
            stmt.close();
        }
    }

    public static void setup(ConnectionStrategy connStrategy) {
        if (connStrategy.isDataStoreDisabled()) {
            return;
        }
        try {
            DataStore.setUpTest(DataStore.getConnection("pm1", connStrategy));
            DataStore.setUpTest(DataStore.getConnection("pm2", connStrategy));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setUpTest(Connection c) throws Exception {
        Statement stmt = c.createStatement();
        try {
            stmt.execute("delete from g2 where e1 >= 50");
            stmt.execute("delete from g1 where e1 >= 100");
        }
        finally {
            stmt.close();
        }
    }
}

