/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.language.Call;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;

public class TestResultsCache {
    private Connection conn;
    private static FakeServer server;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB("test", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
    }

    @AfterClass
    public static void oneTimeTeardown() {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.conn = server.createConnection("jdbc:teiid:test");
    }

    @After
    public void teardown() throws SQLException {
        this.conn.close();
    }

    @Test
    public void testCacheHint() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        ResultSet rs = s.executeQuery("/* cache */ select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set noexec on");
        rs = s.executeQuery("/* cache */ select 1");
        Assert.assertTrue((boolean)rs.next());
        rs = s.executeQuery("select 1");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCacheHintWithMaxRows() throws Exception {
        Statement s = this.conn.createStatement();
        s.setMaxRows(1);
        ResultSet rs = s.executeQuery("/* cache */ select 1 union all select 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        s.setMaxRows(2);
        rs = s.executeQuery("/* cache */ select 1 union all select 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCacheHintTtl() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        ResultSet rs = s.executeQuery("/*+ cache(ttl:50) */ select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set noexec on");
        Thread.sleep(60L);
        rs = s.executeQuery("/*+ cache(ttl:50) */ select 1");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testExecutionProperty() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set showplan on");
        s.execute("set resultSetCacheMode true");
        ResultSet rs = s.executeQuery("select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set noexec on");
        rs = s.executeQuery("select 1");
        Assert.assertTrue((boolean)rs.next());
        s.execute("set resultSetCacheMode false");
        rs = s.executeQuery("select 1");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCacheHintWithLargeSQLXML() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("/* cache */ WITH t(n) AS ( VALUES (1) UNION ALL SELECT n+1 FROM t WHERE n < 10000 ) SELECT xmlelement(root, xmlagg(xmlelement(val, n))) FROM t");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)148907L, (long)rs.getString(1).length());
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = s.executeQuery("/* cache */ WITH t(n) AS ( VALUES (1) UNION ALL SELECT n+1 FROM t WHERE n < 10000 ) SELECT xmlelement(root, xmlagg(xmlelement(val, n))) FROM t");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)148907L, (long)rs.getString(1).length());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testScope() throws Exception {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.addProperty("teiid_rel:determinism", "USER_DETERMINISTIC");
        mmd.addSourceMapping("x", "x", null);
        mmd.addSourceMetadata("ddl", "create foreign table t (c string); create foreign procedure p () returns table (c string);");
        final AtomicBoolean setScope = new AtomicBoolean();
        server.addTranslator("x", new ExecutionFactory(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                return this.createProcedureExecution(null, executionContext, metadata, connection);
            }

            public ProcedureExecution createProcedureExecution(Call command, final ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                return new ProcedureExecution(){
                    boolean returned = false;

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (setScope.get()) {
                            executionContext.setScope(CacheDirective.Scope.SESSION);
                        }
                        if (this.returned) {
                            return null;
                        }
                        this.returned = true;
                        return Arrays.asList(executionContext.getSession().getSessionId());
                    }

                    public List<?> getOutputParameterValues() throws TranslatorException {
                        return null;
                    }
                };
            }
        });
        server.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = server.getDriver().connect("jdbc:teiid:x;user=alice", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("/* cache */ select * from t");
        Assert.assertTrue((boolean)rs.next());
        String sessionid = rs.getString(1);
        rs = s.executeQuery("/* cache */ select * from t");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)sessionid, (Object)rs.getString(1));
        c.close();
        c = server.getDriver().connect("jdbc:teiid:x;user=alice", null);
        s = c.createStatement();
        rs = s.executeQuery("/* cache */ select * from t");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)sessionid, (Object)rs.getString(1));
        c.close();
        setScope.set(true);
        c = server.getDriver().connect("jdbc:teiid:x;user=bill", null);
        s = c.createStatement();
        rs = s.executeQuery("/* cache */ select * from t");
        Assert.assertTrue((boolean)rs.next());
        String sessionid1 = rs.getString(1);
        c.close();
        Assert.assertNotEquals((Object)sessionid, (Object)sessionid1);
        c = server.getDriver().connect("jdbc:teiid:x;user=bill", null);
        s = c.createStatement();
        rs = s.executeQuery("/* cache */ select * from t");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNotEquals((Object)sessionid1, (Object)rs.getString(1));
        setScope.set(false);
        rs = s.executeQuery("/* cache */ call p()");
        Assert.assertTrue((boolean)rs.next());
        sessionid = rs.getString(1);
        c.close();
        c = server.getDriver().connect("jdbc:teiid:x;user=alice", null);
        s = c.createStatement();
        rs = s.executeQuery("/* cache */ call p()");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNotEquals((Object)sessionid, (Object)rs.getString(1));
        c.close();
    }
}

