/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;

public class ResultSetUtil {
    public static final int DEFAULT_MAX_COL_WIDTH = 29;
    private static final String SPACER = "  ";
    private static final String NULL = "<null>";
    private static final String MORE = "$ ";
    private static String[] METADATA_METHODS = new String[]{"getColumnName", "getColumnType", "getCatalogName", "getColumnClassName", "getColumnLabel", "getColumnTypeName", "getSchemaName", "getTableName", "getColumnDisplaySize", "getPrecision", "getScale", "isAutoIncrement", "isCaseSensitive", "isCurrency", "isDefinitelyWritable", "isNullable", "isReadOnly", "isSearchable", "isSigned", "isWritable"};

    public static void printResultSet(ResultSet rs) throws SQLException, IOException {
        PrintWriter pw = new PrintWriter(System.out);
        ResultSetUtil.printResultSet(rs, 100, true, pw);
        pw.flush();
    }

    public static void printResultSet(ResultSet rs, int maxColWidth, boolean printMetadata, Writer out) throws SQLException, IOException {
        if (maxColWidth < 0) {
            maxColWidth = 29;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        int[] sizes = new int[count];
        StringWriter types = new StringWriter();
        StringWriter columns = new StringWriter();
        for (int i = 1; i <= count; ++i) {
            String columnName = rsmd.getColumnLabel(i);
            String typeName = rsmd.getColumnTypeName(i);
            sizes[i - 1] = maxColWidth == 0 ? Math.max(columnName.length(), typeName.length()) : Math.max(Math.max(columnName.length(), typeName.length()), Math.min(rsmd.getColumnDisplaySize(i), maxColWidth));
            types.write(ResultSetUtil.resizeString(typeName, sizes[i - 1]));
            columns.write(ResultSetUtil.resizeString(columnName, sizes[i - 1]));
            if (i == count) continue;
            types.write(SPACER);
            columns.write(SPACER);
        }
        out.append(types.toString()).append("\n");
        out.append(columns.toString()).append("\n");
        int totalRows = 0;
        while (rs.next()) {
            for (int j = 1; j <= count; ++j) {
                Object obj = rs.getObject(j);
                if (obj instanceof SQLXML) {
                    obj = ((SQLXML)obj).getString();
                } else if (obj instanceof Clob) {
                    obj = "Clob[" + ((Clob)obj).length() + "]";
                } else if (obj instanceof Blob) {
                    obj = "Blob[" + ((Blob)obj).length() + "]";
                }
                if (maxColWidth == 0) {
                    out.append(obj == null ? NULL : obj.toString());
                    if (j == count) continue;
                    out.append(SPACER);
                    continue;
                }
                String resizedString = ResultSetUtil.resizeString(obj, sizes[j - 1]);
                out.append(resizedString);
                if (j == count || resizedString.length() > sizes[j - 1]) continue;
                out.append(SPACER);
            }
            out.append("\n");
            ++totalRows;
        }
        out.append("Row Count : " + totalRows).append("\n");
        if (printMetadata) {
            ResultSetUtil.printResultSetMetadata(rsmd, out);
        }
    }

    public static void printResultSetMetadata(ResultSetMetaData rsmd, Writer out) throws SQLException, IOException {
        int col;
        int i;
        int columns = rsmd.getColumnCount();
        Class<ResultSetMetaData> RSMD = ResultSetMetaData.class;
        Class[] params = new Class[]{Integer.TYPE};
        int numMethods = METADATA_METHODS.length;
        String[][] metadataStrings = new String[columns][numMethods];
        int[] maxColWidths = new int[numMethods];
        for (i = 0; i < numMethods; ++i) {
            maxColWidths[i] = METADATA_METHODS[i].length();
        }
        for (col = 1; col <= columns; ++col) {
            Object[] columnParam = new Object[]{new Integer(col)};
            for (int i2 = 0; i2 < numMethods; ++i2) {
                try {
                    String stringVal;
                    Method m = RSMD.getMethod(METADATA_METHODS[i2], params);
                    Object obj = m.invoke((Object)rsmd, columnParam);
                    metadataStrings[col - 1][i2] = stringVal = obj == null ? NULL : obj.toString();
                    if (maxColWidths[i2] >= stringVal.length()) continue;
                    maxColWidths[i2] = stringVal.length();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < numMethods; ++i) {
            out.append(ResultSetUtil.resizeString(METADATA_METHODS[i], maxColWidths[i]));
            if (i == numMethods) continue;
            out.append(SPACER);
        }
        out.append("\n");
        for (col = 0; col < columns; ++col) {
            for (int i3 = 0; i3 < numMethods; ++i3) {
                out.append(ResultSetUtil.resizeString(metadataStrings[col][i3], maxColWidths[i3]));
                if (i3 == numMethods) continue;
                out.append(SPACER);
            }
            out.append("\n");
        }
    }

    private static String resizeString(Object obj, int size) {
        if (obj == null) {
            return ResultSetUtil.resizeString(NULL, size);
        }
        String str = obj.toString();
        if (str.length() == size) {
            return str;
        }
        if (str.length() < size) {
            return ResultSetUtil.pad(str, size - str.length());
        }
        return str.substring(0, size) + MORE;
    }

    private static String pad(String str, int padding) {
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < padding; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }
}

