/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;

public class RequestID
implements Externalizable {
    static final long serialVersionUID = -2888539138291776071L;
    public static final String NO_CONNECTION_STR = "C";
    private static final String SEPARATOR = ".";
    private String connectionID;
    private long executionID;
    private String combinedID;

    public RequestID() {
    }

    public RequestID(String connectionID, long executionID) {
        this.connectionID = connectionID;
        this.executionID = executionID;
    }

    public RequestID(long connectionID, long executionID) {
        this.connectionID = String.valueOf(connectionID);
        this.executionID = executionID;
    }

    public RequestID(long executionID) {
        this(null, executionID);
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public long getExecutionID() {
        return this.executionID;
    }

    private void createCombinedID() {
        StringBuffer combinedStr = new StringBuffer();
        if (this.connectionID != null) {
            combinedStr.append(this.connectionID);
        } else {
            combinedStr.append(NO_CONNECTION_STR);
        }
        combinedStr.append(SEPARATOR);
        combinedStr.append(this.executionID);
        this.combinedID = combinedStr.toString();
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)(this.connectionID == null ? 0 : this.connectionID.hashCode()), (long)this.executionID);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RequestID)) {
            return false;
        }
        RequestID other = (RequestID)obj;
        return this.executionID == other.executionID && EquivalenceUtil.areEqual((Object)this.connectionID, (Object)other.connectionID);
    }

    public String toString() {
        if (this.combinedID == null) {
            this.createCombinedID();
        }
        return this.combinedID;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.connectionID = (String)in.readObject();
        this.executionID = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.connectionID);
        out.writeLong(this.executionID);
    }
}

