/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class PropUtils {
    public static Properties loadProperties(String filename, Properties defaults) {
        Properties props;
        block15: {
            Assert.assertNotNull((Object)filename);
            InputStream in = null;
            props = new Properties();
            if (defaults != null) {
                props.putAll((Map<?, ?>)defaults);
            }
            try {
                File f = new File(filename);
                if (f.exists()) {
                    Properties properties = PropertiesUtils.load((String)filename);
                    return properties;
                }
                in = ConfigPropertyLoader.class.getResourceAsStream("/" + filename);
                if (in != null) {
                    Properties lprops = new Properties();
                    lprops.load(in);
                    props.putAll((Map<?, ?>)lprops);
                    break block15;
                }
                throw new TransactionRuntimeException("Failed to load properties from file '" + filename + "' configuration file");
            }
            catch (IOException e) {
                throw new TransactionRuntimeException("Error loading properties from file '" + filename + "'" + e.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }
}

