/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.sql.SQLException;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestVDBMerge
extends AbstractMMQueryTestCase {
    private static final String VDB1 = "PartsSupplier";
    private static final String VDB2 = "QT_Ora9DS";
    private FakeServer server;

    @Before
    public void setup() throws Exception {
        this.server = new FakeServer(true);
        this.server.setThrowMetadataErrors(false);
    }

    @After
    public void teardown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testMerge() throws Throwable {
        this.server.deployVDB(VDB1, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        this.execute("select * from tables where schemaname ='PartsSupplier'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/merge.test", this.internalResultSet);
        this.execute("select * from tables where schemaname='BQT1'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/merge.before", this.internalResultSet);
        this.internalConnection.close();
        this.server.deployVDB(VDB2, UnitTestUtil.getTestDataPath() + "/QT_Ora9DS_1.vdb");
        FakeServer.DeployVDBParameter param = new FakeServer.DeployVDBParameter(null, null);
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName(VDB2);
        vdbImport.setVersion("1");
        param.vdbImports = Arrays.asList(vdbImport);
        this.server.removeVDB(VDB1);
        this.server.deployVDB(VDB1, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb", param);
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        this.execute("select * from tables where schemaname='BQT1' order by name");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/merge.after", this.internalResultSet);
    }

    @Test
    public void testMergeWithEmptyVDB() throws Exception {
        this.server.deployVDB("empty", UnitTestUtil.getTestDataPath() + "/empty.vdb");
        this.internalConnection = this.server.createConnection("jdbc:teiid:empty");
        this.execute("select * from tables where schemaname ='BQT1'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/mergeEmpty.before", this.internalResultSet);
        this.internalConnection.close();
        this.server.deployVDB(VDB2, UnitTestUtil.getTestDataPath() + "/QT_Ora9DS_1.vdb");
        FakeServer.DeployVDBParameter param = new FakeServer.DeployVDBParameter(null, null);
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName(VDB2);
        vdbImport.setVersion("1");
        param.vdbImports = Arrays.asList(vdbImport);
        this.server.undeployVDB("empty");
        this.server.deployVDB("empty", UnitTestUtil.getTestDataPath() + "/empty.vdb", param);
        this.internalConnection = this.server.createConnection("jdbc:teiid:empty");
        this.execute("select * from tables where schemaname='BQT1'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/mergeEmpty.after", this.internalResultSet);
    }

    @Test
    public void testMergeWithPolicies() throws Exception {
        this.server.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-1\" version=\"1\"><model name=\"myschema\" type=\"virtual\"><metadata type = \"DDL\"><![CDATA[CREATE VIEW vw as select 'a' as col;]]></metadata></model><data-role name=\"y\" any-authenticated=\"true\"/></vdb>").getBytes()));
        this.internalConnection = this.server.createConnection("jdbc:teiid:role-1");
        try {
            this.execute("select * from vw");
            Assert.fail((String)"should not be authorized");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.server.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-2\" version=\"1\"><import-vdb name=\"role-1\" version=\"1\"/></vdb>").getBytes()));
        this.internalConnection = this.server.createConnection("jdbc:teiid:role-2");
        try {
            this.execute("select * from vw");
            Assert.fail((String)"should not be authorized");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.server.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"role-3\" version=\"1\"><import-vdb name=\"role-1\" version=\"1\" import-data-policies=\"false\"/></vdb>").getBytes()));
        this.internalConnection = this.server.createConnection("jdbc:teiid:role-3");
        this.execute("select * from vw");
    }

    @Test
    public void testMergeWithMultiSource() throws Exception {
        HardCodedExecutionFactory hc = new HardCodedExecutionFactory();
        hc.addData("SELECT tbl.col FROM tbl", Arrays.asList(Arrays.asList("a")));
        this.server.addTranslator("hc", (ExecutionFactory)hc);
        this.server.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"ms-base\" version=\"1\"><model name=\"myschema\"><source name=\"a\" translator-name=\"hc\"/><source name=\"b\" translator-name=\"hc\"/><metadata type = \"DDL\"><![CDATA[CREATE foreign table tbl (col string);]]></metadata></model></vdb>").getBytes()));
        this.internalConnection = this.server.createConnection("jdbc:teiid:ms-base");
        this.execute("select * from tbl");
        this.assertRowCount(2);
        this.server.deployVDB(new ByteArrayInputStream(new String("<vdb name=\"ms-2\" version=\"1\"><import-vdb name=\"ms-base\" version=\"1\"/></vdb>").getBytes()));
        this.internalConnection = this.server.createConnection("jdbc:teiid:ms-2");
        this.execute("select * from tbl");
        this.assertRowCount(2);
    }
}

