/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Blob;
import java.sql.SQLException;
import org.teiid.CommandContext;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.GeometryTransformUtils;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.TeiidFunction;

public class GeometryFunctionMethods {
    @TeiidFunction(name="st_astext", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static ClobType asText(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToClob(geometry, false);
    }

    @TeiidFunction(name="st_asewkt", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static ClobType asEwkt(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToClob(geometry, true);
    }

    @TeiidFunction(name="st_asbinary", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static BlobType asBlob(GeometryType geometry) {
        Blob b = (Blob)geometry.getReference();
        return new BlobType(b);
    }

    public static BlobType asBlob(GeometryType geometry, String encoding) throws FunctionExecutionException {
        if ("NDR".equals(encoding)) {
            return new BlobType(GeometryUtils.getBytes(GeometryUtils.getGeometry(geometry), false));
        }
        Blob b = (Blob)geometry.getReference();
        return new BlobType(b);
    }

    @TeiidFunction(name="st_asewkb", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static BlobType asEwkb(GeometryType geometry) {
        return GeometryUtils.geometryToEwkb(geometry);
    }

    @TeiidFunction(name="st_asgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGeoJson(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToGeoJson(geometry);
    }

    @TeiidFunction(name="st_asgml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGml(org.teiid.query.util.CommandContext context, GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToGml(context, geometry, true);
    }

    @TeiidFunction(name="st_askml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asKml(org.teiid.query.util.CommandContext context, GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToGml(context, geometry, false);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromText(ClobType wkt) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType geomFromText(ClobType wkt, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt, srid, false);
    }

    @TeiidFunction(name="st_geomfromwkb", category="Geometry", nullOnNull=true, alias="ST_GEOMFROMBINARY")
    public static GeometryType geoFromBlob(BlobType wkb) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb);
    }

    @TeiidFunction(name="st_geomfromwkb", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true, alias="ST_GEOMFROMBINARY")
    public static GeometryType geoFromBlob(BlobType wkb, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb, srid);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGeoJson(clob);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGeoJson(clob, srid);
    }

    @TeiidFunction(name="st_geomfromgml", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGml(ClobType gml) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGml(gml, null);
    }

    @TeiidFunction(name="st_geomfromgml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGml(ClobType gml, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGml(gml, (Integer)srid);
    }

    @TeiidFunction(name="st_intersects", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.intersects(geom1, geom2);
    }

    @TeiidFunction(name="st_contains", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.contains(geom1, geom2);
    }

    @TeiidFunction(name="st_crosses", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean crosses(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.crosses(geom1, geom2);
    }

    @TeiidFunction(name="st_disjoint", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean disjoint(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.disjoint(geom1, geom2);
    }

    @TeiidFunction(name="st_distance", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double distance(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.distance(geom1, geom2);
    }

    @TeiidFunction(name="st_overlaps", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean overlaps(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.overlaps(geom1, geom2);
    }

    @TeiidFunction(name="st_touches", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean touches(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.touches(geom1, geom2);
    }

    @TeiidFunction(name="st_srid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static int getSrid(GeometryType geom1) {
        return geom1.getSrid();
    }

    @TeiidFunction(name="st_setsrid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType setSrid(GeometryType geom1, int srid) {
        GeometryType gt = new GeometryType();
        gt.setReference(geom1.getReference());
        gt.setSrid(srid);
        return gt;
    }

    @TeiidFunction(name="st_equals", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean equals(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.equals(geom1, geom2);
    }

    @TeiidFunction(name="st_transform", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType transform(org.teiid.query.util.CommandContext context, GeometryType geom, int srid) throws FunctionExecutionException {
        return GeometryTransformUtils.transform((CommandContext)context, geom, srid);
    }

    @TeiidFunction(name="st_envelope", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType envelope(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.envelope(geom);
    }

    @TeiidFunction(name="st_within", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean within(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.within(geom1, geom2);
    }

    @TeiidFunction(name="st_dwithin", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean dwithin(GeometryType geom1, GeometryType geom2, double distance) throws FunctionExecutionException {
        return GeometryUtils.dwithin(geom1, geom2, distance);
    }

    @TeiidFunction(name="st_simplify", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType simplify(GeometryType geom, double tolerance) throws FunctionExecutionException {
        return GeometryUtils.simplify(geom, tolerance);
    }

    @TeiidFunction(name="st_force_2d", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType force2D(GeometryType geom) {
        return geom;
    }

    @TeiidFunction(name="st_hasarc", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static boolean hasArc(GeometryType geom) {
        return false;
    }

    @TeiidFunction(name="&&", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static boolean boundingBoxIntersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.boundingBoxIntersects(geom1, geom2);
    }

    @TeiidFunction(name="st_geomfromewkt", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType geomFromEwkt(ClobType ewkt) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(ewkt, null, true);
    }

    @TeiidFunction(name="st_geomfromewkb", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType geomFromEwkb(BlobType ewkb) throws FunctionExecutionException, SQLException {
        return GeometryUtils.geometryFromEwkb(ewkb.getBinaryStream(), null);
    }

    @TeiidFunction(name="st_area", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double area(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.area(geom);
    }

    @TeiidFunction(name="st_boundary", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType boundary(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.boundary(geom);
    }

    @TeiidFunction(name="st_buffer", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType buffer(GeometryType geom, double distance) throws FunctionExecutionException {
        return GeometryUtils.buffer(geom, distance);
    }

    @TeiidFunction(name="st_centroid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType centroid(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.centroid(geom);
    }

    @TeiidFunction(name="st_convexhull", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType convexHull(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.convexHull(geom);
    }

    @TeiidFunction(name="st_coorddim", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Integer coordDim(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.coordDim(geom);
    }

    @TeiidFunction(name="st_curvetoline", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType curveToLine(GeometryType geom) throws FunctionExecutionException {
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31206, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31206, new Object[0]));
    }

    @TeiidFunction(name="st_difference", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType difference(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.difference(geom1, geom2);
    }

    @TeiidFunction(name="st_dimension", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Integer dimension(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.dimension(geom);
    }

    @TeiidFunction(name="st_endpoint", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType endPoint(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.startEndPoint(geom, false);
    }

    @TeiidFunction(name="st_exteriorring", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType exteriorRing(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.exteriorRing(geom);
    }

    @TeiidFunction(name="st_geometryn", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType geometryN(GeometryType geom, int index) throws FunctionExecutionException {
        return GeometryUtils.geometryN(geom, index - 1);
    }

    @TeiidFunction(name="st_geometrytype", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static String geometryType(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.geometryType(geom);
    }

    @TeiidFunction(name="st_interiorringn", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType interiorRingN(GeometryType geom, int index) throws FunctionExecutionException {
        return GeometryUtils.interiorRingN(geom, index - 1);
    }

    @TeiidFunction(name="st_intersection", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType intersection(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.intersection(geom1, geom2);
    }

    @TeiidFunction(name="st_isclosed", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean isClosed(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.isClosed(geom);
    }

    @TeiidFunction(name="st_isempty", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean isEmpty(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.isEmpty(geom);
    }

    @TeiidFunction(name="st_isring", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean isRing(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.isRing(geom);
    }

    @TeiidFunction(name="st_issimple", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean isSimple(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.isSimple(geom);
    }

    @TeiidFunction(name="st_isvalid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean isValid(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.isValid(geom);
    }

    @TeiidFunction(name="st_length", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double length(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.length(geom);
    }

    @TeiidFunction(name="st_numgeometries", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Integer numGeometries(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.numGeometries(geom);
    }

    @TeiidFunction(name="st_numinteriorrings", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Integer numInteriorRings(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.numInteriorRings(geom);
    }

    @TeiidFunction(name="st_numpoints", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Integer numPoints(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.numPoints(geom);
    }

    @TeiidFunction(name="st_orderingequals", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean orderingEquals(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.orderingEquals(geom1, geom2);
    }

    @TeiidFunction(name="st_point", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType point(double x, double y) {
        return GeometryUtils.point(x, y);
    }

    @TeiidFunction(name="st_pointn", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType pointN(GeometryType geom, int index) throws FunctionExecutionException {
        return GeometryUtils.pointN(geom, index - 1);
    }

    @TeiidFunction(name="st_perimeter", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double perimeter(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.perimeter(geom);
    }

    @TeiidFunction(name="st_pointonsurface", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType pointOnSurface(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.pointOnSurface(geom);
    }

    @TeiidFunction(name="st_polygon", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType polygon(GeometryType geom, int srid) throws FunctionExecutionException {
        return GeometryUtils.polygon(geom, srid);
    }

    @TeiidFunction(name="st_relate", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static String relate(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.relate(geom1, geom2);
    }

    @TeiidFunction(name="st_relate", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean relate(GeometryType geom1, GeometryType geom2, String intersectionPattern) throws FunctionExecutionException {
        return GeometryUtils.relate(geom1, geom2, intersectionPattern);
    }

    @TeiidFunction(name="st_startpoint", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType startPoint(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.startEndPoint(geom, true);
    }

    @TeiidFunction(name="st_symdifference", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType symDifference(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.symDifference(geom1, geom2);
    }

    @TeiidFunction(name="st_union", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType union(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.union(geom1, geom2);
    }

    @TeiidFunction(name="st_x", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double ordinateX(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.ordinate(geom, GeometryUtils.Ordinate.X);
    }

    @TeiidFunction(name="st_y", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double ordinateY(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.ordinate(geom, GeometryUtils.Ordinate.Y);
    }

    @TeiidFunction(name="st_z", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double ordinateZ(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.ordinate(geom, GeometryUtils.Ordinate.Z);
    }

    @TeiidFunction(name="st_makeenvelope", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType makeEnvelope(double xmin, double ymin, double xmax, double ymax) {
        return GeometryUtils.makeEnvelope(xmin, ymin, xmax, ymax, null);
    }

    @TeiidFunction(name="st_makeenvelope", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType makeEnvelope(double xmin, double ymin, double xmax, double ymax, int srid) {
        return GeometryUtils.makeEnvelope(xmin, ymin, xmax, ymax, srid);
    }
}

