/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.teiid.test.client.ClassFactory;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.QueryReader;
import org.teiid.test.client.QueryTest;
import org.teiid.test.client.ResultsGenerator;
import org.teiid.test.client.TestResult;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public abstract class QueryScenario {
    protected QueryReader reader = null;
    protected ResultsGenerator resultsGen = null;
    private String resultMode = "none";
    private Properties props = null;
    private String scenarioName;
    private String querySetName;

    public QueryScenario(String scenarioName, Properties queryProperties) {
        this.props = queryProperties;
        this.scenarioName = scenarioName;
        this.querySetName = this.props.getProperty("queryset.dir", "querysetnamenotdefined");
        this.setUp();
    }

    protected void setUp() {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(this.scenarioName);
        args.add(this.props);
        this.reader = ClassFactory.createQueryReader(args);
        args = new ArrayList(2);
        args.add(this.scenarioName);
        args.add(this.props);
        this.resultsGen = ClassFactory.createResultsGenerator(args);
        if (this.reader.getQuerySetIDs() == null || this.reader.getQuerySetIDs().isEmpty()) {
            throw new TransactionRuntimeException("The queryreader did not return any queryset ID's to process");
        }
        this.validateResultsMode(this.props);
    }

    protected void validateResultsMode(Properties props) {
        String resultModeStr = props.getProperty("resultmode", "");
        if (resultModeStr.equalsIgnoreCase("none") || resultModeStr.equalsIgnoreCase("compare") || resultModeStr.equalsIgnoreCase("generate")) {
            this.resultMode = resultModeStr;
        }
        TestLogger.log("\nResults mode: " + this.resultMode);
    }

    public String getQuerySetName() {
        return this.querySetName;
    }

    public String getQueryScenarioIdentifier() {
        return this.scenarioName;
    }

    public Properties getProperties() {
        return this.props;
    }

    public List<QueryTest> getQueries(String querySetID) {
        try {
            return this.reader.getQueries(querySetID);
        }
        catch (QueryTestFailedException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public Collection<String> getQuerySetIDs() {
        return this.reader.getQuerySetIDs();
    }

    public String getResultsMode() {
        return this.resultMode;
    }

    public ExpectedResults getExpectedResults(String querySetID) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(querySetID);
        args.add(this.props);
        return ClassFactory.createExpectedResults(args);
    }

    public ResultsGenerator getResultsGenerator() {
        return this.resultsGen;
    }

    public QueryReader getQueryReader() {
        return this.reader;
    }

    public abstract void handleTestResult(TestResult var1, ResultSet var2, int var3, boolean var4, String var5);
}

