/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.Grant;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.ParseException;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.metadata.Trigger;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.validator.ValidatorReport;

public class TestDDLParser {
    @Test
    public void testForeignTable() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(\ne1 integer primary key,\ne2 varchar(10) unique,\ne3 date not null unique,\ne4 decimal(12,3) default 12.2 options (searchable 'unsearchable'),\ne5 integer auto_increment INDEX OPTIONS (UUID 'uuid', NAMEINSOURCE 'nis', SELECTABLE 'NO'),\ne6 varchar index default 'hello')\nOPTIONS (CARDINALITY 12, UUID 'uuid2',  UPDATABLE 'true', FOO 'BAR', ANNOTATION 'Test Table')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertTrue((boolean)table.isPhysical());
        Assert.assertFalse((boolean)table.isVirtual());
        Assert.assertFalse((boolean)table.isSystem());
        Assert.assertFalse((boolean)table.isMaterialized());
        Assert.assertFalse((boolean)table.isDeletePlanEnabled());
        Assert.assertEquals((Object)"uuid2", (Object)table.getUUID());
        Assert.assertEquals((long)12L, (long)table.getCardinality());
        Assert.assertTrue((boolean)table.supportsUpdate());
        Assert.assertEquals((Object)"BAR", table.getProperties().get("FOO"));
        Assert.assertEquals((Object)"Test Table", (Object)table.getAnnotation());
        Assert.assertEquals((long)6L, (long)table.getColumns().size());
        List columns = table.getColumns();
        Column e1 = (Column)columns.get(0);
        Column e2 = (Column)columns.get(1);
        Column e3 = (Column)columns.get(2);
        Column e4 = (Column)columns.get(3);
        Column e5 = (Column)columns.get(4);
        Column e6 = (Column)columns.get(5);
        Assert.assertEquals((Object)"e1", (Object)e1.getName());
        Assert.assertEquals((Object)"int", (Object)e1.getDatatype().getName());
        Assert.assertEquals((String)"primary key not same", (Object)e1, table.getPrimaryKey().getColumns().get(0));
        Assert.assertEquals((Object)"e2", (Object)e2.getName());
        Assert.assertEquals((Object)"string", (Object)e2.getDatatype().getName());
        Assert.assertEquals((String)"unique", (Object)e2, ((KeyRecord)table.getUniqueKeys().get(0)).getColumns().get(0));
        Assert.assertEquals((Object)BaseColumn.NullType.Nullable, (Object)e2.getNullType());
        Assert.assertEquals((long)10L, (long)e2.getLength());
        Assert.assertEquals((long)0L, (long)e2.getPrecision());
        Assert.assertEquals((Object)"e3", (Object)e3.getName());
        Assert.assertEquals((Object)"date", (Object)e3.getDatatype().getName());
        Assert.assertEquals((String)"unique", (Object)e3, ((KeyRecord)table.getUniqueKeys().get(1)).getColumns().get(0));
        Assert.assertEquals((Object)BaseColumn.NullType.No_Nulls, (Object)e3.getNullType());
        Assert.assertEquals((Object)"e4", (Object)e4.getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)e4.getDatatype().getName());
        Assert.assertEquals((Object)false, (Object)e4.isAutoIncremented());
        Assert.assertEquals((long)12L, (long)e4.getPrecision());
        Assert.assertEquals((long)3L, (long)e4.getScale());
        Assert.assertEquals((Object)Column.SearchType.Unsearchable, (Object)e4.getSearchType());
        Assert.assertEquals((Object)"12.2", (Object)e4.getDefaultValue());
        Assert.assertEquals((Object)"e5", (Object)e5.getName());
        Assert.assertEquals((Object)"int", (Object)e5.getDatatype().getName());
        Assert.assertEquals((Object)true, (Object)e5.isAutoIncremented());
        Assert.assertEquals((Object)"uuid", (Object)e5.getUUID());
        Assert.assertEquals((Object)"nis", (Object)e5.getNameInSource());
        Assert.assertEquals((Object)false, (Object)e5.isSelectable());
        Assert.assertEquals((String)"index", (Object)e5, ((KeyRecord)table.getIndexes().get(0)).getColumns().get(0));
        Assert.assertEquals((Object)"e6", (Object)e6.getName());
        Assert.assertEquals((Object)"string", (Object)e6.getDatatype().getName());
        Assert.assertEquals((String)"index", (Object)e6, ((KeyRecord)table.getIndexes().get(1)).getColumns().get(0));
        Assert.assertEquals((Object)"hello", (Object)e6.getDefaultValue());
    }

    @Test(expected=MetadataException.class)
    public void testZeroPrecision() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(e4 decimal(0))";
        TestDDLParser.helpParse(ddl, "model").getSchema();
    }

    @Test
    public void testDefaultPrecision() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(e4 decimal)";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Column e4 = (Column)table.getColumns().get(0);
        Assert.assertEquals((Object)"e4", (Object)e4.getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)e4.getDatatype().getName());
        Assert.assertEquals((Object)false, (Object)e4.isAutoIncremented());
        Assert.assertEquals((long)32767L, (long)e4.getPrecision());
        Assert.assertEquals((long)16383L, (long)e4.getScale());
        Assert.assertEquals((Object)Column.SearchType.Searchable, (Object)e4.getSearchType());
    }

    @Test(expected=MetadataException.class)
    public void testDuplicatePrimarykey() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer primary key, e2 varchar primary key)";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testAutoIncrementPrimarykey() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer auto_increment primary key, e2 varchar)";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testUDT() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar OPTIONS (UDT 'NMTOKENS(12,13,11)'))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((Object)"NMTOKENS", (Object)((Column)table.getColumns().get(1)).getDatatype().getName());
        Assert.assertEquals((long)12L, (long)((Column)table.getColumns().get(1)).getLength());
        Assert.assertEquals((long)13L, (long)((Column)table.getColumns().get(1)).getPrecision());
        Assert.assertEquals((long)11L, (long)((Column)table.getColumns().get(1)).getScale());
    }

    @Test
    public void testFBI() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(e1 integer, e2 varchar, CONSTRAINT fbi INDEX (UPPER(e2)))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((long)1L, (long)table.getFunctionBasedIndexes().size());
    }

    @Test
    public void testMultiKeyPK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, PRIMARY KEY (e1, e2))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals(table.getColumns().subList(0, 2), (Object)table.getPrimaryKey().getColumns());
    }

    @Test
    public void testOptionsKey() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, UNIQUE (e1) OPTIONS (CUSTOM_PROP 'VALUE'))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        KeyRecord record = (KeyRecord)table.getAllKeys().iterator().next();
        Assert.assertEquals((Object)"VALUE", (Object)record.getProperty("CUSTOM_PROP", false));
    }

    @Test
    public void testConstraints() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date,  PRIMARY KEY (e1, e2), INDEX(e2, e3), ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals(table.getColumns().subList(0, 2), (Object)table.getPrimaryKey().getColumns());
        Assert.assertEquals(table.getColumns().subList(1, 3), (Object)((KeyRecord)table.getIndexes().get(0)).getColumns());
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getUniqueKeys().get(0)).getColumns());
        Assert.assertEquals((long)2L, (long)table.getAccessPatterns().size());
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getAccessPatterns().get(0)).getColumns());
        Assert.assertEquals(table.getColumns().subList(1, 3), (Object)((KeyRecord)table.getAccessPatterns().get(1)).getColumns());
    }

    @Test
    public void testConstraints2() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getUniqueKeys().get(0)).getColumns());
        Assert.assertEquals((long)2L, (long)table.getAccessPatterns().size());
        Assert.assertEquals(table.getColumns().subList(0, 1), (Object)((KeyRecord)table.getAccessPatterns().get(0)).getColumns());
        Assert.assertEquals(table.getColumns().subList(1, 3), (Object)((KeyRecord)table.getAccessPatterns().get(1)).getColumns());
    }

    @Test(expected=MetadataException.class)
    public void testWrongPrimarykey() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, PRIMARY KEY (e3))";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testFK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, FOREIGN KEY (g2e1, g2e2) REFERENCES G1 (g1e1, g1e2) options (\"teiid_rel:allow-join\" true))";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Table table = (Table)tableMap.get("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)fk.getProperty("{http://www.teiid.org/ext/relational/2012}allow-join", false));
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
    }

    @Test
    public void testOptionalFK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES G1)";
        MetadataFactory s = TestDDLParser.helpParse(ddl, "model");
        NavigableMap tableMap = s.getSchema().getTables();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Table table = (Table)tableMap.get("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model");
        vdb.addModel(modelOne);
        ValidatorReport report = new MetadataValidator().validate(vdb, s.asMetadataStore());
        Assert.assertFalse((boolean)report.hasItems());
        Assert.assertEquals((Object)fk.getPrimaryKey().getColumns(), (Object)((Table)tableMap.get("G1")).getColumns());
    }

    @Test
    public void testOptionalFKFail() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar);\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES G1)";
        MetadataFactory s = TestDDLParser.helpParse(ddl, "model");
        NavigableMap tableMap = s.getSchema().getTables();
        Assert.assertEquals((long)2L, (long)tableMap.size());
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Table table = (Table)tableMap.get("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model");
        vdb.addModel(modelOne);
        ValidatorReport report = new MetadataValidator().validate(vdb, s.asMetadataStore());
        Assert.assertTrue((boolean)report.hasItems());
    }

    @Test
    public void testFKAccrossSchemas() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));\n";
        String ddl2 = "CREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES model.G1)";
        MetadataFactory f1 = TestDDLParser.helpParse(ddl, "model");
        MetadataFactory f2 = TestDDLParser.helpParse(ddl2, "model2");
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model");
        vdb.addModel(modelOne);
        ModelMetaData modelTwo = new ModelMetaData();
        modelTwo.setName("model2");
        vdb.addModel(modelTwo);
        MetadataStore s = f1.asMetadataStore();
        f2.mergeInto(s);
        ValidatorReport report = new MetadataValidator().validate(vdb, s);
        Assert.assertFalse((boolean)report.hasItems());
        Table table = s.getSchema("model2").getTable("G2");
        ForeignKey fk = (ForeignKey)table.getForeignKeys().get(0);
        Assert.assertEquals((Object)fk.getColumns(), (Object)table.getColumns());
        Assert.assertEquals((Object)"G1", (Object)fk.getReferenceTableName());
        Assert.assertEquals((Object)fk.getPrimaryKey().getColumns(), (Object)s.getSchema("model").getTable("G1").getColumns());
    }

    @Test(expected=MetadataException.class)
    public void testTableWithPlan() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "CREATE foreign table G1 as select 1";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
    }

    @Test
    public void testViewWithoutColumns() throws Exception {
        QueryParser parser = new QueryParser();
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "VM1", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, "CREATE VIEW V1 AS SELECT * FROM PM1.G1");
        mf.mergeInto(mds);
    }

    @Test
    public void testMultipleCommands() throws Exception {
        String ddl = "CREATE VIEW V1 AS SELECT * FROM PM1.G1; CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("V1");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)"SELECT * FROM PM1.G1", (Object)table.getSelectTransformation());
        NavigableMap procedureMap = s.getProcedures();
        Procedure p = (Procedure)procedureMap.get("FOO");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"SELECT * FROM PM1.G1;", (Object)p.getQueryPlan());
    }

    @Test
    public void testMultipleCommands2() throws Exception {
        String ddl = "             CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), \n                 profile_image_url varchar(25), source varchar(25), text varchar(140)) AS \n                select tweet.* from \n\t                (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, \n\t                XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns \n\t                created_on string PATH 'created_at', \n\t                from_user string PATH 'from_user',\n\t                to_user string PATH 'to_user',\t\n\t                profile_image_url string PATH 'profile_image_url',\t\n\t                source string PATH 'source',\t\n\t                text string PATH 'text') tweet;                CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("Tweet");
        Assert.assertNotNull((Object)table);
        NavigableMap procedureMap = s.getProcedures();
        Procedure p = (Procedure)procedureMap.get("getTweets");
        Assert.assertNotNull((Object)p);
    }

    @Test
    public void testView() throws Exception {
        String ddl = "CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((Object)"SELECT e1, e2 FROM foo.bar", (Object)table.getSelectTransformation());
        Assert.assertEquals((long)12L, (long)table.getCardinality());
    }

    @Test
    public void testPushdownFunctionNoArgs() throws Exception {
        String ddl = "CREATE FOREIGN FUNCTION SourceFunc() RETURNS integer OPTIONS (UUID 'hello world')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("hello world");
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)"integer", (Object)fm.getOutputParameter().getType());
        Assert.assertEquals((Object)FunctionMethod.PushDown.MUST_PUSHDOWN, (Object)fm.getPushdown());
    }

    @Test(expected=DuplicateRecordException.class)
    public void testDuplicateFunctions() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc() RETURNS integer; CREATE FUNCTION SourceFunc() RETURNS string";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test(expected=DuplicateRecordException.class)
    public void testDuplicateFunctions1() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc() RETURNS string OPTIONS (UUID 'a'); CREATE FUNCTION SourceFunc1() RETURNS string OPTIONS (UUID 'a')";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test
    public void testDuplicateFunctions2() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc() RETURNS string; CREATE FUNCTION SourceFunc(param string) RETURNS string";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test
    public void testUDF() throws Exception {
        String ddl = "CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', DETERMINISM 'DETERMINISTIC', \"NULL-ON-NULL\" 'true', JAVA_CLASS 'foo', JAVA_METHOD 'bar', RANDOM 'any', UUID 'x')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("x");
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)"string", (Object)fm.getOutputParameter().getType());
        Assert.assertEquals((Object)FunctionMethod.PushDown.CAN_PUSHDOWN, (Object)fm.getPushdown());
        Assert.assertEquals((long)2L, (long)fm.getInputParameterCount());
        Assert.assertEquals((Object)"flag", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getType());
        Assert.assertEquals((Object)"msg", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getType());
        Assert.assertFalse((boolean)((FunctionParameter)fm.getInputParameters().get(1)).isVarArg());
        Assert.assertEquals((Object)FunctionMethod.Determinism.DETERMINISTIC, (Object)fm.getDeterminism());
        Assert.assertEquals((Object)"misc", (Object)fm.getCategory());
        Assert.assertEquals((Object)true, (Object)fm.isNullOnNull());
        Assert.assertEquals((Object)"foo", (Object)fm.getInvocationClass());
        Assert.assertEquals((Object)"bar", (Object)fm.getInvocationMethod());
        Assert.assertEquals((Object)"any", fm.getProperties().get("RANDOM"));
    }

    @Test
    public void testUDAggregate() throws Exception {
        String ddl = "CREATE VIRTUAL FUNCTION SourceFunc(flag boolean, msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', AGGREGATE 'true', \"allows-distinct\" 'true', UUID 'y')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("y");
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)"string", (Object)fm.getOutputParameter().getType());
        Assert.assertEquals((Object)FunctionMethod.PushDown.CAN_PUSHDOWN, (Object)fm.getPushdown());
        Assert.assertEquals((long)2L, (long)fm.getInputParameterCount());
        Assert.assertEquals((Object)"flag", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getType());
        Assert.assertEquals((Object)"msg", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((FunctionParameter)fm.getInputParameters().get(1)).getType());
        Assert.assertFalse((boolean)((FunctionParameter)fm.getInputParameters().get(1)).isVarArg());
        Assert.assertNotNull((Object)fm.getAggregateAttributes());
        Assert.assertTrue((boolean)fm.getAggregateAttributes().allowsDistinct());
        Assert.assertEquals((Object)FunctionMethod.Determinism.DETERMINISTIC, (Object)fm.getDeterminism());
        Assert.assertEquals((Object)"misc", (Object)fm.getCategory());
        Assert.assertFalse((boolean)fm.isNullOnNull());
    }

    @Test
    public void testVarArgs() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc(flag boolean) RETURNS varchar options (varargs 'true', UUID 'z')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertTrue((boolean)((FunctionParameter)fm.getInputParameters().get(0)).isVarArg());
    }

    @Test
    public void testMixedCaseTypes() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc(flag Boolean) RETURNS varchaR options (UUID 'z')";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)fm.getInputParameters().get(0)).getType());
    }

    @Test(expected=MetadataException.class)
    public void testInvalidFunctionBody() throws Exception {
        String ddl = "CREATE FOREIGN FUNCTION SourceFunc(flag boolean) RETURNS varchar AS SELECT 'a';";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertTrue((boolean)((FunctionParameter)fm.getInputParameters().get(0)).isVarArg());
    }

    @Test(expected=MetadataException.class)
    public void testInvalidProcedureBody() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE SourceFunc(flag boolean) RETURNS varchar AS SELECT 'a';";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        FunctionMethod fm = s.getFunction("z");
        Assert.assertTrue((boolean)((FunctionParameter)fm.getInputParameters().get(0)).isVarArg());
    }

    @Test
    public void testVirtualProcedure() throws Exception {
        String ddl = "CREATE VIRTUAL PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal) OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2') AS /*+ cache */ BEGIN select * from foo; END";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Procedure proc = s.getProcedure("myProc");
        Assert.assertNotNull((Object)proc);
        Assert.assertTrue((boolean)proc.isVirtual());
        Assert.assertFalse((boolean)proc.isFunction());
        Assert.assertEquals((long)3L, (long)proc.getParameters().size());
        Assert.assertEquals((Object)"p1", (Object)((ProcedureParameter)proc.getParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((ProcedureParameter)proc.getParameters().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.Out, (Object)((ProcedureParameter)proc.getParameters().get(0)).getType());
        Assert.assertEquals((Object)"p2", (Object)((ProcedureParameter)proc.getParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((ProcedureParameter)proc.getParameters().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.In, (Object)((ProcedureParameter)proc.getParameters().get(1)).getType());
        Assert.assertEquals((Object)"p3", (Object)((ProcedureParameter)proc.getParameters().get(2)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((ProcedureParameter)proc.getParameters().get(2)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.InOut, (Object)((ProcedureParameter)proc.getParameters().get(2)).getType());
        ColumnSet ret = proc.getResultSet();
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)2L, (long)ret.getColumns().size());
        Assert.assertEquals((Object)"r1", (Object)((Column)ret.getColumns().get(0)).getName());
        Assert.assertEquals((Object)"string", (Object)((Column)ret.getColumns().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)"r2", (Object)((Column)ret.getColumns().get(1)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((Column)ret.getColumns().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)"uuid", (Object)proc.getUUID());
        Assert.assertEquals((Object)"nis", (Object)proc.getNameInSource());
        Assert.assertEquals((Object)"desc", (Object)proc.getAnnotation());
        Assert.assertEquals((long)2L, (long)proc.getUpdateCount());
        Assert.assertEquals((Object)"any", proc.getProperties().get("RANDOM"));
        Assert.assertEquals((Object)"/*+ cache */ BEGIN\nSELECT * FROM foo;\nEND", (Object)proc.getQueryPlan());
    }

    @Test
    public void testInsteadOfTrigger() throws Exception {
        String ddl = "CREATE VIEW G1( e1 integer, e2 varchar) AS select * from foo;CREATE TRIGGER ON G1 INSTEAD OF INSERT AS FOR EACH ROW \nBEGIN ATOMIC \ninsert into g1 (e1, e2) values (1, 'trig');\nEND;CREATE View G2( e1 integer, e2 varchar) AS select * from foo;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G2"));
        Assert.assertEquals((Object)"FOR EACH ROW\nBEGIN ATOMIC\nINSERT INTO g1 (e1, e2) VALUES (1, 'trig');\nEND", (Object)s.getTable("G1").getInsertPlan());
    }

    @Test
    public void testInsteadOfTriggerIsDistinct() throws Exception {
        String ddl = "CREATE VIEW G1( e1 integer, e2 varchar) AS select * from foo;CREATE TRIGGER ON G1 INSTEAD OF UPDATE AS FOR EACH ROW \nBEGIN ATOMIC \nif (\"new\" is not distinct from \"old\") raise sqlexception 'error';\nEND;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Assert.assertEquals((Object)"FOR EACH ROW\nBEGIN ATOMIC\nIF(\"new\" IS NOT DISTINCT FROM \"old\")\nBEGIN\nRAISE SQLEXCEPTION 'error';\nEND\nEND", (Object)s.getTable("G1").getUpdatePlan());
    }

    @Test(expected=MetadataException.class)
    public void testInsteadOfTriggerNoView() throws Exception {
        String ddl = "CREATE TRIGGER ON G1 INSTEAD OF INSERT AS FOR EACH ROW \nBEGIN ATOMIC \ninsert into g1 (e1, e2) values (1, 'trig');\nEND;CREATE View G2( e1 integer, e2 varchar) AS select * from foo;";
        TestDDLParser.helpParse(ddl, "model");
    }

    @Test
    public void testSourceProcedure() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal)OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Procedure proc = s.getProcedure("myProc");
        Assert.assertNotNull((Object)proc);
        Assert.assertFalse((boolean)proc.isVirtual());
        Assert.assertFalse((boolean)proc.isFunction());
        Assert.assertEquals((long)3L, (long)proc.getParameters().size());
        Assert.assertEquals((Object)"p1", (Object)((ProcedureParameter)proc.getParameters().get(0)).getName());
        Assert.assertEquals((Object)"boolean", (Object)((ProcedureParameter)proc.getParameters().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.Out, (Object)((ProcedureParameter)proc.getParameters().get(0)).getType());
        Assert.assertEquals((Object)"p2", (Object)((ProcedureParameter)proc.getParameters().get(1)).getName());
        Assert.assertEquals((Object)"string", (Object)((ProcedureParameter)proc.getParameters().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.In, (Object)((ProcedureParameter)proc.getParameters().get(1)).getType());
        Assert.assertEquals((Object)"p3", (Object)((ProcedureParameter)proc.getParameters().get(2)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((ProcedureParameter)proc.getParameters().get(2)).getDatatype().getName());
        Assert.assertEquals((Object)ProcedureParameter.Type.InOut, (Object)((ProcedureParameter)proc.getParameters().get(2)).getType());
        ColumnSet ret = proc.getResultSet();
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)2L, (long)ret.getColumns().size());
        Assert.assertEquals((Object)"r1", (Object)((Column)ret.getColumns().get(0)).getName());
        Assert.assertEquals((Object)"string", (Object)((Column)ret.getColumns().get(0)).getDatatype().getName());
        Assert.assertEquals((Object)"r2", (Object)((Column)ret.getColumns().get(1)).getName());
        Assert.assertEquals((Object)"bigdecimal", (Object)((Column)ret.getColumns().get(1)).getDatatype().getName());
        Assert.assertEquals((Object)"uuid", (Object)proc.getUUID());
        Assert.assertEquals((Object)"nis", (Object)proc.getNameInSource());
        Assert.assertEquals((Object)"desc", (Object)proc.getAnnotation());
        Assert.assertEquals((long)2L, (long)proc.getUpdateCount());
        Assert.assertEquals((Object)"any", proc.getProperties().get("RANDOM"));
    }

    @Test
    public void testNamespace() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "set namespace 'http://teiid.org' AS teiid";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
        Assert.assertTrue((boolean)mf.getNamespaces().keySet().contains("teiid"));
        Assert.assertEquals((Object)"http://teiid.org", mf.getNamespaces().get("teiid"));
    }

    @Test
    public void testReservedNamespace1() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "set namespace 'http://www.teiid.org/translator/salesforce/2012' AS teiid_sf";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
        Assert.assertTrue((boolean)mf.getNamespaces().keySet().contains("teiid_sf"));
        Assert.assertEquals((Object)"http://www.teiid.org/translator/salesforce/2012", mf.getNamespaces().get("teiid_sf"));
    }

    @Test(expected=MetadataException.class)
    public void testReservedNamespaceURIWrong() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "set namespace 'http://www.teiid.org/translator/salesforce/2013' AS teiid_sf";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
        Assert.assertTrue((boolean)mf.getNamespaces().keySet().contains("teiid_sf"));
        Assert.assertEquals((Object)"http://www.teiid.org/translator/salesforce/2012", mf.getNamespaces().get("teiid_sf"));
    }

    @Test(expected=MetadataException.class)
    public void testReservedNamespacePrefixMismatch() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "set namespace 'http://www.teiid.org/translator/salesforce/2012' AS teiid_foo";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
        Assert.assertTrue((boolean)mf.getNamespaces().keySet().contains("teiid_foo"));
        Assert.assertEquals((Object)"http://www.teiid.org/translator/salesforce/2012", mf.getNamespaces().get("teiid_foo"));
    }

    @Test
    public void testReservedURIDifferentNS() throws Exception {
        QueryParser parser = new QueryParser();
        String ddl = "set namespace 'http://www.teiid.org/translator/salesforce/2012' AS ns";
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        parser.parseDDL(mf, ddl);
        mf.mergeInto(mds);
        Assert.assertTrue((boolean)mf.getNamespaces().keySet().contains("ns"));
        Assert.assertEquals((Object)"http://www.teiid.org/translator/salesforce/2012", mf.getNamespaces().get("ns"));
    }

    public static MetadataFactory helpParse(String ddl, String model) {
        MetadataFactory mf = new MetadataFactory("x", (Object)1, model, TestDDLParser.getDataTypes(), new Properties(), null);
        QueryParser.getQueryParser().parseDDL(mf, ddl);
        return mf;
    }

    public static Database helpParse(String ddl) {
        DatabaseStore store = new DatabaseStore(){

            public Map<String, Datatype> getRuntimeTypes() {
                return TestDDLParser.getDataTypes();
            }

            public Map<String, Datatype> getBuiltinDataTypes() {
                return TestDDLParser.getDataTypes();
            }

            public SystemFunctionManager getSystemFunctionManager() {
                return new SystemFunctionManager();
            }
        };
        store.startEditing(true);
        QueryParser.getQueryParser().parseDDL(store, (Reader)new StringReader(ddl));
        store.stopEditing();
        if (store.getDatabases().isEmpty()) {
            return null;
        }
        return (Database)store.getDatabases().get(0);
    }

    public static Map<String, Datatype> getDataTypes() {
        return SystemMetadata.getInstance().getRuntimeTypeMap();
    }

    @Test
    public void testKeyResolve() {
        MetadataFactory mf = new MetadataFactory("x", (Object)1, "foo", TestDDLParser.getDataTypes(), new Properties(), null);
        mf.addNamespace("x", "http://x");
        Assert.assertEquals((Object)"{http://x}z", (Object)MetadataFactory.resolvePropertyKey((MetadataFactory)mf, (String)"x:z"));
        Assert.assertEquals((Object)"y:z", (Object)MetadataFactory.resolvePropertyKey((MetadataFactory)mf, (String)"y:z"));
    }

    @Test
    public void testCreateError() {
        try {
            TestDDLParser.helpParse("CREATE foreign FUNCTION convert(msg integer, type varchar) RETURNS varchar", "x");
            Assert.fail();
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"TEIID30386 org.teiid.api.exception.query.QueryParserException: TEIID31100 Parsing error: Encountered \"CREATE foreign FUNCTION [*]convert[*](msg\" at line 1, column 25.\nWas expecting: id", (Object)e.getMessage());
        }
    }

    @Test
    public void testAlterTableAddOptions() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);ALTER FOREIGN TABLE G1 OPTIONS(ADD CARDINALITY 12);ALTER FOREIGN TABLE G1 OPTIONS(ADD FOO 'BAR');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((long)12L, (long)table.getCardinality());
        Assert.assertEquals((Object)"BAR", (Object)table.getProperty("FOO", false));
    }

    @Test
    public void testAlterTableModifyOptions() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date) OPTIONS(CARDINALITY 12, FOO 'BAR');ALTER FOREIGN TABLE G1 OPTIONS(SET CARDINALITY 24);ALTER FOREIGN TABLE G1 OPTIONS(SET FOO 'BARBAR');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((long)24L, (long)table.getCardinality());
        Assert.assertEquals((Object)"BARBAR", (Object)table.getProperty("FOO", false));
    }

    @Test
    public void testAlterTableDropOptions() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date) OPTIONS(CARDINALITY 12, FOO 'BAR');ALTER FOREIGN TABLE G1 OPTIONS(DROP CARDINALITY);ALTER FOREIGN TABLE G1 OPTIONS(DROP FOO);";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((long)-1L, (long)table.getCardinality());
        Assert.assertNull((Object)table.getProperty("FOO", false));
    }

    @Test
    public void testAlterTableAddColumnOptions() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);ALTER FOREIGN TABLE G1 OPTIONS(ADD CARDINALITY 12);ALTER FOREIGN TABLE G1 ALTER COLUMN e1 OPTIONS(ADD NULL_VALUE_COUNT 12);ALTER FOREIGN TABLE G1 ALTER COLUMN e1 OPTIONS(ADD FOO 'BAR');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Assert.assertEquals((long)12L, (long)table.getCardinality());
        Column c = table.getColumnByName("e1");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"BAR", (Object)c.getProperty("FOO", false));
        Assert.assertEquals((long)12L, (long)c.getNullValues());
    }

    @Test
    public void testAlterTableRemoveColumnOptions() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer OPTIONS (NULL_VALUE_COUNT 12, FOO 'BAR'), e2 varchar, e3 date);ALTER FOREIGN TABLE G1 ALTER COLUMN e1 OPTIONS(DROP NULL_VALUE_COUNT);ALTER FOREIGN TABLE G1 ALTER COLUMN e1 OPTIONS(DROP FOO);ALTER FOREIGN TABLE G1 ALTER COLUMN e1 OPTIONS( ADD x 'y');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        NavigableMap tableMap = s.getTables();
        Assert.assertTrue((String)"Table not found", (boolean)tableMap.containsKey("G1"));
        Table table = (Table)tableMap.get("G1");
        Column c = table.getColumnByName("e1");
        Assert.assertNotNull((Object)c);
        Assert.assertNull((Object)c.getProperty("FOO", false));
        Assert.assertEquals((long)-1L, (long)c.getNullValues());
        Assert.assertEquals((Object)"y", (Object)c.getProperty("x", false));
    }

    @Test
    public void testAlterProcedureOptions() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal)OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');ALTER FOREIGN PROCEDURE myProc OPTIONS(SET NAMEINSOURCE 'x');ALTER FOREIGN PROCEDURE myProc ALTER PARAMETER p2 OPTIONS (ADD x 'y');ALTER FOREIGN PROCEDURE myProc OPTIONS(DROP UPDATECOUNT);";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Procedure proc = s.getProcedure("myProc");
        Assert.assertNotNull((Object)proc);
        Assert.assertEquals((Object)"x", (Object)proc.getNameInSource());
        Assert.assertEquals((Object)"p2", (Object)((ProcedureParameter)proc.getParameters().get(1)).getName());
        Assert.assertEquals((Object)"y", (Object)((ProcedureParameter)proc.getParameters().get(1)).getProperty("x", false));
        Assert.assertEquals((long)1L, (long)proc.getUpdateCount());
    }

    @Test
    public void testTypeLength() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar(10), r2 decimal(11,2), r3 object(1), r4 clob(10000))OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Procedure proc = s.getProcedure("myProc");
        Assert.assertNotNull((Object)proc);
        List cols = proc.getResultSet().getColumns();
        Assert.assertEquals((long)10L, (long)((Column)cols.get(0)).getLength());
        Assert.assertEquals((long)11L, (long)((Column)cols.get(1)).getPrecision());
        Assert.assertEquals((long)1L, (long)((Column)cols.get(2)).getLength());
        Assert.assertEquals((long)10000L, (long)((Column)cols.get(3)).getLength());
    }

    @Test
    public void testGlobalTemp() throws Exception {
        String ddl = "CREATE GLOBAL TEMPORARY TABLE T (col string);";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Table t = s.getTable("T");
        Assert.assertEquals((long)1L, (long)t.getColumns().size());
    }

    @Test
    public void testArrayType() throws Exception {
        String ddl = "CREATE VIEW V (col string[]) as select ('a','b');";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Table t = s.getTable("V");
        Assert.assertEquals((long)1L, (long)t.getColumns().size());
        Assert.assertEquals((Object)"string[]", (Object)((Column)t.getColumns().get(0)).getRuntimeType());
        Assert.assertEquals(String[].class, (Object)((Column)t.getColumns().get(0)).getJavaType());
    }

    @Test(expected=MetadataException.class)
    public void testAfterTriggerNameRequired() throws Exception {
        String ddl = "CREATE FOREIGN TABLE T ( e1 integer, e2 varchar);CREATE TRIGGER ON T AFTER UPDATE AS FOR EACH ROW \nBEGIN ATOMIC \nif (\"new\" is not distinct from \"old\") raise sqlexception 'error';\nEND;";
        TestDDLParser.helpParse(ddl, "model").getSchema();
    }

    @Test
    public void testAfterTrigger() throws Exception {
        String ddl = "CREATE FOREIGN TABLE T ( e1 integer, e2 varchar);CREATE TRIGGER tr ON T AFTER UPDATE AS FOR EACH ROW \nBEGIN ATOMIC \nif (\"new\" is not distinct from \"old\") raise sqlexception 'error';\nEND;";
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        Table t = s.getTable("T");
        Assert.assertEquals((long)1L, (long)t.getTriggers().size());
        Trigger tr = (Trigger)t.getTriggers().values().iterator().next();
        Assert.assertEquals((Object)"tr", (Object)tr.getName());
        Assert.assertEquals((Object)Table.TriggerEvent.UPDATE, (Object)tr.getEvent());
        Assert.assertNotNull((Object)tr.getPlan());
    }

    @Test
    public void testCreateDatabase() throws Exception {
        String ddl = "CREATE DATABASE FOO VERSION '2' OPTIONS (k1 'v1', k2 'v2')";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertEquals((Object)"FOO", (Object)db.getName());
        Assert.assertEquals((Object)"2", (Object)db.getVersion());
        Assert.assertEquals((Object)"v1", (Object)db.getProperty("k1", false));
        Assert.assertEquals((Object)"v2", (Object)db.getProperty("k2", false));
    }

    @Test
    public void testAlterDatabase() throws Exception {
        String ddl = "CREATE DATABASE FOO VERSION '2' OPTIONS (k1 'v1', k2 'v2');ALTER DATABASE FOO OPTIONS (ADD k3 'v3', SET k1 'v4', DROP k2);";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertEquals((Object)"FOO", (Object)db.getName());
        Assert.assertEquals((Object)"2", (Object)db.getVersion());
        Assert.assertEquals((Object)"v4", (Object)db.getProperty("k1", false));
        Assert.assertNull((Object)db.getProperty("k2", false));
        Assert.assertEquals((Object)"v3", (Object)db.getProperty("k3", false));
    }

    @Test
    public void testAlterServer() throws Exception {
        String ddl = "CREATE DATABASE FOO VERSION '2';CREATE FOREIGN DATA WRAPPER orcl;CREATE SERVER x TYPE 'oracle' VERSION '2.0' FOREIGN DATA WRAPPER orcl OPTIONS (k1 'v1');ALTER SERVER x OPTIONS(SET k1 'v2')";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertEquals((Object)"FOO", (Object)db.getName());
        Assert.assertEquals((Object)"2", (Object)db.getVersion());
        Server s = db.getServer("x");
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)"v2", (Object)s.getProperty("k1", false));
    }

    @Test
    public void testCreateDatabaseNoVersion() throws Exception {
        String ddl = "CREATE DATABASE FOO OPTIONS (k1 'v1', k2 'v2')";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertEquals((Object)"FOO", (Object)db.getName());
        Assert.assertEquals((Object)"1", (Object)db.getVersion());
        Assert.assertEquals((Object)"v1", (Object)db.getProperty("k1", false));
        Assert.assertEquals((Object)"v2", (Object)db.getProperty("k2", false));
    }

    @Test
    public void testCreateDropDatabase() throws Exception {
        String ddl = "CREATE DATABASE FOO;DROP DATABASE FOO;";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertNull((Object)db);
    }

    @Test
    public void testCreateSchema() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER orcl;CREATE SERVER x TYPE 'oracle' VERSION '2.0' FOREIGN DATA WRAPPER orcl OPTIONS (k1 'v1');CREATE SCHEMA S1 SERVER x OPTIONS (x 'y');";
        Database db = TestDDLParser.helpParse(ddl);
        Schema schema = db.getSchema("S1");
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((Object)"y", (Object)schema.getProperty("x", false));
        Assert.assertNotNull((Object)db.getServer("x"));
        Assert.assertNotNull((Object)schema.getServer("x"));
        Assert.assertEquals((Object)"v1", (Object)db.getServer("x").getProperty("k1", false));
        Assert.assertNotNull((Object)db.getDataWrapper("orcl"));
        Assert.assertEquals((Object)"orcl", (Object)db.getServer("x").getDataWrapper());
    }

    @Test
    public void testRole() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE ROLE superuser WITH JAAS ROLE x,y;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((Object)"[x, y]", (Object)role.getJassRoles().toString());
    }

    @Test
    public void testRoleAnyAuth() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((Object)"[x, y]", (Object)role.getJassRoles().toString());
        Assert.assertTrue((boolean)role.isAnyAuthenticated());
    }

    @Test
    public void testDropRole() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;DROP ROLE superuser";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNull((Object)role);
    }

    @Test
    public void testGrant() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;GRANT SELECT,INSERT,DELETE ON TABLE G1 TO superuser;GRANT UPDATE ON TABLE test.G1 TO superuser;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Collection grants = db.getGrants();
        Assert.assertEquals((long)1L, (long)grants.size());
        Grant g = (Grant)grants.iterator().next();
        Assert.assertEquals((long)1L, (long)g.getPermissions().size());
        Grant.Permission p = (Grant.Permission)g.getPermissions().iterator().next();
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.SELECT));
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.INSERT));
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.DELETE));
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.UPDATE));
        Assert.assertFalse((boolean)p.hasPrivilege(Grant.Permission.Privilege.DROP));
    }

    @Test
    public void testGrantAll() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;GRANT ALL PRIVILEGES ON TABLE test.G1 TO superuser;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Collection grants = db.getGrants();
        Assert.assertEquals((long)1L, (long)grants.size());
        Grant g = (Grant)grants.iterator().next();
        Assert.assertEquals((long)1L, (long)g.getPermissions().size());
        Grant.Permission p = (Grant.Permission)g.getPermissions().iterator().next();
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.ALL_PRIVILEGES));
    }

    @Test
    public void testGrantWithCondition() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;GRANT ALL PRIVILEGES ON TABLE test.G1 CONDITION CONSTRAINT 'foo=bar' TO superuser;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Collection grants = db.getGrants();
        Assert.assertEquals((long)1L, (long)grants.size());
        Grant g = (Grant)grants.iterator().next();
        Assert.assertEquals((long)1L, (long)g.getPermissions().size());
        Grant.Permission p = (Grant.Permission)g.getPermissions().iterator().next();
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.ALL_PRIVILEGES));
        Assert.assertEquals((Object)"foo=bar", (Object)p.getCondition());
        Assert.assertTrue((boolean)p.isConditionAConstraint());
    }

    @Test
    public void testRevokeGrant() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;GRANT SELECT,INSERT,DELETE ON TABLE G1 TO superuser;GRANT UPDATE ON TABLE test.G1 TO superuser;REVOKE GRANT SELECT ON TABLE test.G1 FROM superuser;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Collection grants = db.getGrants();
        Assert.assertEquals((long)1L, (long)grants.size());
        Grant g = (Grant)grants.iterator().next();
        Assert.assertEquals((long)1L, (long)g.getPermissions().size());
        Grant.Permission p = (Grant.Permission)g.getPermissions().iterator().next();
        Assert.assertFalse((boolean)p.hasPrivilege(Grant.Permission.Privilege.SELECT));
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.INSERT));
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.DELETE));
        Assert.assertTrue((boolean)p.hasPrivilege(Grant.Permission.Privilege.UPDATE));
        Assert.assertFalse((boolean)p.hasPrivilege(Grant.Permission.Privilege.DROP));
    }

    @Test
    public void testRevokeALl() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);CREATE ROLE superuser WITH JAAS ROLE x,y WITH ANY AUTHENTICATED;GRANT SELECT,INSERT,DELETE ON TABLE G1 TO superuser;GRANT UPDATE ON TABLE test.G1 TO superuser;REVOKE GRANT ALL PRIVILEGES ON TABLE test.G1 FROM superuser;";
        Database db = TestDDLParser.helpParse(ddl);
        Role role = db.getRole("superuser");
        Assert.assertNotNull((Object)role);
        Collection grants = db.getGrants();
        Assert.assertEquals((long)0L, (long)grants.size());
    }

    @Test
    public void testPhysicalTable() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((t.getColumns().size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)t.getColumnByName("e1"));
        Assert.assertNotNull((Object)t.getColumnByName("e2"));
        Assert.assertNotNull((Object)t.getColumnByName("e3"));
    }

    @Test
    public void testAlterView() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE VIRTUAL SCHEMA test;CREATE VIRTUAL VIEW G1( e1 integer, e2 varchar, e3 date) AS SELECT 1, '2', curdate();ALTER VIEW G1 AS /*+ foo */ SELECT 1, 'foo', curdate()";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertEquals((Object)"SELECT 1, 'foo', curdate()", (Object)t.getSelectTransformation());
    }

    @Test
    public void testPhysicalTableAlterAddColumn() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);ALTER TABLE G1 ADD COLUMN e4 integer PRIMARY KEY OPTIONS(x 10)";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((t.getColumns().size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)t.getColumnByName("e1"));
        Assert.assertNotNull((Object)t.getColumnByName("e2"));
        Assert.assertNotNull((Object)t.getColumnByName("e3"));
        Assert.assertNotNull((Object)t.getColumnByName("e4"));
        Column c = t.getColumnByName("e4");
        Assert.assertEquals((Object)"integer", (Object)c.getRuntimeType());
        Assert.assertNotNull((Object)t.getPrimaryKey().getColumnByName("e4"));
        Assert.assertEquals((Object)"10", (Object)c.getProperty("x", false));
    }

    @Test
    public void testPhysicalTableAlterDropColumn() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);ALTER TABLE G1 DROP COLUMN e1";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((t.getColumns().size() == 2 ? 1 : 0) != 0);
        Assert.assertNull((Object)t.getColumnByName("e1"));
        Assert.assertNotNull((Object)t.getColumnByName("e2"));
        Assert.assertNotNull((Object)t.getColumnByName("e3"));
    }

    @Test
    public void testDropPhysicalTable() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date);DROP FOREIGN TABLE G1";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertNull((Object)t);
    }

    @Test
    public void testAlterViewAddColumn2() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE VIRTUAL SCHEMA test;CREATE VIRTUAL VIEW G1 AS SELECT 1 as e1, '2' as e2, curdate() as e3;ALTER VIEW G1 AS SELECT 1 as e1, '2' as e2, curdate() as e3, 'foo' as e4;";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertEquals((Object)"SELECT 1 AS e1, '2' AS e2, curdate() AS e3, 'foo' AS e4", (Object)t.getSelectTransformation());
    }

    @Test
    public void testDropView() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE VIRTUAL SCHEMA test;CREATE VIRTUAL VIEW G1 AS SELECT 1 as e1, '2' as e2, curdate() as e3;DROP VIEW G1";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Table t = s.getTable("G1");
        Assert.assertNull((Object)t);
    }

    @Test
    public void testFunction() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN FUNCTION SourceFunc(flag Boolean) RETURNS varchar";
        FunctionMethod method = null;
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        for (FunctionMethod fm : s.getFunctions().values()) {
            if (!fm.getName().equalsIgnoreCase("SourceFunc")) continue;
            method = fm;
            break;
        }
        Assert.assertNotNull(method);
        Assert.assertEquals((Object)"boolean", (Object)((FunctionParameter)method.getInputParameters().get(0)).getType());
    }

    @Test
    public void testDropFunction() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FUNCTION SourceFunc(flag Boolean) RETURNS varchaR options (UUID 'z');DROP FUNCTION SourceFunc;";
        FunctionMethod method = null;
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        for (FunctionMethod fm : s.getFunctions().values()) {
            if (!fm.getName().equalsIgnoreCase("SourceFunc")) continue;
            method = fm;
            break;
        }
        Assert.assertNull(method);
    }

    @Test
    public void testDropSchema() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE VIRTUAL SCHEMA test;CREATE VIRTUAL VIEW G1 AS SELECT 1 as e1, '2' as e2, curdate() as e3;DROP VIRTUAL SCHEMA test";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Assert.assertNull((Object)s);
    }

    @Test(expected=MetadataException.class)
    public void testDropDataWrapper() throws Exception {
        String ddl = "CREATE DATABASE FOO VERSION '2';CREATE FOREIGN DATA WRAPPER orcl;CREATE SERVER x TYPE 'oracle' VERSION '2.0' FOREIGN DATA WRAPPER orcl OPTIONS (k1 'v1');DROP FOREIGN DATA WRAPPER orcl;";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertNull((Object)db.getDataWrapper("orcl"));
    }

    @Test
    public void testDropDataWrappers() throws Exception {
        String ddl = "CREATE DATABASE FOO VERSION '2';CREATE FOREIGN DATA WRAPPER orcl;CREATE SERVER x TYPE 'oracle' VERSION '2.0' FOREIGN DATA WRAPPER orcl OPTIONS (k1 'v1');DROP SERVER x;DROP FOREIGN DATA WRAPPER orcl;";
        Database db = TestDDLParser.helpParse(ddl);
        Assert.assertNull((Object)db.getDataWrapper("orcl"));
    }

    @Test
    public void testCreateProcedure() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN PROCEDURE procG1(P1 integer) RETURNS (e1 integer, e2 varchar)";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Procedure p = s.getProcedure("procG1");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)1L, (long)p.getParameters().size());
        Assert.assertNotNull((Object)p.getParameterByName("P1"));
        Assert.assertEquals((long)2L, (long)p.getResultSet().getColumns().size());
        Assert.assertEquals((Object)"e1", (Object)((Column)p.getResultSet().getColumns().get(0)).getName());
    }

    @Test
    public void testDropProcedure() throws Exception {
        String ddl = "CREATE DATABASE FOO;CREATE FOREIGN DATA WRAPPER postgresql;CREATE SERVER pgsql TYPE 'custom' FOREIGN DATA WRAPPER postgresql OPTIONS (\"jndi-name\" 'jndiname');CREATE  SCHEMA test SERVER pgsql;CREATE FOREIGN PROCEDURE procG1(P1 integer) RETURNS (e1 integer, e2 varchar);DROP FOREIGN PROCEDURE procG1";
        Database db = TestDDLParser.helpParse(ddl);
        Schema s = db.getSchema("test");
        Procedure p = s.getProcedure("procG1");
        Assert.assertNull((Object)p);
    }
}

