/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Collection;
import java.util.List;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Grant;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;

public class DatabaseUtil {
    public static Database convert(VDBMetaData vdb, MetadataStore metadataStore) {
        Database db = new Database(vdb.getName(), vdb.getVersion());
        db.setProperties(vdb.getPropertiesMap());
        if (vdb.getDescription() != null) {
            db.setAnnotation(vdb.getDescription());
        }
        db.setProperty("connection-type", vdb.getConnectionType().name());
        List translators = vdb.getOverrideTranslators();
        for (Translator t : translators) {
            DataWrapper dw;
            if (db.getDataWrapper(t.getType()) == null) {
                dw = new DataWrapper(t.getType());
                db.addDataWrapper(dw);
            }
            if (db.getDataWrapper(t.getName()) != null) continue;
            dw = new DataWrapper(t.getName());
            for (String key : t.getProperties().stringPropertyNames()) {
                dw.setProperty(key, t.getPropertyValue(key));
            }
            if (t.getDescription() != null) {
                dw.setAnnotation(t.getDescription());
            }
            db.addDataWrapper(dw);
        }
        Collection models = vdb.getModelMetaDatas().values();
        for (ModelMetaData m : models) {
            Schema schema = metadataStore.getSchema(m.getName());
            if (m.isSource()) {
                Collection sources = m.getSourceMappings();
                for (SourceMappingMetadata s : sources) {
                    if (db.getDataWrapper(s.getTranslatorName()) == null) {
                        DataWrapper dw = new DataWrapper(s.getTranslatorName());
                        db.addDataWrapper(dw);
                    }
                    Server server = new Server(s.getName());
                    if (s.getConnectionJndiName() != null) {
                        server.setJndiName(s.getConnectionJndiName());
                    } else {
                        server.setType("NONE");
                    }
                    server.setDataWrapper(s.getTranslatorName());
                    if (db.getServer(s.getName()) != null) continue;
                    db.addServer(server);
                    schema.addServer(server);
                }
            }
            if (m.getDescription() != null) {
                schema.setAnnotation(m.getDescription());
            }
            if (!m.isVisible()) {
                schema.setVisible(false);
            }
            db.addSchema(schema);
        }
        for (String key : vdb.getDataPolicyMap().keySet()) {
            Grant.Permission permission;
            DataPolicyMetadata dpm = (DataPolicyMetadata)vdb.getDataPolicyMap().get(key);
            Role role = new Role(dpm.getName());
            if (dpm.getMappedRoleNames() != null && !dpm.getMappedRoleNames().isEmpty()) {
                role.setJaasRoles(dpm.getMappedRoleNames());
            }
            if (dpm.isAnyAuthenticated()) {
                role.setAnyAuthenticated(true);
            }
            Grant grant = null;
            if (dpm.isGrantAll()) {
                if (grant == null) {
                    grant = new Grant();
                    grant.setRole(role.getName());
                }
                permission = new Grant.Permission();
                permission.setAllowAllPrivileges(Boolean.valueOf(true));
                permission.setResourceType(Database.ResourceType.DATABASE);
                grant.addPermission(permission);
            }
            if (dpm.isAllowCreateTemporaryTables() != null && dpm.isAllowCreateTemporaryTables().booleanValue()) {
                if (grant == null) {
                    grant = new Grant();
                    grant.setRole(role.getName());
                }
                permission = new Grant.Permission();
                permission.setAllowTemporyTables(Boolean.valueOf(true));
                permission.setResourceType(Database.ResourceType.DATABASE);
                grant.addPermission(permission);
            }
            for (DataPolicy.DataPermission dp : dpm.getPermissions()) {
                if (grant == null) {
                    grant = new Grant();
                    grant.setRole(role.getName());
                }
                Grant.Permission permission2 = DatabaseUtil.convert(dp);
                grant.addPermission(permission2);
            }
            db.addRole(role);
            db.addGrant(grant);
        }
        return db;
    }

    private static Grant.Permission convert(DataPolicy.DataPermission dp) {
        Grant.Permission p = new Grant.Permission();
        p.setResourceType(Database.ResourceType.TABLE);
        p.setAllowAlter(dp.getAllowAlter());
        p.setAllowDelete(dp.getAllowDelete());
        p.setAllowDrop(Boolean.valueOf(false));
        p.setAllowExecute(dp.getAllowExecute());
        p.setAllowInsert(dp.getAllowCreate());
        p.setAllowLanguage(dp.getAllowLanguage());
        p.setAllowSelect(dp.getAllowRead());
        p.setAllowUpdate(dp.getAllowUpdate());
        p.setResourceName(dp.getResourceName());
        int dotCount = dp.getResourceName().length() - dp.getResourceName().replaceAll("\\.", "").length();
        if (dp.getAllowLanguage() != null && dp.getAllowLanguage().booleanValue()) {
            p.setResourceType(Database.ResourceType.DATABASE);
        } else if (dotCount == 0) {
            p.setResourceType(Database.ResourceType.SCHEMA);
        } else if (dp.getAllowExecute() != null && dp.getAllowExecute().booleanValue()) {
            p.setResourceType(Database.ResourceType.PROCEDURE);
        } else if (dotCount >= 2) {
            p.setResourceType(Database.ResourceType.COLUMN);
        }
        if (dp.getMask() != null) {
            p.setMask(dp.getMask());
            p.setMaskOrder(dp.getOrder());
        }
        if (dp.getCondition() != null) {
            p.setCondition(dp.getCondition(), dp.getConstraint());
        }
        return p;
    }

    public static VDBMetaData convert(Database database) {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName(database.getName());
        vdb.setVersion(database.getVersion());
        vdb.setDescription(database.getAnnotation());
        if (database.getProperty("connection-type", false) != null) {
            vdb.setConnectionType(VDB.ConnectionType.valueOf((String)database.getProperty("connection-type", false)));
        }
        vdb.getPropertiesMap().putAll(database.getProperties());
        for (DataWrapper dw : database.getDataWrappers()) {
            if (dw.getType() == null) continue;
            VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
            translator.setName(dw.getName());
            translator.setType(dw.getType());
            translator.setDescription(dw.getAnnotation());
            translator.getPropertiesMap().putAll(dw.getProperties());
            vdb.addOverideTranslator(translator);
        }
        for (Schema schema : database.getSchemas()) {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName(schema.getName());
            mmd.setDescription(schema.getAnnotation());
            mmd.setVisible(Boolean.valueOf(schema.isVisible()).booleanValue());
            if (schema.isPhysical()) {
                mmd.setModelType(Model.Type.PHYSICAL);
                for (Server server : schema.getServers()) {
                    String connectionName = server.getJndiName();
                    if (connectionName == null) {
                        connectionName = server.getName();
                    }
                    if (server.getType().equalsIgnoreCase("NONE")) {
                        mmd.addSourceMapping(server.getName(), server.getDataWrapper(), null);
                        continue;
                    }
                    mmd.addSourceMapping(server.getName(), server.getDataWrapper(), connectionName);
                }
            } else {
                mmd.setModelType(Model.Type.VIRTUAL);
            }
            vdb.addModel(mmd);
        }
        for (Grant grant : database.getGrants()) {
            Role role = database.getRole(grant.getRole());
            DataPolicyMetadata dpm = DatabaseUtil.convert(grant, role);
            vdb.addDataPolicy(dpm);
        }
        return vdb;
    }

    static DataPolicyMetadata.PermissionMetaData convert(Grant.Permission from) {
        DataPolicyMetadata.PermissionMetaData pmd = new DataPolicyMetadata.PermissionMetaData();
        pmd.setResourceName(from.getResourceName());
        if (from.hasPrivilege(Grant.Permission.Privilege.ALTER)) {
            pmd.setAllowAlter(Boolean.valueOf(true));
        }
        if (from.hasPrivilege(Grant.Permission.Privilege.INSERT)) {
            pmd.setAllowCreate(Boolean.valueOf(true));
        }
        if (from.hasPrivilege(Grant.Permission.Privilege.DELETE)) {
            pmd.setAllowDelete(Boolean.valueOf(true));
        }
        if (from.hasPrivilege(Grant.Permission.Privilege.EXECUTE)) {
            pmd.setAllowExecute(Boolean.valueOf(true));
        }
        if (from.hasPrivilege(Grant.Permission.Privilege.SELECT)) {
            pmd.setAllowRead(Boolean.valueOf(true));
        }
        if (from.hasPrivilege(Grant.Permission.Privilege.UPDATE)) {
            pmd.setAllowUpdate(Boolean.valueOf(true));
        }
        if (from.hasPrivilege(Grant.Permission.Privilege.LANGUAGE)) {
            pmd.setAllowLanguage(Boolean.valueOf(true));
        }
        pmd.setCondition(from.getCondition());
        pmd.setConstraint(from.isConditionAConstraint());
        pmd.setMask(from.getMask());
        pmd.setOrder(from.getMaskOrder());
        return pmd;
    }

    static DataPolicyMetadata convert(Grant from, Role role) {
        DataPolicyMetadata dpm = new DataPolicyMetadata();
        dpm.setName(from.getRole());
        for (Grant.Permission p : from.getPermissions()) {
            if (p.hasPrivilege(Grant.Permission.Privilege.ALL_PRIVILEGES)) {
                dpm.setGrantAll(true);
                continue;
            }
            if (p.hasPrivilege(Grant.Permission.Privilege.TEMPORARY_TABLE)) {
                dpm.setAllowCreateTemporaryTables(Boolean.valueOf(true));
                continue;
            }
            DataPolicyMetadata.PermissionMetaData pmd = DatabaseUtil.convert(p);
            dpm.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd});
        }
        if (role != null) {
            dpm.setDescription(role.getAnnotation());
        }
        if (role != null && role.getJassRoles() != null && !role.getJassRoles().isEmpty()) {
            dpm.setMappedRoleNames(role.getJassRoles());
        }
        if (role.isAnyAuthenticated()) {
            dpm.setAnyAuthenticated(true);
        }
        return dpm;
    }
}

