/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Database;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.DDLProcessor;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;

public class DdlPlan
extends ProcessorPlan {
    private Command command;
    private ProcessorDataManager pdm;

    public static void alterView(final VDBMetaData vdb, final Table t, final String sql, boolean updateStore) {
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        DatabaseStore store = (DatabaseStore)vdb.getAttachment(DatabaseStore.class);
        try {
            Command command = QueryParser.getQueryParser().parseCommand(t.getSelectTransformation());
            QueryResolver.resolveCommand(command, metadata);
            MetadataValidator.determineDependencies((AbstractMetadataRecord)t, command);
        }
        catch (TeiidException teiidException) {
            // empty catch block
        }
        t.setSelectTransformation(sql);
        t.setLastModified(System.currentTimeMillis());
        metadata.addToMetadataCache(t, "transformation/SELECT", null);
        if (store != null && updateStore) {
            DdlPlan.alterDatabaseStore(store, vdb.getName(), vdb.getVersion(), new DDLChange(){

                @Override
                public void process(DatabaseStore store) {
                    store.databaseSwitched(vdb.getName(), vdb.getVersion());
                    store.schemaSwitched(((Schema)t.getParent()).getName());
                    store.setViewDefinition(t.getName(), sql, false);
                }
            });
        }
    }

    public static String setProperty(final VDBMetaData vdb, final AbstractMetadataRecord record, final String key, final String value) {
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        DatabaseStore store = (DatabaseStore)vdb.getAttachment(DatabaseStore.class);
        String result = record.setProperty(key, value);
        metadata.addToMetadataCache(record, "transformation/matview", null);
        if (record instanceof Table) {
            ((Table)record).setLastModified(System.currentTimeMillis());
        } else if (record instanceof Procedure) {
            ((Procedure)record).setLastModified(System.currentTimeMillis());
        }
        if (store != null) {
            Database.ResourceType type;
            Database.ResourceType resourceType = record instanceof Schema ? Database.ResourceType.SCHEMA : (record instanceof Table ? Database.ResourceType.TABLE : (record instanceof Procedure ? Database.ResourceType.PROCEDURE : (record instanceof FunctionMethod ? Database.ResourceType.FUNCTION : (type = record instanceof ProcedureParameter ? Database.ResourceType.PARAMETER : Database.ResourceType.COLUMN))));
            if (type != Database.ResourceType.COLUMN || record instanceof Column && record.getParent() instanceof Table) {
                DdlPlan.alterDatabaseStore(store, vdb.getName(), vdb.getVersion(), new DDLChange(){

                    @Override
                    public void process(DatabaseStore store) {
                        store.databaseSwitched(vdb.getName(), vdb.getVersion());
                        if (type.equals((Object)Database.ResourceType.COLUMN)) {
                            store.addOrSetOption(record.getParent().getName(), Database.ResourceType.TABLE, record.getName(), type, key, value, false);
                        } else if (type.equals((Object)Database.ResourceType.PARAMETER)) {
                            store.addOrSetOption(record.getParent().getName(), Database.ResourceType.PROCEDURE, record.getName(), type, key, value, false);
                        } else {
                            store.addOrSetOption(record.getFullName(), type, key, value, false);
                        }
                    }
                });
            }
        }
        return result;
    }

    public static void setColumnStats(final VDBMetaData vdb, Column column, final ColumnStats columnStats) {
        DatabaseStore store;
        column.setColumnStats(columnStats);
        if (column.getParent() instanceof Table) {
            ((Table)column.getParent()).setLastModified(System.currentTimeMillis());
        }
        if ((store = (DatabaseStore)vdb.getAttachment(DatabaseStore.class)) != null) {
            final String tableName = column.getParent().getName();
            final String columnName = column.getName();
            DdlPlan.alterDatabaseStore(store, vdb.getName(), vdb.getVersion(), new DDLChange(){

                @Override
                public void process(DatabaseStore store) {
                    store.databaseSwitched(vdb.getName(), vdb.getVersion());
                    store.addOrSetOption(tableName, Database.ResourceType.TABLE, columnName, Database.ResourceType.COLUMN, "DISTINCT_VALUES", columnStats.getDistinctValues().toString(), false);
                    store.addOrSetOption(tableName, Database.ResourceType.TABLE, columnName, Database.ResourceType.COLUMN, "NULL_VALUE_COUNT", columnStats.getNullValues().toString(), false);
                    store.addOrSetOption(tableName, Database.ResourceType.TABLE, columnName, Database.ResourceType.COLUMN, "MAX_VALUE", columnStats.getMaximumValue().toString(), false);
                    store.addOrSetOption(tableName, Database.ResourceType.TABLE, columnName, Database.ResourceType.COLUMN, "MIN_VALUE", columnStats.getMinimumValue().toString(), false);
                }
            });
        }
    }

    public static void setTableStats(final VDBMetaData vdb, final Table table, final TableStats tableStats) {
        table.setTableStats(tableStats);
        table.setLastModified(System.currentTimeMillis());
        DatabaseStore store = (DatabaseStore)vdb.getAttachment(DatabaseStore.class);
        if (store != null) {
            DdlPlan.alterDatabaseStore(store, vdb.getName(), vdb.getVersion(), new DDLChange(){

                @Override
                public void process(DatabaseStore store) {
                    store.databaseSwitched(vdb.getName(), vdb.getVersion());
                    store.addOrSetOption(table.getName(), Database.ResourceType.TABLE, "CARDINALITY", tableStats.getCardinality().toString(), false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void alterDatabaseStore(DatabaseStore store, String vdbName, String version, DDLChange change) {
        Database db = store.getDatabase(vdbName, version);
        if (db != null) {
            store.startEditing(true);
            try {
                change.process(store);
            }
            finally {
                store.stopEditing();
            }
        }
    }

    public static void alterProcedureDefinition(final VDBMetaData vdb, final Procedure p, final String sql, boolean updateStore) {
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        DatabaseStore store = (DatabaseStore)vdb.getAttachment(DatabaseStore.class);
        try {
            Command command = QueryParser.getQueryParser().parseProcedure(p.getQueryPlan(), false);
            QueryResolver.resolveCommand(command, new GroupSymbol(p.getFullName()), 6, metadata, false);
            MetadataValidator.determineDependencies((AbstractMetadataRecord)p, command);
        }
        catch (TeiidException teiidException) {
            // empty catch block
        }
        p.setQueryPlan(sql);
        p.setLastModified(System.currentTimeMillis());
        metadata.addToMetadataCache(p, "transformation/" + StoredProcedure.class.getSimpleName().toUpperCase(), null);
        if (store != null && updateStore) {
            DdlPlan.alterDatabaseStore(store, vdb.getName(), vdb.getVersion(), new DDLChange(){

                @Override
                public void process(DatabaseStore store) {
                    store.databaseSwitched(vdb.getName(), vdb.getVersion());
                    store.schemaSwitched(p.getParent().getName());
                    store.setProcedureDefinition(p.getName(), sql, false);
                }
            });
        }
    }

    public static void alterInsteadOfTrigger(final VDBMetaData vdb, final Table t, final String sql, final Boolean enabled, final Table.TriggerEvent event, boolean updateStore) {
        switch (event) {
            case DELETE: {
                if (sql != null) {
                    t.setDeletePlan(sql);
                    break;
                }
                t.setDeletePlanEnabled(enabled.booleanValue());
                break;
            }
            case INSERT: {
                if (sql != null) {
                    t.setInsertPlan(sql);
                    break;
                }
                t.setInsertPlanEnabled(enabled.booleanValue());
                break;
            }
            case UPDATE: {
                if (sql != null) {
                    t.setUpdatePlan(sql);
                    break;
                }
                t.setUpdatePlanEnabled(enabled.booleanValue());
            }
        }
        TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        indexMetadata.addToMetadataCache(t, "transformation/" + event, null);
        t.setLastModified(System.currentTimeMillis());
        DatabaseStore store = (DatabaseStore)vdb.getAttachment(DatabaseStore.class);
        if (store != null && updateStore) {
            DdlPlan.alterDatabaseStore(store, vdb.getName(), vdb.getVersion(), new DDLChange(){

                @Override
                public void process(DatabaseStore store) {
                    store.databaseSwitched(vdb.getName(), vdb.getVersion());
                    store.schemaSwitched(((Schema)t.getParent()).getName());
                    if (sql != null) {
                        store.setTableTriggerPlan(null, t.getName(), event, sql, false);
                    } else {
                        store.enableTableTriggerPlan(t.getName(), event, enabled, false);
                    }
                }
            });
        }
    }

    private static String getPlanForEvent(Table t, Table.TriggerEvent event) {
        switch (event) {
            case DELETE: {
                return t.getDeletePlan();
            }
            case INSERT: {
                return t.getInsertPlan();
            }
            case UPDATE: {
                return t.getUpdatePlan();
            }
        }
        throw new AssertionError();
    }

    public DdlPlan(Command command) {
        this.command = command;
    }

    @Override
    public ProcessorPlan clone() {
        return new DdlPlan(this.command);
    }

    @Override
    public void close() throws TeiidComponentException {
    }

    @Override
    public List getOutputElements() {
        return this.command.getProjectedSymbols();
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.pdm = dataMgr;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        TupleBatch tupleBatch = new TupleBatch(1L, new List[]{Arrays.asList(0)});
        tupleBatch.setTerminationFlag(true);
        return tupleBatch;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        AlterProcessor ap = new AlterProcessor();
        try {
            this.command.acceptVisitor(ap);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        return props;
    }

    public String toString() {
        return this.command.toString();
    }

    public static interface DDLChange {
        public void process(DatabaseStore var1);
    }

    class AlterProcessor
    extends LanguageVisitor {
        DQPWorkContext workContext;
        VDBMetaData vdb;
        TransformationMetadata metadata;
        DDLProcessor processor;

        AlterProcessor() {
            this.workContext = DdlPlan.this.getContext().getDQPWorkContext();
            this.vdb = DdlPlan.this.getContext().getVdb();
            this.metadata = (TransformationMetadata)this.vdb.getAttachment(TransformationMetadata.class);
            this.processor = null;
        }

        private MetadataRepository getMetadataRepository(VDBMetaData vdb, String schemaName) {
            ModelMetaData model = vdb.getModel(schemaName);
            return (MetadataRepository)model.getAttachment(MetadataRepository.class);
        }

        @Override
        public void visit(AlterView obj) {
            Table t = (Table)obj.getTarget().getMetadataID();
            String sql = ((QueryCommand)obj.getDefinition()).toString();
            if (this.processor != null && this.processor.vdbExists(this.vdb.getName(), this.vdb.getVersion())) {
                this.processor.processDDL(this.vdb.getName(), this.vdb.getVersion(), ((Schema)t.getParent()).getName(), obj.toString(), true, DdlPlan.this.getContext());
            } else {
                if (this.getMetadataRepository(this.vdb, ((Schema)t.getParent()).getName()) != null) {
                    this.getMetadataRepository(this.vdb, ((Schema)t.getParent()).getName()).setViewDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), t, sql);
                }
                DdlPlan.alterView(this.vdb, t, sql, false);
                if (DdlPlan.this.pdm.getEventDistributor() != null) {
                    DdlPlan.this.pdm.getEventDistributor().setViewDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), ((Schema)t.getParent()).getName(), t.getName(), sql);
                }
            }
        }

        @Override
        public void visit(AlterProcedure obj) {
            Procedure p = (Procedure)obj.getTarget().getMetadataID();
            String sql = ((CreateProcedureCommand)obj.getDefinition()).toString();
            if (this.processor != null && this.processor.vdbExists(this.vdb.getName(), this.vdb.getVersion())) {
                this.processor.processDDL(this.vdb.getName(), this.vdb.getVersion(), p.getParent().getName(), obj.toString(), true, DdlPlan.this.getContext());
            } else {
                if (this.getMetadataRepository(this.vdb, p.getParent().getName()) != null) {
                    this.getMetadataRepository(this.vdb, p.getParent().getName()).setProcedureDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), p, sql);
                }
                DdlPlan.alterProcedureDefinition(this.vdb, p, sql, false);
                if (DdlPlan.this.pdm.getEventDistributor() != null) {
                    DdlPlan.this.pdm.getEventDistributor().setProcedureDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), p.getParent().getName(), p.getName(), sql);
                }
            }
        }

        @Override
        public void visit(AlterTrigger obj) {
            Table t = (Table)obj.getTarget().getMetadataID();
            String sql = null;
            Table.TriggerEvent event = obj.getEvent();
            if (obj.getEnabled() == null) {
                if (obj.isCreate()) {
                    if (DdlPlan.getPlanForEvent(t, event) != null) {
                        throw new TeiidRuntimeException((Throwable)new TeiidProcessingException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30156, new Object[]{t.getName(), obj.getEvent()})));
                    }
                } else if (DdlPlan.getPlanForEvent(t, event) == null) {
                    throw new TeiidRuntimeException((Throwable)new TeiidProcessingException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30158, new Object[]{t.getName(), obj.getEvent()})));
                }
                sql = ((TriggerAction)obj.getDefinition()).toString();
            } else if (DdlPlan.getPlanForEvent(t, event) == null) {
                throw new TeiidRuntimeException((Throwable)new TeiidProcessingException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30158, new Object[]{t.getName(), obj.getEvent()})));
            }
            if (this.processor != null && this.processor.vdbExists(this.vdb.getName(), this.vdb.getVersion())) {
                this.processor.processDDL(this.vdb.getName(), this.vdb.getVersion(), ((Schema)t.getParent()).getName(), obj.toString(), true, DdlPlan.this.getContext());
            } else {
                if (this.getMetadataRepository(this.vdb, ((Schema)t.getParent()).getName()) != null) {
                    if (sql != null) {
                        this.getMetadataRepository(this.vdb, ((Schema)t.getParent()).getName()).setInsteadOfTriggerDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), t, obj.getEvent(), sql);
                    } else {
                        this.getMetadataRepository(this.vdb, ((Schema)t.getParent()).getName()).setInsteadOfTriggerEnabled(this.workContext.getVdbName(), this.workContext.getVdbVersion(), t, obj.getEvent(), obj.getEnabled().booleanValue());
                    }
                }
                DdlPlan.alterInsteadOfTrigger(this.vdb, t, sql, obj.getEnabled(), event, false);
                if (DdlPlan.this.pdm.getEventDistributor() != null) {
                    DdlPlan.this.pdm.getEventDistributor().setInsteadOfTriggerDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), ((Schema)t.getParent()).getName(), t.getName(), obj.getEvent(), sql, obj.getEnabled());
                }
            }
        }
    }
}

