/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.Grant;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.metadata.Trigger;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.DDLProcessor;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.OptionsUtil;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.vdb.runtime.VDBKey;

public abstract class DatabaseStore
implements DDLProcessor {
    private ConcurrentHashMap<VDBKey, Database> databases = new ConcurrentHashMap();
    private Database currentDatabase;
    protected Schema currentSchema;
    private ReentrantLock lock = new ReentrantLock();
    protected int count;
    private boolean persist;
    private CommandContext commandContext;

    public abstract Map<String, Datatype> getRuntimeTypes();

    public abstract Map<String, Datatype> getBuiltinDataTypes();

    public abstract SystemFunctionManager getSystemFunctionManager();

    public void startEditing(boolean persist) {
        if (this.persist) {
            throw new AssertionError();
        }
        this.lock.lock();
        this.persist = persist;
    }

    public void stopEditing() throws MetadataException {
        this.currentDatabase = null;
        this.currentSchema = null;
        this.persist = false;
        this.lock.unlock();
    }

    public Schema getSchema(String schemaName) {
        this.verifyDatabaseExists();
        return this.currentDatabase.getSchema(schemaName);
    }

    public Server getServer(String serverName) {
        this.verifyDatabaseExists();
        return this.currentDatabase.getServer(serverName);
    }

    public void databaseCreated(Database db) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.DATABASE, (AbstractMetadataRecord)db);
        Database database = this.databases.get(this.vdbKey(db));
        if (database != null) {
            throw new DuplicateRecordException((BundleUtil.Event)QueryPlugin.Event.TEIID31232, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31232, new Object[]{db.getName()}));
        }
        if (this.currentDatabase != null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31242, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31242, new Object[0]));
        }
        this.databases.put(this.vdbKey(db), db);
    }

    private VDBKey vdbKey(Database db) {
        return new VDBKey(db.getName(), db.getVersion());
    }

    private void assertInEditMode() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31219, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31219, new Object[0]));
        }
    }

    public void databaseDropped(String dbName, String version) {
        this.assertInEditMode();
        Database db = this.databases.get(new VDBKey(dbName, version));
        if (db == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31231, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31231, new Object[]{dbName}));
        }
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.DATABASE, (AbstractMetadataRecord)db);
        this.databases.remove(new VDBKey(dbName, version));
        if (this.currentDatabase != null && this.currentDatabase.getName().equalsIgnoreCase(dbName)) {
            this.currentDatabase = null;
        }
    }

    public void databaseSwitched(String dbName, String version) {
        this.assertInEditMode();
        Database db = this.databases.get(new VDBKey(dbName, version));
        if (db == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31231, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31231, new Object[]{dbName, version}));
        }
        if (this.currentDatabase != null && !this.currentDatabase.equals((Object)db)) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31242, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31242, new Object[0]));
        }
        this.currentDatabase = db;
    }

    protected boolean shouldValidateDatabaseBeforeDeploy() {
        return true;
    }

    public void schemaCreated(Schema schema, List<String> serverNames) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.SCHEMA, (AbstractMetadataRecord)schema);
        this.verifyDatabaseExists();
        this.setUUID(this.currentDatabase.getName(), this.currentDatabase.getVersion(), schema);
        this.currentDatabase.addSchema(schema);
        if (schema.isPhysical()) {
            for (String serverName : serverNames) {
                Server server = this.verifyServerExists(serverName);
                schema.addServer(server);
            }
        } else if (!serverNames.isEmpty()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31236, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31236, new Object[]{schema.getName()}));
        }
    }

    public void schemaDropped(String schemaName) {
        this.assertInEditMode();
        this.verifySchemaExists(schemaName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.SCHEMA, (AbstractMetadataRecord)this.currentDatabase.getSchema(schemaName));
        this.currentDatabase.removeSchema(schemaName);
        if (this.currentSchema != null && this.currentSchema.getName().equalsIgnoreCase(schemaName)) {
            this.currentSchema = null;
        }
    }

    protected Table verifyTableExists(String tableName) {
        this.verifyDatabaseExists();
        Schema schema = this.getCurrentSchema();
        Table previous = schema.getTable(tableName);
        if (previous == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31237, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31237, new Object[]{tableName, this.currentDatabase.getName()}));
        }
        return previous;
    }

    protected Procedure verifyProcedureExists(String procedureName) {
        this.verifyDatabaseExists();
        Schema schema = this.getCurrentSchema();
        Procedure previous = schema.getProcedure(procedureName);
        if (previous == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31239, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31239, new Object[]{procedureName, this.currentDatabase.getName()}));
        }
        return previous;
    }

    protected FunctionMethod verifyFunctionExists(String functionName) {
        this.verifyDatabaseExists();
        Schema schema = this.getCurrentSchema();
        for (FunctionMethod fm : schema.getFunctions().values()) {
            if (!fm.getName().equalsIgnoreCase(functionName)) continue;
            return fm;
        }
        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31240, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31240, new Object[]{functionName, this.currentDatabase.getName()}));
    }

    protected Schema verifySchemaExists(String schemaName) {
        this.verifyDatabaseExists();
        Schema schema = this.currentDatabase.getSchema(schemaName);
        if (schema == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31234, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31234, new Object[]{schemaName, this.currentDatabase.getName()}));
        }
        return schema;
    }

    protected Server verifyServerExists(String serverName) {
        this.verifyDatabaseExists();
        Server server = this.currentDatabase.getServer(serverName);
        if (server == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31220, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31220, new Object[]{serverName, this.currentDatabase.getName()}));
        }
        return server;
    }

    protected void verifyDatabaseExists() {
        if (this.currentDatabase == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31233, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31233, new Object[0]));
        }
    }

    protected void verifyCurrentDatabaseIsNotSame(String dbName, String version) {
        if (this.currentDatabase == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31233, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31233, new Object[0]));
        }
        if (this.currentDatabase.getName().equalsIgnoreCase(dbName) && this.currentDatabase.getVersion().equalsIgnoreCase(version)) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31227, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31227, new Object[]{dbName, version}));
        }
    }

    public void schemaSwitched(String schemaName) {
        this.assertInEditMode();
        this.currentSchema = this.verifySchemaExists(schemaName);
    }

    public void dataWrapperCreated(DataWrapper wrapper) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.DATAWRAPPER, (AbstractMetadataRecord)wrapper);
        this.verifyDatabaseExists();
        this.currentDatabase.addDataWrapper(wrapper);
    }

    public void dataWrapperDropped(String wrapperName) {
        this.assertInEditMode();
        this.verifyDatabaseExists();
        this.verifyDataWrapperExists(wrapperName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.DATAWRAPPER, (AbstractMetadataRecord)this.currentDatabase.getDataWrapper(wrapperName));
        for (Server s : this.currentDatabase.getServers()) {
            if (!s.getDataWrapper().equalsIgnoreCase(wrapperName)) continue;
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31225, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31225, new Object[]{wrapperName, s.getName()}));
        }
        this.currentDatabase.removeDataWrapper(wrapperName);
    }

    public void serverCreated(Server server) {
        this.assertInEditMode();
        this.verifyDatabaseExists();
        this.verifyDataWrapperExists(server.getDataWrapper());
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.SERVER, (AbstractMetadataRecord)server);
        this.currentDatabase.addServer(server);
    }

    private boolean verifyDataWrapperExists(String dataWrapperName) {
        if (this.currentDatabase.getDataWrapper(dataWrapperName) == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31247, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31247, new Object[]{dataWrapperName}));
        }
        return true;
    }

    public void serverDropped(String serverName) {
        this.assertInEditMode();
        this.verifyDatabaseExists();
        this.verifyServerExists(serverName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.SERVER, (AbstractMetadataRecord)this.currentDatabase.getServer(serverName));
        for (Schema s : this.currentDatabase.getSchemas()) {
            for (Server server : s.getServers()) {
                if (!server.getName().equalsIgnoreCase(serverName)) continue;
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31224, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31224, new Object[]{serverName, s.getName()}));
            }
        }
        this.currentDatabase.removeServer(serverName);
    }

    protected Schema getCurrentSchema() {
        if (this.currentSchema == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31235, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31235, new Object[0]));
        }
        return this.currentSchema;
    }

    protected Database getCurrentDatabase() {
        if (this.currentDatabase == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31246, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31246, new Object[0]));
        }
        return this.currentDatabase;
    }

    public Database getDatabase(String dbName, String version) {
        VDBKey key = new VDBKey(dbName, version);
        return this.databases.get(key);
    }

    public List<Database> getDatabases() {
        return new ArrayList<Database>(this.databases.values());
    }

    public void tableCreated(Table table) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        Schema s = this.getCurrentSchema();
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)table);
        s.addTable(table);
    }

    public void setViewDefinition(String tableName, String definition, boolean updateFunctional) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)this.getCurrentSchema().getTable(tableName));
        this.verifyTableExists(tableName).setSelectTransformation(definition);
    }

    public void tableModified(Table table) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        this.verifyTableExists(table.getName());
    }

    public void tableDropped(String tableName) {
        this.assertInEditMode();
        this.verifyTableExists(tableName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.TABLE, (AbstractMetadataRecord)this.getCurrentSchema().getTable(tableName));
        Schema s = this.getCurrentSchema();
        s.removeTable(tableName);
    }

    public void procedureCreated(Procedure procedure) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)procedure);
        Schema s = this.getCurrentSchema();
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)procedure);
        for (ProcedureParameter param : procedure.getParameters()) {
            this.setUUID(s.getUUID(), (AbstractMetadataRecord)param);
        }
        if (procedure.getResultSet() != null) {
            this.setUUID(s.getUUID(), (AbstractMetadataRecord)procedure.getResultSet());
        }
        s.addProcedure(procedure);
    }

    public void setProcedureDefinition(String procedureName, String definition, boolean updateFunctional) {
        this.assertInEditMode();
        Procedure procedure = this.verifyProcedureExists(procedureName);
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)procedure);
        procedure.setQueryPlan(definition);
    }

    public void procedureModified(Procedure procedure) {
        this.assertInEditMode();
        this.verifyProcedureExists(procedure.getName());
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)procedure);
    }

    public void procedureDropped(String procedureName) {
        this.assertInEditMode();
        this.verifyProcedureExists(procedureName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.PROCEDURE, (AbstractMetadataRecord)this.getCurrentSchema().getProcedure(procedureName));
        Schema s = this.getCurrentSchema();
        s.removeProcedure(procedureName);
    }

    public void functionCreated(FunctionMethod function) {
        this.assertInEditMode();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.FUNCTION, (AbstractMetadataRecord)function);
        Schema s = this.getCurrentSchema();
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)function);
        for (FunctionParameter param : function.getInputParameters()) {
            this.setUUID(s.getUUID(), (AbstractMetadataRecord)param);
        }
        this.setUUID(s.getUUID(), (AbstractMetadataRecord)function.getOutputParameter());
        s.addFunction(function);
    }

    public void functionDropped(String functionName) {
        this.assertInEditMode();
        FunctionMethod fm = this.verifyFunctionExists(functionName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.FUNCTION, (AbstractMetadataRecord)fm);
        Schema s = this.getCurrentSchema();
        s.removeFunctions(functionName);
    }

    public void setTableTriggerPlan(String triggerName, String tableName, Table.TriggerEvent event, String triggerDefinition, boolean isAfter) {
        this.assertInEditMode();
        Table table = this.getCurrentSchema().getTable(tableName);
        if (table == null) {
            throw new MetadataException(QueryPlugin.Util.getString("SQLParser.group_doesnot_exist", new Object[]{tableName}));
        }
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        if (!table.isVirtual()) {
            if (!isAfter) {
                throw new MetadataException(QueryPlugin.Util.getString("SQLParser.not_view", new Object[]{tableName}));
            }
            if (triggerName == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31213, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31213, new Object[0]));
            }
            if (table.getTriggers().containsKey(triggerName)) {
                throw new DuplicateRecordException((BundleUtil.Event)QueryPlugin.Event.TEIID31212, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31212, new Object[]{triggerName, table.getFullName()}));
            }
            Trigger t = new Trigger();
            t.setName(triggerName);
            t.setEvent(event);
            t.setPlan(triggerDefinition);
            table.getTriggers().put(triggerName, t);
            return;
        }
        if (isAfter) {
            throw new MetadataException(QueryPlugin.Util.getString("SQLParser.view_not_allowed", new Object[]{tableName}));
        }
        if (event.equals((Object)Table.TriggerEvent.INSERT)) {
            table.setInsertPlan(triggerDefinition);
        } else if (event.equals((Object)Table.TriggerEvent.UPDATE)) {
            table.setUpdatePlan(triggerDefinition);
        } else if (event.equals((Object)Table.TriggerEvent.DELETE)) {
            table.setDeletePlan(triggerDefinition);
        }
    }

    public void enableTableTriggerPlan(String tableName, Table.TriggerEvent event, boolean enable, boolean updateFunctional) {
        this.assertInEditMode();
        Table table = this.getCurrentSchema().getTable(tableName);
        if (table == null || !table.isVirtual()) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31244, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31244, new Object[]{tableName}));
        }
        this.assertGrant(Grant.Permission.Privilege.ALTER, Database.ResourceType.TABLE, (AbstractMetadataRecord)table);
        switch (event) {
            case DELETE: {
                table.setDeletePlanEnabled(enable);
                break;
            }
            case INSERT: {
                table.setInsertPlanEnabled(enable);
                break;
            }
            case UPDATE: {
                table.setUpdatePlanEnabled(enable);
                break;
            }
        }
    }

    public void createNameSpace(String prefix, String uri) {
        this.assertInEditMode();
        this.getCurrentDatabase().addNamespace(prefix, uri);
    }

    public Map<String, String> getNameSpaces() {
        return this.getCurrentDatabase().getNamespaces();
    }

    public void addOrSetOption(String recordName, Database.ResourceType type, String key, String value, boolean reload) {
        this.assertInEditMode();
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        record.setProperty(key, value);
        OptionsUtil.setOptions(record);
    }

    public AbstractMetadataRecord getSchemaRecord(String name, Database.ResourceType type) {
        TransformationMetadata qmi = new TransformationMetadata(this.getCurrentDatabase(), this.getSystemFunctionManager());
        try {
            switch (type) {
                case TABLE: {
                    GroupSymbol gs = new GroupSymbol(name);
                    ResolverUtil.resolveGroup(gs, qmi);
                    Table t = (Table)gs.getMetadataID();
                    if (t == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31245, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31245, new Object[]{name, this.getCurrentDatabase().getName(), this.getCurrentSchema().getName()}));
                    }
                    return t;
                }
                case PROCEDURE: {
                    StoredProcedureInfo sp = qmi.getStoredProcedureInfoForProcedure(name);
                    if (sp == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31213, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31213, new Object[]{name, this.getCurrentSchema().getName(), this.getCurrentDatabase().getName()}));
                    }
                    if (sp.getProcedureID() instanceof Procedure) {
                        return (Procedure)sp.getProcedureID();
                    }
                    return null;
                }
                case COLUMN: {
                    Column c = qmi.getElementID(name);
                    if (c != null) break;
                    throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31223, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31223, new Object[]{name}));
                }
                case DATABASE: {
                    Database db = this.getCurrentDatabase();
                    if (db == null || !db.getName().equals(name)) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31231, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31231, new Object[]{name}));
                    }
                    return db;
                }
                case SCHEMA: {
                    Schema schema = qmi.getModelID(name);
                    if (schema == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31234, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31234, new Object[]{name, this.getCurrentDatabase().getName()}));
                    }
                    return schema;
                }
                case SERVER: {
                    Server server = this.getCurrentDatabase().getServer(name);
                    if (server == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31220, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31220, new Object[]{name, this.getCurrentDatabase().getName()}));
                    }
                    return server;
                }
                case DATAWRAPPER: {
                    DataWrapper dw = this.getCurrentDatabase().getDataWrapper(name);
                    if (dw == null) {
                        throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31247, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31247, new Object[]{name, this.getCurrentDatabase().getName()}));
                    }
                    return dw;
                }
            }
        }
        catch (TeiidComponentException e) {
            throw new MetadataException((Throwable)e);
        }
        catch (QueryResolverException e) {
            throw new MetadataException((Throwable)((Object)e));
        }
        return null;
    }

    public void removeOption(String recordName, Database.ResourceType type, String key) {
        this.assertInEditMode();
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        OptionsUtil.removeOption(record, key);
    }

    public void addOrSetOption(String recordName, Database.ResourceType type, String childName, Database.ResourceType childType, String key, String value, boolean reload) {
        this.assertInEditMode();
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        if (record instanceof Table) {
            Column c = ((Table)record).getColumnByName(childName);
            if (c == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31248, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31248, new Object[]{childName, recordName}));
            }
            c.setProperty(key, value);
            OptionsUtil.setOptions((AbstractMetadataRecord)c);
        } else if (record instanceof Procedure) {
            ProcedureParameter p = ((Procedure)record).getParameterByName(childName);
            if (p == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31249, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31249, new Object[]{childName, recordName}));
            }
            p.setProperty(key, value);
            OptionsUtil.setOptions((AbstractMetadataRecord)p);
        }
    }

    public void removeOption(String recordName, Database.ResourceType type, String childName, Database.ResourceType childType, String key) {
        this.assertInEditMode();
        key = this.getCurrentDatabase().resolveNamespaceInPropertyKey(key);
        AbstractMetadataRecord record = this.getSchemaRecord(recordName, type);
        if (record instanceof Table) {
            Column c = ((Table)record).getColumnByName(childName);
            if (c == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31248, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31248, new Object[]{childName, recordName}));
            }
            OptionsUtil.removeOption((AbstractMetadataRecord)c, key);
        } else if (record instanceof Procedure) {
            ProcedureParameter p = ((Procedure)record).getParameterByName(childName);
            if (p == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31249, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31249, new Object[]{childName, recordName}));
            }
            OptionsUtil.removeOption((AbstractMetadataRecord)p, key);
        }
    }

    public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
        throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31221, new Object[0]));
    }

    public void importDatabase(String dbName, String version, boolean importPolicies) {
        throw new MetadataException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31226, new Object[0]));
    }

    protected Role verifyRoleExists(String roleName) {
        this.verifyDatabaseExists();
        Role role = this.currentDatabase.getRole(roleName);
        if (role == null) {
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31222, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31222, new Object[]{roleName, this.currentDatabase.getName()}));
        }
        return role;
    }

    public void roleCreated(Role role) {
        this.assertInEditMode();
        this.verifyDatabaseExists();
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.ROLE, (AbstractMetadataRecord)role);
        this.currentDatabase.addRole(role);
    }

    public void roleDropped(String roleName) {
        this.assertInEditMode();
        Role role = this.verifyRoleExists(roleName);
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.ROLE, (AbstractMetadataRecord)role);
        this.currentDatabase.removeRole(roleName);
    }

    public void grantCreated(Grant grant) {
        this.assertInEditMode();
        this.verifyDatabaseExists();
        this.verifyRoleExists(grant.getRole());
        this.assertGrant(Grant.Permission.Privilege.CREATE, Database.ResourceType.GRANT, (AbstractMetadataRecord)grant);
        for (Grant.Permission p : grant.getPermissions()) {
            AbstractMetadataRecord record = this.getSchemaRecord(p.getResourceName(), p.getResourceType());
            p.setResourceName(record.getFullName());
        }
        this.currentDatabase.addGrant(grant);
    }

    public void grantRevoked(Grant grant) {
        this.assertInEditMode();
        this.verifyDatabaseExists();
        this.verifyRoleExists(grant.getRole());
        this.assertGrant(Grant.Permission.Privilege.DROP, Database.ResourceType.GRANT, (AbstractMetadataRecord)grant);
        for (Grant.Permission p : grant.getPermissions()) {
            AbstractMetadataRecord record = this.getSchemaRecord(p.getResourceName(), p.getResourceType());
            p.setResourceName(record.getFullName());
        }
        this.currentDatabase.revokeGrant(grant);
    }

    public static MetadataFactory createMF(DatabaseStore events) {
        MetadataFactory mf = new MetadataFactory(events.getCurrentDatabase().getName(), (Object)events.getCurrentDatabase().getVersion(), events.getCurrentSchema().getName(), events.getRuntimeTypes(), new Properties(), null);
        Map<String, String> nss = events.getNameSpaces();
        for (String key : nss.keySet()) {
            mf.addNamespace(key, nss.get(key));
        }
        return mf;
    }

    private void setUUID(String prefix, AbstractMetadataRecord record) {
        if (record.getUUID() != null && !record.getUUID().startsWith("tid:")) {
            return;
        }
        int lsb = 0;
        if (record.getParent() != null) {
            lsb = record.getParent().getUUID().hashCode();
        }
        lsb = 31 * lsb + record.getName().hashCode();
        String uuid = prefix + "-" + MetadataFactory.hex((long)lsb, (int)8) + "-" + MetadataFactory.hex((long)this.count++, (int)8);
        record.setUUID(uuid);
    }

    private long longHash(String s, long h) {
        if (s == null) {
            return h;
        }
        for (int i = 0; i < s.length(); ++i) {
            h = 31L * h + (long)s.charAt(i);
        }
        return h;
    }

    private void setUUID(String vdbName, String vdbVersion, Schema schema) {
        long msb = this.longHash(vdbName, 0L);
        try {
            int val = Integer.parseInt(vdbVersion);
            msb = 31L * msb + (long)val;
        }
        catch (NumberFormatException e) {
            msb = 31L * msb + (long)this.currentDatabase.getVersion().hashCode();
        }
        msb = this.longHash(schema.getName(), msb);
        schema.setUUID("tid:" + MetadataFactory.hex((long)msb, (int)12));
    }

    @Override
    public boolean vdbExists(String dbName, String version) {
        return this.getDatabase(dbName, version) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String processDDL(String dbName, String version, String schema, String ddl, boolean persist, CommandContext commandContext) throws MetadataException {
        StringBuilder sb = new StringBuilder();
        this.startEditing(persist);
        try {
            this.commandContext = commandContext;
            QueryParser parser = QueryParser.getQueryParser();
            if (dbName != null) {
                String str = "USE DATABASE " + SQLStringVisitor.escapeSinglePart(dbName) + " VERSION " + new Constant(version);
                sb.append(str);
                DatabaseStore.logNParse(parser, this, str);
                if (schema != null) {
                    str = "SET SCHEMA " + SQLStringVisitor.escapeSinglePart(schema);
                    sb.append(";");
                    sb.append(str);
                    DatabaseStore.logNParse(parser, this, str);
                }
            }
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(ddl);
            DatabaseStore.logNParse(parser, this, ddl);
            String string = sb.toString();
            return string;
        }
        finally {
            this.commandContext = null;
            this.stopEditing();
        }
    }

    private static void logNParse(QueryParser parser, DatabaseStore store, String sql) {
        LogManager.logDetail((String)"org.teiid.METASTORE", (Object)"DDL: ", (Object)sql);
        parser.parseDDL(store, (Reader)new StringReader(sql));
    }

    private void assertGrant(Grant.Permission.Privilege allowence, Database.ResourceType type, AbstractMetadataRecord record) {
    }
}

