/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.source.SystemSource;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestFunctionTree {
    @Test
    public void testWalkTree() {
        SystemSource source = new SystemSource(false);
        FunctionTree ft = new FunctionTree("foo", (FunctionMetadataSource)source);
        Collection categories = ft.getCategories();
        for (String category : categories) {
            Assert.assertTrue((ft.getFunctionsInCategory(category).size() > 0 ? 1 : 0) != 0);
        }
    }

    public String z() {
        return null;
    }

    protected static String x() {
        return null;
    }

    public static String y() {
        return null;
    }

    public static String toString(byte[] bytes) {
        return new String(bytes);
    }

    @Test
    public void testLoadErrors() {
        FunctionMethod method = new FunctionMethod("dummy", null, null, FunctionMethod.PushDown.CAN_PUSHDOWN, null, "noMethod", new ArrayList(0), new FunctionParameter("output", "string"), false, FunctionMethod.Determinism.DETERMINISTIC);
        new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)))});
        try {
            new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
            Assert.fail();
        }
        catch (TeiidRuntimeException e) {
            Assert.assertEquals((Object)"TEIID31123 Could not load non-FOREIGN UDF \"dummy\", since both invocation class and invocation method are required.", (Object)e.getMessage());
        }
        method.setInvocationClass("nonexistantClass");
        try {
            new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
            Assert.fail();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        method.setInvocationClass(TestFunctionTree.class.getName());
        try {
            new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
            Assert.fail();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        method.setInvocationMethod("testLoadErrors");
        try {
            new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
            Assert.fail();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        method.setInvocationMethod("x");
        try {
            new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
            Assert.fail();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        method.setInvocationMethod("z");
        try {
            new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
            Assert.fail();
        }
        catch (TeiidRuntimeException teiidRuntimeException) {
            // empty catch block
        }
        method.setInvocationMethod("y");
        new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
    }

    @Test
    public void testNullCategory() {
        FunctionMethod method = new FunctionMethod("dummy", null, null, FunctionMethod.PushDown.MUST_PUSHDOWN, "nonexistentClass", "noMethod", new ArrayList(0), new FunctionParameter("output", "string"), false, FunctionMethod.Determinism.DETERMINISTIC);
        List<FunctionMethod> list = Arrays.asList(method);
        FunctionMetadataSource fms = (FunctionMetadataSource)Mockito.mock(FunctionMetadataSource.class);
        Mockito.stub((Object)fms.getFunctionMethods()).toReturn(list);
        FunctionTree ft = new FunctionTree("foo", fms);
        Assert.assertEquals((long)1L, (long)ft.getFunctionsInCategory("Miscellaneous").size());
    }

    @Test
    public void testVarbinary() throws Exception {
        FunctionMethod method = new FunctionMethod("dummy", null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestFunctionTree.class.getName(), "toString", Arrays.asList(new FunctionParameter("in", "varbinary")), new FunctionParameter("output", "string"), true, FunctionMethod.Determinism.DETERMINISTIC);
        FunctionTree sys = RealMetadataFactory.SFM.getSystemFunctions();
        FunctionLibrary fl = new FunctionLibrary(sys, new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
        FunctionDescriptor fd = fl.findFunction("dummy", new Class[]{DataTypeManager.DefaultDataClasses.VARBINARY});
        String hello = "hello";
        Assert.assertEquals((Object)hello, (Object)fd.invokeFunction(new Object[]{new BinaryType(hello.getBytes())}, null, null));
    }

    @Test
    public void testMultiPartName() throws Exception {
        FunctionMethod method = new FunctionMethod("x.y.dummy", null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestFunctionTree.class.getName(), "toString", Arrays.asList(new FunctionParameter("in", "varbinary")), new FunctionParameter("output", "string"), true, FunctionMethod.Determinism.DETERMINISTIC);
        FunctionTree sys = RealMetadataFactory.SFM.getSystemFunctions();
        FunctionLibrary fl = new FunctionLibrary(sys, new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
        Assert.assertNotNull((Object)fl.findFunction("dummy", new Class[]{DataTypeManager.DefaultDataClasses.VARBINARY}));
        Assert.assertNotNull((Object)fl.findFunction("y.dummy", new Class[]{DataTypeManager.DefaultDataClasses.VARBINARY}));
    }

    @Test
    public void testMultiPartNameSystemConflict() throws Exception {
        FunctionMethod method = new FunctionMethod("x.concat", null, null, FunctionMethod.PushDown.MUST_PUSHDOWN, null, null, Arrays.asList(new FunctionParameter("in", "string"), new FunctionParameter("in", "string")), new FunctionParameter("output", "string"), true, FunctionMethod.Determinism.DETERMINISTIC);
        FunctionTree sys = RealMetadataFactory.SFM.getSystemFunctions();
        FunctionLibrary fl = new FunctionLibrary(sys, new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource(Arrays.asList(method)), true)});
        fl.determineNecessaryConversions("concat", DataTypeManager.DefaultDataClasses.STRING, new Expression[]{new Constant((Object)1), new Constant((Object)2)}, new Class[]{DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.INTEGER}, false);
    }
}

