/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingException;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingOutputter;
import org.teiid.query.mapping.xml.MappingRecursiveElement;

public class TestMappingOutputter
extends TestCase {
    private MappingDocument loadMappingDocument(String xml) throws MappingException {
        MappingLoader reader = new MappingLoader();
        byte[] bytes = xml.getBytes();
        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
        return reader.loadDocument((InputStream)istream);
    }

    private String saveMappingDocument(MappingDocument doc) throws IOException {
        StringWriter sw = new StringWriter();
        MappingOutputter out = new MappingOutputter();
        out.write(doc, new PrintWriter(sw));
        return sw.toString();
    }

    public void testSourceAtRoot() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>true</formattedDocument><mappingNode><name>license</name><minOccurs>0</minOccurs><maxOccurs>-1</maxOccurs><source>licenseSource</source><tempGroup>testTempGroup1</tempGroup><tempGroup>testTempGroup2</tempGroup></mappingNode></xmlMapping>";
        ArrayList<String> stagingTables = new ArrayList<String>();
        stagingTables.add("testTempGroup1");
        stagingTables.add("testTempGroup2");
        MappingDocument doc = new MappingDocument("UTF-8", true);
        MappingElement element = doc.addChildElement(new MappingElement("license"));
        element.setStagingTables(stagingTables);
        element.setSource("licenseSource");
        element.setMinOccurrs(0);
        element.setMaxOccurrs(-1);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testSourceBelowRoot() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>true</formattedDocument><mappingNode><name>parentNode</name><minOccurs>0</minOccurs><maxOccurs>-1</maxOccurs><tempGroup>testTempGroup1</tempGroup><tempGroup>testTempGroup2</tempGroup><mappingNode><name>childNode</name><source>childNodeSource</source></mappingNode></mappingNode></xmlMapping>";
        ArrayList<String> stagingTables = new ArrayList<String>();
        stagingTables.add("testTempGroup1");
        stagingTables.add("testTempGroup2");
        MappingDocument doc = new MappingDocument("UTF-8", true);
        MappingElement element = doc.addChildElement(new MappingElement("parentNode"));
        element.setMinOccurrs(0);
        element.setMaxOccurrs(-1);
        element.setStagingTables(stagingTables);
        MappingElement child = element.addChildElement(new MappingElement("childNode"));
        child.setSource("childNodeSource");
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testCriteria() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><name>parentNode</name><mappingNode><nodeType>choice</nodeType><exceptionOnDefault>true</exceptionOnDefault><mappingNode><nodeType>criteria</nodeType><criteria>childNodeCriteria</criteria><mappingNode><name>childNode</name></mappingNode></mappingNode></mappingNode></mappingNode></xmlMapping>";
        MappingDocument doc = new MappingDocument(false);
        MappingElement element = doc.addChildElement(new MappingElement("parentNode"));
        MappingChoiceNode choice = element.addChoiceNode(new MappingChoiceNode(true));
        MappingCriteriaNode criteria = choice.addCriteriaNode(new MappingCriteriaNode("childNodeCriteria", false));
        criteria.addChildElement(new MappingElement("childNode"));
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testElement() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><name>parentNode</name><default>ddd</default><fixed>fff</fixed><optional>true</optional><isNillable>true</isNillable><isExcluded>true</isExcluded><textNormalization>replace</textNormalization><builtInType>decimal</builtInType></mappingNode></xmlMapping>";
        MappingDocument doc = new MappingDocument(false);
        MappingElement element = doc.addChildElement(new MappingElement("parentNode"));
        element.setNillable(true);
        element.setExclude(true);
        element.setDefaultValue("ddd");
        element.setValue("fff");
        element.setOptional(true);
        element.setNormalizeText("replace");
        element.setType("decimal");
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testRecursiveNode() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><name>parentNode</name><source>parentNodeSource</source><mappingNode><name>childNode</name><mappingNode><name>attributename</name><nodeType>attribute</nodeType><default>ddd</default><fixed>fff</fixed></mappingNode><mappingNode><name>recursivenodename</name><isRecursive>true</isRecursive><recursionCriteria>rrr</recursionCriteria><recursionLimit>8</recursionLimit><recursionRootMappingClass>parentNodeSource</recursionRootMappingClass></mappingNode></mappingNode></mappingNode></xmlMapping>";
        MappingDocument doc = new MappingDocument(false);
        MappingElement parentNode = doc.addChildElement(new MappingElement("parentNode"));
        parentNode.setSource("parentNodeSource");
        MappingElement childNode = parentNode.addChildElement(new MappingElement("childNode"));
        MappingAttribute attribute = new MappingAttribute("attributename");
        childNode.addAttribute(attribute);
        attribute.setDefaultValue("ddd");
        attribute.setValue("fff");
        MappingRecursiveElement recursiveElement = (MappingRecursiveElement)childNode.addChildElement((MappingElement)new MappingRecursiveElement("recursivenodename", "parentNodeSource"));
        recursiveElement.setRecursionLimit(8, false);
        recursiveElement.setCriteria("rrr");
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testMoveNamespaceDeclaration() throws Exception {
        String actual = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n        <mappingNode>\r\n            <name>xsi</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>xmlns</namespace>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><prefix>xsi</prefix><uri>http://some.uri/</uri></namespaceDeclaration><name>parentNode</name><includeAlways>false</includeAlways></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(actual);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testMoveNamespaceDeclaration2() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><prefix>xsi</prefix><uri>http://some.uri/</uri></namespaceDeclaration><name>parentNode</name><includeAlways>false</includeAlways></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(expected);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testMoveDefaultNamespaceDeclaration() throws Exception {
        String actual = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>xmlns</name>\r\n            <nodeType>attribute</nodeType>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><uri>http://some.uri/</uri></namespaceDeclaration><name>license</name><includeAlways>false</includeAlways></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(actual);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testMoveDefaultNamespaceDeclaration2() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><uri>http://some.uri/</uri></namespaceDeclaration><name>license</name><includeAlways>false</includeAlways></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(expected);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testMoveNamespaceDeclarations() throws Exception {
        String actual = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>xsi</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>xmlns</namespace>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n        <mappingNode>\r\n            <name>xmlns</name>\r\n            <nodeType>attribute</nodeType>\r\n            <fixed>http://some.uri2/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><prefix>xsi</prefix><uri>http://some.uri/</uri></namespaceDeclaration><namespaceDeclaration><uri>http://some.uri2/</uri></namespaceDeclaration><name>license</name><includeAlways>false</includeAlways></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(actual);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testMoveNamespaceDeclarations2() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><prefix>xsi</prefix><uri>http://some.uri/</uri></namespaceDeclaration><namespaceDeclaration><uri>http://some.uri2/</uri></namespaceDeclaration><name>license</name><includeAlways>false</includeAlways></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(expected);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testUseNamespaceBeforeDeclaration() throws Exception {
        String actual = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <mappingNode>\r\n            <name>usenamespace</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>foo</namespace>\r\n        </mappingNode>\r\n        <mappingNode>\r\n            <name>foo</name>\r\n            <nodeType>attribute</nodeType>\r\n            <namespace>xmlns</namespace>\r\n            <fixed>http://some.uri/</fixed>\r\n        </mappingNode>\r\n        <mappingNode>\r\n            <name>xmlns</name>\r\n            <nodeType>attribute</nodeType>\r\n            <fixed>http://some.uri2/</fixed>\r\n        </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><namespaceDeclaration><prefix>foo</prefix><uri>http://some.uri/</uri></namespaceDeclaration><namespaceDeclaration><uri>http://some.uri2/</uri></namespaceDeclaration><name>license</name><includeAlways>false</includeAlways><mappingNode><name>usenamespace</name><nodeType>attribute</nodeType><namespace>foo</namespace><includeAlways>false</includeAlways></mappingNode></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(actual);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }

    public void testRecursive() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>false</formattedDocument><mappingNode><name>parentNode</name><source>parentSource</source><includeAlways>false</includeAlways><mappingNode><name>childNode</name><source>childSource</source><isRecursive>true</isRecursive><recursionCriteria>foo</recursionCriteria><recursionLimit>6</recursionLimit><recursionRootMappingClass>parentSource</recursionRootMappingClass><includeAlways>false</includeAlways></mappingNode></mappingNode></xmlMapping>";
        MappingDocument doc = this.loadMappingDocument(expected);
        String savedXML = this.saveMappingDocument(doc);
        TestMappingOutputter.assertEquals((String)expected, (String)savedXML);
    }
}

