/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;

public class TempMetadataStore
implements Serializable {
    private static final long serialVersionUID = 4055072385672022478L;
    private NavigableMap<String, TempMetadataID> tempGroups;

    public TempMetadataStore() {
        this(new TreeMap<String, TempMetadataID>(String.CASE_INSENSITIVE_ORDER));
    }

    public TempMetadataStore(NavigableMap<String, TempMetadataID> data) {
        this.tempGroups = data == null ? new TreeMap<String, TempMetadataID>(String.CASE_INSENSITIVE_ORDER) : data;
    }

    public TempMetadataStore clone() {
        TreeMap<String, TempMetadataID> clone = new TreeMap<String, TempMetadataID>(String.CASE_INSENSITIVE_ORDER);
        clone.putAll(this.tempGroups);
        return new TempMetadataStore(clone);
    }

    public NavigableMap<String, TempMetadataID> getData() {
        return this.tempGroups;
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols) {
        return this.addTempGroup(tempGroup, tempSymbols, true);
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols, boolean isVirtual) {
        return this.addTempGroup(tempGroup, tempSymbols, isVirtual, false);
    }

    public TempMetadataID addTempGroup(String tempGroup, List<? extends Expression> tempSymbols, boolean isVirtual, boolean isTempTable) {
        ArrayList<TempMetadataID> elementIDs = new ArrayList<TempMetadataID>(tempSymbols.size());
        for (Expression expression : tempSymbols) {
            TempMetadataID elementID = this.createElementSymbol(tempGroup, expression, isTempTable);
            elementIDs.add(elementID);
        }
        TempMetadataID groupID = new TempMetadataID(tempGroup, elementIDs, isVirtual ? TempMetadataID.Type.VIRTUAL : TempMetadataID.Type.TEMP);
        this.tempGroups.put(tempGroup, groupID);
        return groupID;
    }

    private TempMetadataID createElementSymbol(String tempName, Expression symbol, boolean isTempTable) {
        String elementName = tempName + "." + Symbol.getShortName(symbol);
        Object metadataID = null;
        if (symbol instanceof AliasSymbol) {
            AliasSymbol as = (AliasSymbol)symbol;
            symbol = as.getSymbol();
        }
        if (symbol instanceof ExpressionSymbol) {
            Expression expr = ((ExpressionSymbol)symbol).getExpression();
            if (expr instanceof Reference) {
                expr = ((Reference)expr).getExpression();
            }
            if (expr instanceof ElementSymbol) {
                symbol = expr;
            }
        }
        if (symbol instanceof ElementSymbol) {
            metadataID = ((ElementSymbol)symbol).getMetadataID();
        }
        while (metadataID != null && metadataID instanceof TempMetadataID) {
            metadataID = ((TempMetadataID)metadataID).getOriginalMetadataID();
        }
        TempMetadataID elementID = new TempMetadataID(elementName, symbol.getType(), metadataID);
        elementID.setTempTable(isTempTable);
        return elementID;
    }

    public TempMetadataID addElementSymbolToTempGroup(String tempGroup, Expression symbol) {
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(tempGroup);
        if (groupID != null) {
            TempMetadataID elementID = this.createElementSymbol(tempGroup, symbol, false);
            groupID.addElement(elementID);
            return elementID;
        }
        return null;
    }

    public TempMetadataID getTempGroupID(String tempGroup) {
        return (TempMetadataID)this.tempGroups.get(tempGroup);
    }

    public TempMetadataID getTempElementID(String tempElement) {
        int index = tempElement.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        String groupName = tempElement.substring(0, index);
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(groupName);
        if (groupID != null) {
            for (TempMetadataID elementID : groupID.getElements()) {
                if (!elementID.getID().equalsIgnoreCase(tempElement)) continue;
                return elementID;
            }
        }
        return null;
    }

    public List<TempMetadataID> getTempElementElementIDs(String tempGroup) {
        TempMetadataID groupID = this.getTempGroupID(tempGroup);
        if (groupID != null) {
            return groupID.getElements();
        }
        return null;
    }

    public void addElementToTempGroup(String tempGroup, ElementSymbol symbol) {
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(tempGroup);
        if (groupID != null) {
            groupID.addElement((TempMetadataID)symbol.getMetadataID());
        }
    }

    public TempMetadataID removeTempGroup(String tempGroup) {
        return (TempMetadataID)this.tempGroups.remove(tempGroup);
    }
}

