/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import junit.framework.TestCase;
import org.teiid.core.util.EquivalenceUtil;

public class TestEquivalenceUtil
extends TestCase {
    public TestEquivalenceUtil(String name) {
        super(name);
    }

    public void testAreEqual() {
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual(null, null));
        Integer obj1 = new Integer(1000);
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEqual((Object)obj1, null));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEqual(null, (Object)obj1));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj1));
        Object obj2 = new Integer(1000);
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj2));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj2, (Object)obj1));
        obj2 = "1000";
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj2));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEqual((Object)obj2, (Object)obj1));
        obj2 = new Integer(1000);
        Integer obj3 = new Integer(1000);
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj2));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj2, (Object)obj3));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEqual((Object)obj1, (Object)obj3));
    }

    public void testAreEquivalent() {
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEquivalent(null, null));
        Object[] array1 = new Object[]{};
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEquivalent((Object[])array1, null));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEquivalent(null, (Object[])array1));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array1));
        Object[] array2 = new Integer[]{};
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array2));
        array1 = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
        array2 = new Object[]{new Integer(1), new Integer(2), new Integer(3)};
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array2));
        array2 = new Object[]{new Integer(1), new Integer(2), new Integer(3), null};
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areEquivalent((Object[])array1, (Object[])array2));
    }

    public void testAreStrictlyEquivalentObjectObject() {
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, null));
        Integer obj1 = new Integer(1000);
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj1, (Object)obj1));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj1, null));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, (Object)obj1));
        Integer obj2 = new Integer(1000);
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj1, (Object)obj2));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object)obj2, (Object)obj1));
    }

    public void testAreStrictlyEquivalentObjectArrayObjectArray() {
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])null, (Object[])null));
        Object[] array1 = new Object[]{};
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array1));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, null));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent(null, (Object[])array1));
        Object[] array2 = new String[2];
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, null));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent(null, (Object[])array2));
        array2 = new Integer[]{};
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
        array1 = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
        array2 = new Object[]{new Integer(1), new Integer(2), new Integer(3), null};
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
        array2 = new Object[array1.length];
        System.arraycopy(array1, 0, array2, 0, array1.length);
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        TestEquivalenceUtil.assertFalse((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
        array2 = new Object[]{new Integer(1), new Integer(2), new Integer(3)};
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array1, (Object[])array2));
        TestEquivalenceUtil.assertTrue((boolean)EquivalenceUtil.areStrictlyEquivalent((Object[])array2, (Object[])array1));
    }
}

