/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.translator.TranslatorException;

public class TestPGMetadata
extends AbstractMMQueryTestCase {
    static FakeServer server = null;

    @BeforeClass
    public static void setup() {
        server = new FakeServer(true);
    }

    @AfterClass
    public static void teardown() {
        server.stop();
    }

    private static VDBMetaData buildVDB(String name) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName(name);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.addSourceMetadata("DDL", "create view v as select 1");
        mmd.setModelType(Model.Type.VIRTUAL);
        vdb.addModel(mmd);
        return vdb;
    }

    @Test
    public void test_PG_MetadataOFF() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("x");
        vdb.addProperty("include-pg-metadata", "false");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:x");
        try {
            this.execute("select * FROM pg_am");
            Assert.fail((String)"there should be no PG metadata");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test_PG_Metadata_ON() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("y");
        vdb.addProperty("include-pg-metadata", "true");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:y");
        try {
            this.execute("select * FROM pg_am");
        }
        catch (Exception e) {
            Assert.fail((String)"there should be PG metadata");
        }
    }

    @Test
    public void test_PG_Metadata_DEFAULT() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("z");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:z");
        try {
            this.execute("select * FROM pg_am");
        }
        catch (Exception e) {
            Assert.fail((String)"there should be PG metadata");
        }
    }
}

