/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.Column;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.RuleChooseDependent;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestDependentJoins {
    static void checkDependentGroups(ProcessorPlan plan, String[] groups) {
        if (!(plan instanceof RelationalPlan)) {
            return;
        }
        HashSet<String> depGroups = new HashSet<String>();
        TestDependentJoins.getDependentGroups(((RelationalPlan)plan).getRootNode(), depGroups, true);
        HashSet<String> expectedGroups = new HashSet<String>();
        for (int i = 0; i < groups.length; ++i) {
            expectedGroups.add(groups[i].toUpperCase());
        }
        Assert.assertEquals((String)"Expected groups were not made dependent", expectedGroups, depGroups);
    }

    static void getDependentGroups(RelationalNode node, Set<String> depGroups, boolean depdenent) {
        if (node instanceof AccessNode) {
            if (node instanceof DependentAccessNode ? !depdenent : depdenent) {
                return;
            }
            AccessNode accessNode = (AccessNode)node;
            Command depCommand = accessNode.getCommand();
            Collection groupSymbols = GroupCollectorVisitor.getGroups((LanguageObject)depCommand, (boolean)true);
            for (GroupSymbol groupSymbol : groupSymbols) {
                depGroups.add(groupSymbol.getNonCorrelationName().toUpperCase());
            }
        }
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == null) continue;
            TestDependentJoins.getDependentGroups(node.getChildren()[i], depGroups, depdenent);
        }
    }

    private void checkNotDependentGroups(ProcessorPlan plan, String[] groups) {
        if (!(plan instanceof RelationalPlan)) {
            return;
        }
        HashSet<String> notDepGroups = new HashSet<String>();
        TestDependentJoins.getDependentGroups(((RelationalPlan)plan).getRootNode(), notDepGroups, false);
        HashSet<String> expectedGroups = new HashSet<String>();
        for (int i = 0; i < groups.length; ++i) {
            expectedGroups.add(groups[i].toUpperCase());
        }
        Assert.assertEquals((String)"Expected groups were made dependent", expectedGroups, notDepGroups);
    }

    @Test
    public void testOptionMakeDep1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm2.g1 where pm1.g1.e1 = pm2.g1.e1 option makedep pm2.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm2.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm2.g1"});
        this.checkNotDependentGroups(plan, new String[]{"pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testOptionMakeDep2() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1, pm2.g1.e1 from pm1.g1 MAKEDEP INNER JOIN pm2.g1 MAKENOTDEP ON pm1.g1.e1 = pm2.g1.e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm2.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g1"});
        this.checkNotDependentGroups(plan, new String[]{"pm2.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testDepJoinHintForceLeft() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4 option makedep pm1.g1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g2 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g1"});
    }

    @Test
    public void testDepJoinHintForceRight() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4 option makedep pm1.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g2"});
    }

    @Test
    public void testGlobalHint() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4 option makedep @g4.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g2"});
    }

    @Test
    public void testGlobalHint1() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4 as x option makedep @x.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g2"});
    }

    @Test
    public void testDepJoinMultiGroupBaseline() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select vm1.g4.*, pm1.g3.e1 FROM vm1.g4, pm1.g3 where pm1.g3.e1=vm1.g4.e1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g3.e1 FROM pm1.g3"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[0]);
    }

    @Test
    public void testDepJoinMultiGroupForceOther() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select vm1.g4.*, pm1.g3.e1 FROM vm1.g4, pm1.g3 where pm1.g3.e1=vm1.g4.e1 option makedep pm1.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g3 AS g_0", "SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g2"});
    }

    @Test
    public void testDepJoinHintForceLeft_NotDep() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4 option makedep pm1.g1 makenotdep pm1.g2", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g2 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g1"});
        this.checkNotDependentGroups(plan, new String[]{"pm1.g2"});
    }

    @Test
    public void testDepJoinHintForceRight_NotDep() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * FROM vm1.g4 option makedep pm1.g2 makenotdep pm1.g1", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g2"});
        this.checkNotDependentGroups(plan, new String[]{"pm1.g1"});
    }

    @Test
    public void testDepJoinMultiGroupForceOther_NotDep() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select vm1.g4.*, pm1.g3.e1 FROM vm1.g4, pm1.g3 where pm1.g3.e1=vm1.g4.e1 option makedep pm1.g2 makenotdep pm1.g1, pm1.g3", (QueryMetadataInterface)TestOptimizer.example1(), new String[]{"SELECT g_0.e1 FROM pm1.g3 AS g_0", "SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm1.g2"});
        this.checkNotDependentGroups(plan, new String[]{"pm1.g1", "pm1.g3"});
    }

    @Test
    public void testMakeDependentAccessPattern1() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g1 where pm1.g1.e1 = pm4.g1.e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm4.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm4.g1"});
    }

    @Test
    public void testMakeDependentAccessPattern1a() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm4.g1, pm1.g1 where pm4.g1.e1 = pm1.g1.e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm4.g1 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm4.g1"});
    }

    @Test
    public void testMakeDependentAccessPattern2() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g1 where pm4.g1.e2 = 1 and pm1.g1.e1 = pm4.g1.e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm4.g1 AS g_0 WHERE (g_0.e2 = 1) AND (g_0.e1 IN (<dependent values>))", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm4.g1"});
    }

    @Test
    public void testMakeDependentAccessPattern3() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g2 where pm1.g1.e1 = pm4.g2.e5", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e5 FROM pm4.g2 AS g_0 WHERE g_0.e5 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[]{"pm4.g2"});
    }

    @Test
    public void testPushSelectAndMakeDependentAccessPattern1() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g1 where pm4.g1.e1 = 'abc' and pm1.g1.e1 = 'abc' and pm1.g1.e2 = pm4.g1.e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'", "SELECT pm4.g1.e2 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushSelectAndMakeDependentAccessPattern1a() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm4.g1, pm1.g1 where pm4.g1.e2 = pm1.g1.e2 and pm4.g1.e1 = 'abc' and pm1.g1.e1 = 'abc'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e1 = 'abc'", "SELECT pm4.g1.e2 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testPushSelectAndMakeDependentAccessPattern2() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm4.g1 where pm4.g1.e1 = 'abc' and pm1.g1.e2 = pm4.g1.e2", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1", "SELECT pm4.g1.e2 FROM pm4.g1 WHERE pm4.g1.e1 = 'abc'"}, TestOptimizer.getGenericFinder(false), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestDependentJoins.checkDependentGroups(plan, new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin1() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(10));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testUseMergeJoin2() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm1.g2.e1 FROM pm1.g2"}, TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testMultiMergeJoin3() throws Exception {
        String sql = "SELECT pm1.g2.e1 FROM pm1.g3, pm1.g2, pm1.g1 WHERE pm1.g2.e1 = pm1.g3.e1 AND pm1.g1.e1 = pm1.g2.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g3", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g3 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g2 AS g_0", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testMultiMergeJoin2() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2, pm1.g3 WHERE pm1.g1.e1 = pm1.g2.e1 AND pm1.g2.e1 = pm1.g3.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g3", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0", "SELECT g_0.e1 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>)", "SELECT g_0.e1 FROM pm1.g3 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testMultiMergeJoin5_defect13448() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2, pm1.g3 WHERE pm1.g1.e1 = pm1.g2.e1 AND pm1.g1.e1 = pm1.g3.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g3", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0", "SELECT g_0.e1 AS c_0 FROM pm1.g3 AS g_0 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0", "SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 2, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testMergeJoinVirtualGroups() throws Exception {
        String sql = "SELECT vm1.g1.e1 FROM vm1.g1, vm1.g2a WHERE vm1.g1.e1 = vm1.g2a.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g2", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e1 AS c_0 FROM pm1.g2 AS g_0 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testRLMCase2077() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        caps.setFunctionSupport("||", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQT();
        RealMetadataFactory.setCardinality("bqt1.smalla", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("bqt2.smalla", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT table1comp.IntKey, table1comp.key1, BQT1.SmallA.StringKey FROM (SELECT t1.*, (STRINGKEY || STRINGNUM) AS key1 FROM BQT2.SmallA AS t1) AS table1comp, BQT1.SmallA WHERE table1comp.key1 = BQT1.SmallA.StringKey", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.StringKey, g_0.StringNum, g_0.IntKey FROM BQT2.SmallA AS g_0", "SELECT g_0.StringKey FROM BQT1.SmallA AS g_0 WHERE g_0.StringKey IN (<dependent values>)"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testRLMCase2077_2() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.ARRAY_TYPE, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        caps.setFunctionSupport("||", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQT();
        RealMetadataFactory.setCardinality("bqt1.smalla", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1000, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("bqt2.smalla", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY - 1, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT table1comp.IntKey, table1comp.key1, BQT1.SmallA.StringKey FROM (SELECT t1.*, (STRINGKEY || STRINGNUM) AS key1 FROM BQT2.SmallA AS t1) AS table1comp, BQT1.SmallA WHERE table1comp.key1 = BQT1.SmallA.StringKey AND table1comp.key1 = BQT1.SmallA.StringNum", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.StringKey, g_0.StringNum, g_0.IntKey FROM BQT2.SmallA AS g_0", "SELECT g_0.StringKey, g_0.StringNum FROM BQT1.SmallA AS g_0 WHERE (g_0.StringNum = g_0.StringKey) AND (g_0.StringKey IN (<dependent values>))"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testCostingCleanup() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQT();
        RealMetadataFactory.setCardinality("bqt1.smalla", 1000, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("bqt2.smalla", 10000, (QueryMetadataInterface)metadata);
        Column fmo = metadata.getElementID("bqt1.smalla.intnum");
        fmo.setDistinctValues(1000);
        Column floatnum = metadata.getElementID("bqt1.smalla.floatnum");
        floatnum.setDistinctValues(800);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT max(a.stringkey) from bqt1.smalla a, bqt2.smalla a2, bqt1.smalla a1 where a.intnum = a2.intnum and a1.stringnum = a2.stringnum and a.floatnum = a1.floatnum", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.StringNum, g_0.IntNum FROM BQT2.SmallA AS g_0 WHERE (g_0.StringNum IN (<dependent values>)) AND (g_0.IntNum IN (<dependent values>))", "SELECT DISTINCT g_1.StringNum AS c_0, g_0.IntNum AS c_1, g_0.StringKey AS c_2 FROM BQT1.SmallA AS g_0, BQT1.SmallA AS g_1 WHERE g_0.FloatNum = g_1.FloatNum ORDER BY c_0, c_1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testSystemDependent() throws TeiidComponentException, TeiidProcessingException {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, sys.columns makedep where pm1.g1.e1 = sys.columns.name";
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(RealMetadataFactory.example1Store(), SystemMetadata.getInstance().getSystemStore()));
        TransformationMetadata tm = new TransformationMetadata(null, cms, null, null, null);
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc), new String[]{"SELECT pm1.g1.e1 FROM pm1.g1", "SELECT SYS.Columns.Name FROM SYS.Columns WHERE SYS.Columns.Name IN (<dependent values>)"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0});
    }

    @Test
    public void testPlanningOverJoin() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, (select pm2.g2.e1, pm2.g3.e2 from pm2.g2 left outer join pm2.g3 on pm2.g2.e1 = pm2.g3.e1) as x where pm1.g1.e1 = x.e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm2.g2", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm2.g3", RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY + 1, (QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 AS c_0 FROM pm2.g2 AS g_0 LEFT OUTER JOIN pm2.g3 AS g_1 ON g_0.e1 = g_1.e1 WHERE g_0.e1 IN (<dependent values>) ORDER BY c_0", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testMakedepWithAggregatePushdown() throws Exception {
        String sql = "select count(x.e2), pm2.g2.e1 from pm1.g1 x makedep, pm2.g2 where x.e4 = pm2.g2.e4 group by pm2.g2.e1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)TestOptimizer.getTypicalCapabilities()), new String[]{"SELECT g_0.e4, g_0.e2 FROM pm1.g1 AS g_0 WHERE g_0.e4 IN (<dependent values>)", "SELECT g_0.e4 AS c_0, g_0.e1 AS c_1 FROM pm2.g2 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testKeepTransitiveWithDependentJoin() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1, pm2.g1, pm2.g2 where pm1.g1.e1 = pm2.g1.e1 and pm1.g1.e1 = pm2.g2.e1 and pm2.g1.e2 = pm2.g2.e2 option makedep pm2.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_1.e1, g_0.e1 FROM pm2.g1 AS g_0, pm2.g2 AS g_1 WHERE (g_0.e2 = g_1.e2) AND (g_1.e1 = g_0.e1) AND (g_1.e1 IN (<dependent values>))", "SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testNestedLeftOuterJoin() throws TeiidComponentException, TeiidProcessingException {
        String sql = "select pm1.g1.e2, 'a', trim(pm1.g3.e1) from (pm1.g1 left outer join pm1.g2 on pm1.g1.e2 = pm1.g2.e2) left outer join pm1.g3 on pm1.g3.e3 = pm1.g2.e3 and pm1.g3.e4 = pm1.g1.e4";
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g2", 6, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g1", 0, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm1.g3", 0, (QueryMetadataInterface)metadata);
        CapabilitiesFinder finder = TestOptimizer.getGenericFinder(false);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, new String[]{"SELECT g_0.e3, g_0.e4, g_0.e1 FROM pm1.g3 AS g_0", "SELECT g_0.e2, g_0.e4 FROM pm1.g1 AS g_0", "SELECT g_0.e2, g_0.e3 FROM pm1.g2 AS g_0 WHERE g_0.e2 IN (<dependent values>)"}, finder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 1, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
        RelationalPlan rPlan = (RelationalPlan)plan;
        RelationalNode node = rPlan.getRootNode().getChildren()[0];
        Assert.assertTrue((boolean)(node instanceof JoinNode));
        node = node.getChildren()[0];
        Assert.assertTrue((boolean)(node instanceof JoinNode));
        Assert.assertEquals((Object)JoinType.JOIN_LEFT_OUTER, (Object)((JoinNode)node).getJoinType());
    }
}

