/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TestParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestCreateDrop {
    @Test
    public void testCreateTempTable1() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        create.setCommitAction(Create.CommitAction.PRESERVE_ROWS);
        TestParser.helpTest("Create local TEMPORARY table tempTable (c1 boolean, c2 byte) on commit preserve rows", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean, c2 byte) ON COMMIT PRESERVE ROWS", (Command)create);
    }

    @Test
    public void testCreateTempTable2() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        ((Column)create.getColumns().get(0)).setNullType(BaseColumn.NullType.No_Nulls);
        TestParser.helpTest("Create local TEMPORARY table tempTable(c1 boolean not null, c2 byte)", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean NOT NULL, c2 byte)", (Command)create);
    }

    @Test
    public void testCreateTempTable3() throws QueryParserException {
        String sql = "Create TEMPORARY table tempTable (c1 boolean, c2 byte)";
        Assert.assertEquals((Object)"CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean, c2 byte)", (Object)QueryParser.getQueryParser().parseCommand(sql).toString());
    }

    @Test
    public void testCreateTempTable4() {
        TestParser.helpException("Create table tempTable (c1 boolean, c2 byte)");
    }

    @Test
    public void testCreateTempTable5() {
        TestParser.helpException("Create  local TEMPORARY table tempTable (c1 boolean primary, c2 byte)");
    }

    @Test
    public void testCreateTempTable7() {
        TestParser.helpException("Create local TEMPORARY table tempTable (c1.x boolean, c2 byte)", "TEIID31100 Parsing error: Encountered \"table tempTable ([*]c1.x[*] boolean,\" at line 1, column 41.\nInvalid simple identifier format: [c1.x]");
    }

    @Test
    public void testCreateTempTableWithPrimaryKey() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        create.getPrimaryKey().add(column);
        TestParser.helpTest("Create local TEMPORARY table tempTable(c1 boolean, c2 byte, primary key (c2))", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean, c2 byte, PRIMARY KEY(c2))", (Command)create);
    }

    @Test
    public void testDropTable() {
        Drop drop = new Drop();
        drop.setTable(new GroupSymbol("tempTable"));
        TestParser.helpTest("DROP table tempTable", "DROP TABLE tempTable", (Command)drop);
    }

    @Test
    public void testForeignTemp() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        create.setOn("source");
        Table t = new Table();
        t.setName("tempTable");
        t.setUUID("tid:0");
        Column c = new Column();
        c.setName("x");
        c.setUUID("tid:0");
        Datatype string = (Datatype)SystemMetadata.getInstance().getRuntimeTypeMap().get("string");
        c.setDatatype(string, true, 0);
        t.addColumn(c);
        c = new Column();
        c.setName("y");
        c.setUUID("tid:0");
        Datatype decimal = (Datatype)SystemMetadata.getInstance().getRuntimeTypeMap().get("decimal");
        c.setDatatype(decimal, true, 0);
        t.addColumn(c);
        t.setCardinality(10000);
        create.setTableMetadata(t);
        TestParser.helpTest("create foreign temporary table tempTable (x string, y decimal) options (cardinality 10000) on source", "CREATE FOREIGN TEMPORARY TABLE tempTable (\n\tx string,\n\ty bigdecimal\n) OPTIONS (CARDINALITY 10000) ON 'source'", (Command)create);
    }

    @Test
    public void testBadCreate() {
        TestParser.helpException("create insert");
    }

    @Test
    public void testTypeAliases() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.STRING);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        column = new ElementSymbol("c3");
        column.setType(DataTypeManager.DefaultDataClasses.SHORT);
        columns.add(column);
        column = new ElementSymbol("c4");
        column.setType(DataTypeManager.DefaultDataClasses.FLOAT);
        columns.add(column);
        column = new ElementSymbol("c5");
        column.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        TestParser.helpTest("Create local TEMPORARY table tempTable (c1 varchar, c2 tinyint, c3 smallint, c4 real, c5 decimal)", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 varchar, c2 tinyint, c3 smallint, c4 real, c5 decimal)", (Command)create);
    }
}

