/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.List;
import org.junit.Test;
import org.teiid.dqp.internal.process.TestTPCR;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestCrossSourceStarJoin {
    @Test
    public void testCrossSourceStarJoin() throws Exception {
        String sql = "select p.Description, sum(AMOUNT) from s3 p, s2 c, s1 b, o1 f where p.PRODUCTID = f.PRODUCT and c.CurrencyCode = f.CURRENCY and b.BOOKID = f.BOOK and b.Name = 'xyz' and c.Name = 'abc' Group by p.Description";
        MetadataStore metadataStore = new MetadataStore();
        Schema oracle = RealMetadataFactory.createPhysicalModel((String)"oracle", (MetadataStore)metadataStore);
        Schema sybase = RealMetadataFactory.createPhysicalModel((String)"sybase", (MetadataStore)metadataStore);
        Table f = RealMetadataFactory.createPhysicalGroup((String)"o1", (Schema)oracle);
        f.setCardinality(5276965);
        Table b = RealMetadataFactory.createPhysicalGroup((String)"s1", (Schema)sybase);
        b.setCardinality(141496);
        Table c = RealMetadataFactory.createPhysicalGroup((String)"s2", (Schema)sybase);
        c.setCardinality(228);
        Table p = RealMetadataFactory.createPhysicalGroup((String)"s3", (Schema)sybase);
        p.setCardinality(200);
        List f_cols = RealMetadataFactory.createElements((ColumnSet)f, (String[])new String[]{"PRODUCT", "CURRENCY", "BOOK", "AMOUNT"}, (String[])new String[]{"string", "integer", "string", "bigdecimal"});
        ((Column)f_cols.get(0)).setDistinctValues(400);
        ((Column)f_cols.get(1)).setDistinctValues(228);
        ((Column)f_cols.get(2)).setDistinctValues(141496);
        RealMetadataFactory.createKey((KeyRecord.Type)KeyRecord.Type.Index, (String)"idx_p", (Table)f, f_cols.subList(0, 1));
        RealMetadataFactory.createKey((KeyRecord.Type)KeyRecord.Type.Index, (String)"idx_c", (Table)f, f_cols.subList(1, 2));
        RealMetadataFactory.createKey((KeyRecord.Type)KeyRecord.Type.Index, (String)"idx_b", (Table)f, f_cols.subList(2, 3));
        List b_cols = RealMetadataFactory.createElements((ColumnSet)b, (String[])new String[]{"BOOKID", "Name"}, (String[])new String[]{"string", "string"});
        RealMetadataFactory.createKey((KeyRecord.Type)KeyRecord.Type.Primary, (String)"pk", (Table)b, b_cols.subList(0, 1));
        ((Column)b_cols.get(1)).setDistinctValues(70000);
        List c_cols = RealMetadataFactory.createElements((ColumnSet)c, (String[])new String[]{"Name", "CurrencyCode"}, (String[])new String[]{"string", "integer"});
        RealMetadataFactory.createKey((KeyRecord.Type)KeyRecord.Type.Primary, (String)"pk", (Table)c, c_cols.subList(1, 2));
        List p_cols = RealMetadataFactory.createElements((ColumnSet)p, (String[])new String[]{"PRODUCTID", "Description"}, (String[])new String[]{"string", "string"});
        RealMetadataFactory.createKey((KeyRecord.Type)KeyRecord.Type.Primary, (String)"pk", (Table)p, p_cols.subList(0, 1));
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("oracle", TestTPCR.oracleCapabilities());
        finder.addCapabilities("sybase", TestTPCR.sqlServerCapabilities());
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)metadataStore, (String)"star", (FunctionTree[])new FunctionTree[0]);
        TestOptimizer.helpPlan((String)sql, (QueryMetadataInterface)metadata, (String[])new String[]{"SELECT g_0.CurrencyCode AS c_0 FROM sybase.s2 AS g_0 WHERE g_0.Name = 'abc' ORDER BY c_0", "SELECT g_0.BOOKID AS c_0 FROM sybase.s1 AS g_0 WHERE g_0.Name = 'xyz' ORDER BY c_0", "SELECT g_0.PRODUCTID AS c_0, g_0.Description AS c_1 FROM sybase.s3 AS g_0 ORDER BY c_0", "SELECT g_0.BOOK, g_0.PRODUCT, g_0.CURRENCY, SUM(g_0.AMOUNT) FROM oracle.o1 AS g_0 WHERE (g_0.BOOK IN (<dependent values>)) AND (g_0.PRODUCT IN (<dependent values>)) AND (g_0.CURRENCY IN (<dependent values>)) GROUP BY g_0.BOOK, g_0.PRODUCT, g_0.CURRENCY"}, (CapabilitiesFinder)finder, (TestOptimizer.ComparisonMode)TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        f.setCardinality(527696);
        TestOptimizer.helpPlan((String)sql, (QueryMetadataInterface)metadata, (String[])new String[]{"SELECT g_0.CurrencyCode AS c_0 FROM sybase.s2 AS g_0 WHERE g_0.Name = 'abc' ORDER BY c_0", "SELECT g_0.BOOK, g_0.PRODUCT, g_0.CURRENCY, g_0.AMOUNT FROM oracle.o1 AS g_0 WHERE (g_0.BOOK IN (<dependent values>)) AND (g_0.CURRENCY IN (<dependent values>))", "SELECT g_0.PRODUCTID AS c_0, g_0.Description AS c_1 FROM sybase.s3 AS g_0 ORDER BY c_0", "SELECT g_0.BOOKID AS c_0 FROM sybase.s1 AS g_0 WHERE g_0.Name = 'xyz' ORDER BY c_0"}, (CapabilitiesFinder)finder, (TestOptimizer.ComparisonMode)TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

