/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class RelationalPlan
extends ProcessorPlan {
    private RelationalNode root;
    private List<? extends Expression> outputCols;
    private List<WithQueryCommand> with;
    private TempTableStore tempTableStore;

    public RelationalPlan(RelationalNode node) {
        this.root = node;
    }

    public RelationalNode getRootNode() {
        return this.root;
    }

    public void setRootNode(RelationalNode root) {
        this.root = root;
    }

    public void setWith(List<WithQueryCommand> with) {
        this.with = with;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        if (this.with != null) {
            context = context.clone();
            this.tempTableStore = new TempTableStore(context.getConnectionId(), TempTableStore.TransactionMode.NONE);
            this.tempTableStore.setParentTempTableStore(context.getTempTableStore());
            context.setTempTableStore(this.tempTableStore);
        }
        this.setContext(context);
        RelationalPlan.connectExternal(this.root, context, dataMgr, bufferMgr);
    }

    static void connectExternal(RelationalNode node, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        node.initialize(context, bufferMgr, dataMgr);
        RelationalNode[] children = node.getChildren();
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount && children[i] != null; ++i) {
            RelationalPlan.connectExternal(children[i], context, dataMgr, bufferMgr);
        }
    }

    @Override
    public List<? extends Expression> getOutputElements() {
        return this.outputCols;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        if (this.with != null && this.tempTableStore.getProcessors() == null) {
            HashMap<String, TempTableStore.TableProcessor> processors = new HashMap<String, TempTableStore.TableProcessor>();
            this.tempTableStore.setProcessors(processors);
            for (WithQueryCommand withCommand : this.with) {
                if (withCommand.isRecursive()) {
                    SetQuery setQuery = (SetQuery)withCommand.getCommand();
                    ProcessorPlan initial = setQuery.getLeftQuery().getProcessorPlan();
                    QueryProcessor withProcessor = new QueryProcessor(initial, this.getContext().clone(), this.root.getBufferManager(), this.root.getDataManager());
                    processors.put(withCommand.getGroupSymbol().getName(), new TempTableStore.RecursiveTableProcessor(withProcessor, withCommand.getColumns(), setQuery.getRightQuery().getProcessorPlan(), setQuery.isAll()));
                    continue;
                }
                ProcessorPlan plan = withCommand.getCommand().getProcessorPlan();
                QueryProcessor withProcessor = new QueryProcessor(plan, this.getContext().clone(), this.root.getBufferManager(), this.root.getDataManager());
                processors.put(withCommand.getGroupSymbol().getName(), new TempTableStore.TableProcessor(withProcessor, withCommand.getColumns()));
            }
        }
        this.root.open();
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.root.nextBatch();
    }

    @Override
    public void close() throws TeiidComponentException {
        if (this.tempTableStore != null) {
            this.tempTableStore.removeTempTables();
            if (this.tempTableStore.getProcessors() != null) {
                for (TempTableStore.TableProcessor proc : this.tempTableStore.getProcessors().values()) {
                    proc.close();
                }
                this.tempTableStore.setProcessors(null);
            }
        }
        this.root.close();
    }

    @Override
    public void reset() {
        super.reset();
        this.root.reset();
        if (this.with != null) {
            for (WithQueryCommand withCommand : this.with) {
                if (withCommand.isRecursive()) {
                    SetQuery setQuery = (SetQuery)withCommand.getCommand();
                    setQuery.getLeftQuery().getProcessorPlan().reset();
                    setQuery.getLeftQuery().getProcessorPlan().reset();
                    continue;
                }
                withCommand.getCommand().getProcessorPlan().reset();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.with != null) {
            sb.append("WITH");
            for (WithQueryCommand withCommand : this.with) {
                sb.append("\n");
                sb.append(withCommand.getGroupSymbol());
                if (withCommand.isRecursive()) {
                    sb.append(" anchor\n").append(((SetQuery)withCommand.getCommand()).getLeftQuery().getProcessorPlan());
                    sb.append("recursive\n").append(((SetQuery)withCommand.getCommand()).getRightQuery().getProcessorPlan());
                    continue;
                }
                sb.append("\n");
                sb.append(withCommand.getCommand().getProcessorPlan());
            }
            sb.append("body\n");
        }
        sb.append(this.root.toString());
        return sb.toString();
    }

    @Override
    public RelationalPlan clone() {
        RelationalPlan plan = new RelationalPlan((RelationalNode)this.root.clone());
        plan.setOutputElements(this.outputCols);
        if (this.with != null) {
            ArrayList<WithQueryCommand> newWith = LanguageObject.Util.deepClone(this.with, WithQueryCommand.class);
            for (WithQueryCommand withQueryCommand : newWith) {
                if (withQueryCommand.isRecursive()) {
                    SetQuery setQuery = (SetQuery)withQueryCommand.getCommand();
                    setQuery.getLeftQuery().setProcessorPlan(setQuery.getLeftQuery().getProcessorPlan().clone());
                    setQuery.getRightQuery().setProcessorPlan(setQuery.getRightQuery().getProcessorPlan().clone());
                    continue;
                }
                withQueryCommand.getCommand().setProcessorPlan(withQueryCommand.getCommand().getProcessorPlan().clone());
            }
            plan.setWith(newWith);
        }
        return plan;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.root.getDescriptionProperties();
        if (this.with != null) {
            AnalysisRecord.addLanaguageObjects(node, "With", this.with);
        }
        return node;
    }

    public void setOutputElements(List<? extends Expression> outputCols) {
        this.outputCols = outputCols;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean requires;
        boolean txnWtih = false;
        if (this.with != null) {
            for (WithQueryCommand withCommand : this.with) {
                if (withCommand.isRecursive()) {
                    SetQuery setQuery = (SetQuery)withCommand.getCommand();
                    Boolean leftRequires = setQuery.getLeftQuery().getProcessorPlan().requiresTransaction(transactionalReads);
                    Boolean rightRequires = setQuery.getLeftQuery().getProcessorPlan().requiresTransaction(transactionalReads);
                    if (Boolean.TRUE.equals(leftRequires) || Boolean.TRUE.equals(rightRequires)) {
                        return true;
                    }
                    if (leftRequires != null && rightRequires != null) continue;
                    if (txnWtih) {
                        return true;
                    }
                    txnWtih = true;
                    continue;
                }
                Boolean requires2 = withCommand.getCommand().getProcessorPlan().requiresTransaction(transactionalReads);
                if (Boolean.TRUE.equals(requires2)) {
                    return true;
                }
                if (requires2 != null) continue;
                if (txnWtih) {
                    return true;
                }
                txnWtih = true;
            }
        }
        if (Boolean.TRUE.equals(requires = RelationalPlan.requiresTransaction(transactionalReads, this.root))) {
            return true;
        }
        if (requires == null && txnWtih) {
            return true;
        }
        if (txnWtih || requires == null) {
            return null;
        }
        return false;
    }

    static Boolean requiresTransaction(boolean transactionalReads, RelationalNode node) {
        Boolean requiresTxn = node.requiresTransaction(transactionalReads);
        if (Boolean.TRUE.equals(requiresTxn)) {
            return true;
        }
        for (RelationalNode child : node.getChildren()) {
            if (child == null) continue;
            Boolean childRequires = RelationalPlan.requiresTransaction(transactionalReads, child);
            if (Boolean.TRUE.equals(childRequires)) {
                return true;
            }
            if (childRequires != null) continue;
            if (requiresTxn == null) {
                return true;
            }
            requiresTxn = null;
        }
        return requiresTxn;
    }

    @Override
    public TupleBuffer getBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.root.getBuffer(maxRows);
    }

    @Override
    public boolean hasBuffer() {
        return this.root.hasBuffer();
    }
}

