/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.util.Assertion;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.AssignmentInstruction;
import org.teiid.query.processor.proc.BlockInstruction;
import org.teiid.query.processor.proc.BranchingInstruction;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ErrorInstruction;
import org.teiid.query.processor.proc.ExecDynamicSqlInstruction;
import org.teiid.query.processor.proc.IfInstruction;
import org.teiid.query.processor.proc.LoopInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.processor.proc.ReturnInstruction;
import org.teiid.query.processor.proc.WhileInstruction;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class ProcedurePlanner
implements CommandPlanner {
    @Override
    public ProcessorPlan optimize(Command procCommand, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n####################################################");
            analysisRecord.println("PROCEDURE COMMAND: " + procCommand);
        }
        CreateProcedureCommand cupc = (CreateProcedureCommand)Assertion.isInstanceOf((Object)procCommand, CreateProcedureCommand.class, (String)"Wrong command type");
        if (debug) {
            analysisRecord.println("OPTIMIZING SUB-COMMANDS: ");
        }
        for (Command command : CommandCollectorVisitor.getCommands(procCommand)) {
            if (command instanceof DynamicCommand) continue;
            command.setProcessorPlan(QueryOptimizer.optimizePlan(command, metadata, idGenerator, capFinder, analysisRecord, context));
        }
        Block block = cupc.getBlock();
        Program programBlock = this.planBlock(cupc, block, metadata, debug, idGenerator, capFinder, analysisRecord, context);
        if (debug) {
            analysisRecord.println("\n####################################################");
        }
        ProcedurePlan plan = new ProcedurePlan(programBlock);
        plan.setMetadata(metadata);
        plan.setOutputElements(cupc.getProjectedSymbols());
        if (debug) {
            analysisRecord.println("####################################################");
            analysisRecord.println("PROCEDURE PLAN :" + plan);
            analysisRecord.println("####################################################");
        }
        return plan;
    }

    private Program planBlock(CreateProcedureCommand parentProcCommand, Block block, QueryMetadataInterface metadata, boolean debug, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Program programBlock = new Program(block.isAtomic());
        programBlock.setLabel(block.getLabel());
        this.planStatements(parentProcCommand, block.getStatements(), metadata, debug, idGenerator, capFinder, analysisRecord, context, programBlock);
        if (block.getExceptionGroup() != null) {
            programBlock.setExceptionGroup(block.getExceptionGroup());
            if (block.getExceptionStatements() != null) {
                Program exceptionBlock = new Program(false);
                this.planStatements(parentProcCommand, block.getExceptionStatements(), metadata, debug, idGenerator, capFinder, analysisRecord, context, exceptionBlock);
                programBlock.setExceptionProgram(exceptionBlock);
            }
        }
        return programBlock;
    }

    private void planStatements(CreateProcedureCommand parentProcCommand, List<Statement> stmts, QueryMetadataInterface metadata, boolean debug, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context, Program programBlock) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (Statement statement : stmts) {
            Object instruction = this.planStatement(parentProcCommand, statement, metadata, debug, idGenerator, capFinder, analysisRecord, context);
            if (instruction instanceof ProgramInstruction) {
                programBlock.addInstruction((ProgramInstruction)instruction);
                continue;
            }
            ProgramInstruction[] insts = (ProgramInstruction[])instruction;
            for (int i = 0; i < insts.length; ++i) {
                programBlock.addInstruction(insts[i]);
            }
        }
    }

    private Object planStatement(CreateProcedureCommand parentProcCommand, Statement statement, QueryMetadataInterface metadata, boolean debug, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        int stmtType = statement.getType();
        ProgramInstruction[] instruction = null;
        switch (stmtType) {
            case 3: 
            case 5: 
            case 13: {
                AssignmentStatement assignStmt = (AssignmentStatement)statement;
                if (stmtType == 13 && assignStmt.getVariable() == null) {
                    return new ReturnInstruction();
                }
                AssignmentInstruction assignInstr = new AssignmentInstruction();
                instruction = assignInstr;
                assignInstr.setVariable(assignStmt.getVariable());
                Expression asigExpr = assignStmt.getExpression();
                assignInstr.setExpression(asigExpr);
                if (debug) {
                    analysisRecord.println("\tASSIGNMENT\n" + statement);
                }
                if (stmtType != 13) break;
                ReturnInstruction ri = new ReturnInstruction();
                instruction = new ProgramInstruction[]{assignInstr, ri};
                break;
            }
            case 4: {
                ErrorInstruction error = new ErrorInstruction();
                instruction = error;
                RaiseStatement res = (RaiseStatement)statement;
                Expression asigExpr = res.getExpression();
                error.setExpression(asigExpr);
                error.setWarning(res.isWarning());
                if (!debug) break;
                analysisRecord.println("\tRAISE STATEMENT:\n" + statement);
                break;
            }
            case 2: {
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command command = cmdStmt.getCommand();
                ProcessorPlan commandPlan = cmdStmt.getCommand().getProcessorPlan();
                if (command.getType() == 10) {
                    instruction = new ExecDynamicSqlInstruction(parentProcCommand, (DynamicCommand)command, metadata, idGenerator, capFinder, ((DynamicCommand)command).getIntoGroup() == null && cmdStmt.isReturnable() && parentProcCommand.returnsResultSet());
                } else {
                    StoredProcedure sp;
                    CreateCursorResultSetInstruction cursor = new CreateCursorResultSetInstruction(null, commandPlan, this.getMode(parentProcCommand, cmdStmt, command));
                    if (cursor.getMode() == CreateCursorResultSetInstruction.Mode.HOLD) {
                        for (GroupSymbol gs : GroupCollectorVisitor.getGroupsIgnoreInlineViews(command, false)) {
                            if (!gs.isTempTable() || metadata.getModelID(gs.getMetadataID()) != TempMetadataAdapter.TEMP_MODEL) continue;
                            cursor.setUsesLocalTemp(true);
                            break;
                        }
                    }
                    instruction = cursor;
                    if (command.getType() == 6 && (sp = (StoredProcedure)command).isCallableStatement()) {
                        LinkedHashMap<ElementSymbol, ElementSymbol> assignments = new LinkedHashMap<ElementSymbol, ElementSymbol>();
                        for (SPParameter param : sp.getParameters()) {
                            if (param.getParameterType() == 5 || param.getParameterType() == 1) continue;
                            Expression expr = param.getExpression();
                            if (expr instanceof Reference) {
                                expr = ((Reference)expr).getExpression();
                            }
                            ElementSymbol symbol = null;
                            if (expr instanceof ElementSymbol) {
                                symbol = (ElementSymbol)expr;
                            }
                            assignments.put(param.getParameterSymbol(), symbol);
                        }
                        ((CreateCursorResultSetInstruction)instruction).setProcAssignments(assignments);
                    }
                }
                if (!debug) break;
                analysisRecord.println("\tCOMMAND STATEMENT:\n " + statement);
                analysisRecord.println("\t\tSTATEMENT COMMAND PROCESS PLAN:\n " + commandPlan);
                break;
            }
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Program ifProgram = this.planBlock(parentProcCommand, ifStmt.getIfBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                Program elseProgram = null;
                if (ifStmt.hasElseBlock()) {
                    elseProgram = this.planBlock(parentProcCommand, ifStmt.getElseBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                }
                instruction = new IfInstruction(ifStmt.getCondition(), ifProgram, elseProgram);
                if (!debug) break;
                analysisRecord.println("\tIF STATEMENT:\n" + statement);
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                BranchingStatement bs = (BranchingStatement)statement;
                if (debug) {
                    analysisRecord.println("\t" + statement);
                }
                instruction = new BranchingInstruction(bs);
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                if (debug) {
                    analysisRecord.println("\tLOOP STATEMENT:\n" + statement);
                }
                String rsName = loopStmt.getCursorName();
                ProcessorPlan commandPlan = loopStmt.getCommand().getProcessorPlan();
                Program loopProgram = this.planBlock(parentProcCommand, loopStmt.getBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                instruction = new LoopInstruction(loopProgram, rsName, commandPlan, loopStmt.getLabel());
                break;
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Program whileProgram = this.planBlock(parentProcCommand, whileStmt.getBlock(), metadata, debug, idGenerator, capFinder, analysisRecord, context);
                if (debug) {
                    analysisRecord.println("\tWHILE STATEMENT:\n" + statement);
                }
                instruction = new WhileInstruction(whileProgram, whileStmt.getCondition(), whileStmt.getLabel());
                break;
            }
            case 11: {
                Block block = (Block)statement;
                instruction = new BlockInstruction(this.planBlock(parentProcCommand, block, metadata, debug, idGenerator, capFinder, analysisRecord, context));
                break;
            }
            default: {
                throw new AssertionError((Object)("Error while planning update procedure, unknown statement type encountered: " + statement));
            }
        }
        return instruction;
    }

    private CreateCursorResultSetInstruction.Mode getMode(CreateProcedureCommand parentProcCommand, CommandStatement cmdStmt, Command command) {
        if (!command.returnsResultSet() && !(command instanceof StoredProcedure)) {
            return CreateCursorResultSetInstruction.Mode.UPDATE;
        }
        if (parentProcCommand.returnsResultSet() && cmdStmt.isReturnable() && cmdStmt.getCommand().returnsResultSet()) {
            return CreateCursorResultSetInstruction.Mode.HOLD;
        }
        return CreateCursorResultSetInstruction.Mode.NOHOLD;
    }
}

