/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.common.buffer.BaseCacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.core.TeiidRuntimeException;

public class LrfuEvictionQueue<V extends BaseCacheEntry> {
    private static final long DEFAULT_HALF_LIFE = 65536L;
    static final long MIN_INTERVAL = 512L;
    protected ConcurrentSkipListMap<CacheKey, V> evictionQueue = new ConcurrentSkipListMap();
    protected AtomicLong clock;
    protected long maxInterval;
    protected long halfLife;
    private AtomicInteger size = new AtomicInteger();

    static boolean isSuspectSize(Number num) throws AssertionError {
        for (int i = 0; i < 500; ++i) {
            try {
                if (num.longValue() >= 0L) {
                    return false;
                }
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new TeiidRuntimeException((Throwable)e);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    public LrfuEvictionQueue(AtomicLong clock) {
        this.clock = clock;
        this.setHalfLife(65536L);
    }

    public boolean remove(V value) {
        if (this.evictionQueue.remove(((BaseCacheEntry)value).getKey()) != null) {
            int result = this.size.addAndGet(-1);
            assert (result >= 0 || !LrfuEvictionQueue.isSuspectSize(this.size));
            return true;
        }
        return false;
    }

    public boolean add(V value) {
        if (this.evictionQueue.putIfAbsent(((BaseCacheEntry)value).getKey(), value) == null) {
            this.size.addAndGet(1);
            return true;
        }
        return false;
    }

    public void touch(V value) {
        long tick = this.clock.get();
        if (tick - 512L < ((BaseCacheEntry)value).getKey().getLastAccess()) {
            this.add(value);
            return;
        }
        this.remove(value);
        this.recordAccess(value);
        this.add(value);
    }

    public Collection<V> getEvictionQueue() {
        return this.evictionQueue.values();
    }

    public V firstEntry(boolean poll) {
        Map.Entry<CacheKey, V> entry = null;
        if (poll) {
            entry = this.evictionQueue.pollFirstEntry();
            if (entry != null) {
                int result = this.size.addAndGet(-1);
                assert (result >= 0 || !LrfuEvictionQueue.isSuspectSize(this.size));
            }
        } else {
            entry = this.evictionQueue.firstEntry();
        }
        if (entry != null) {
            return (V)((BaseCacheEntry)entry.getValue());
        }
        return null;
    }

    void recordAccess(V value) {
        CacheKey key = ((BaseCacheEntry)value).getKey();
        long lastAccess = key.getLastAccess();
        long currentClock = this.clock.get();
        long orderingValue = key.getOrderingValue();
        orderingValue = this.computeNextOrderingValue(currentClock, lastAccess, orderingValue);
        assert (!this.evictionQueue.containsKey(((BaseCacheEntry)value).getKey()));
        ((BaseCacheEntry)value).setKey(new CacheKey(key.getId(), currentClock, orderingValue));
    }

    long computeNextOrderingValue(long currentTime, long lastAccess, long orderingValue) {
        long delta = currentTime - lastAccess;
        if (delta > this.maxInterval) {
            return currentTime;
        }
        long increase = orderingValue + lastAccess;
        if (delta > this.halfLife) {
            while ((delta -= this.halfLife) > this.halfLife && (increase >>= 1) > 0L) {
            }
        }
        increase = Math.min(currentTime, increase);
        return currentTime + increase;
    }

    public void setHalfLife(long halfLife) {
        this.halfLife = halfLife;
        this.maxInterval = 62L * this.halfLife;
    }

    public int getSize() {
        return this.size.get();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Size:").append(this.getSize()).append(" ");
        int max = 2000;
        for (CacheKey e : this.evictionQueue.keySet()) {
            result.append("(").append(e.getOrderingValue()).append(", ").append(e.getLastAccess()).append(", ").append(e.getId()).append(") ");
            if (--max != 0) continue;
            result.append("...");
        }
        return result.toString();
    }
}

