/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.FakeFunctionMetadataSource;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.parser.TestDDLParser;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ExecutionFactory;

public class TestFunctionPushdown {
    @Test
    public void testMustPushdownOverMultipleSourcesWithoutSupport() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.FAILED_PLANNING);
    }

    @Test
    public void testMustPushdownOverMultipleSources() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("misc.namespace.func", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0", Arrays.asList(1, "a"));
        dataManager.addData("SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", Arrays.asList(1), Arrays.asList(2));
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setMetadata((QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList("a")});
    }

    @Test
    public void testSimpleFunctionPushdown() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("create foreign function func (param integer) returns integer; create foreign table g1 (e1 integer)", "x", "y");
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        final DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setQueryProcessorFactory(new QueryProcessor.ProcessorFactory(){

            public PreparedPlan getPreparedPlan(String query, String recursionGroup, CommandContext commandContext, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }

            public CapabilitiesFinder getCapabiltiesFinder() {
                return capFinder;
            }

            public QueryProcessor createQueryProcessor(String query, String recursionGroup, CommandContext commandContext, Object ... params) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }
        });
        cc.setMetadata((QueryMetadataInterface)tm);
        String sql = "select func(1)";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT func(1)", Arrays.asList(2));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(2)});
        sql = "select func(0) from g1 where func(e1) = 2";
        plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT y.g1.e1 FROM y.g1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT y.g1.e1 FROM y.g1", Arrays.asList(1), Arrays.asList(2));
        dataManager.addData("SELECT func(0)", Arrays.asList(1));
        dataManager.addData("SELECT func(1)", Arrays.asList(2));
        dataManager.addData("SELECT func(2)", Arrays.asList(3));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(1)});
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        sql = "select case when hasrole('x') then func(0) else 2 end from g1";
        plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT func(0) FROM y.g1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT func(0) FROM g1", Arrays.asList(1), Arrays.asList(1));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(1), Arrays.asList(1)});
    }

    @Test
    public void testSimpleFunctionPushdown1() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        bsc.setFunctionSupport("parseDate_", true);
        final DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setQueryProcessorFactory(new QueryProcessor.ProcessorFactory(){

            public PreparedPlan getPreparedPlan(String query, String recursionGroup, CommandContext commandContext, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }

            public CapabilitiesFinder getCapabiltiesFinder() {
                return capFinder;
            }

            public QueryProcessor createQueryProcessor(String query, String recursionGroup, CommandContext commandContext, Object ... params) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }
        });
        cc.setMetadata((QueryMetadataInterface)tm);
        String sql = "select parseDate_('2011-11-11')";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT parsedate_('2011-11-11')", Arrays.asList(TimestampUtil.createDate((int)0, (int)0, (int)0)));
        cc.setDQPWorkContext(RealMetadataFactory.buildWorkContext(tm));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(TimestampUtil.createDate((int)0, (int)0, (int)0))});
        sql = "select misc.namespace.func('2011-11-11')";
        plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT parseDate_('2011-11-11')", Arrays.asList(TimestampUtil.createDate((int)0, (int)0, (int)0)));
        try {
            TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(TimestampUtil.createDate((int)0, (int)0, (int)0))});
            Assert.fail();
        }
        catch (TeiidProcessingException teiidProcessingException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleFunctionPushdown2() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("x", new RealMetadataFactory.DDLHolder("y", "CREATE FOREIGN FUNCTION func(a object, b object) RETURNS string;"), new RealMetadataFactory.DDLHolder("z", "CREATE FOREIGN FUNCTION func1(a object, b object) RETURNS string; create foreign table g1 (e1 object)"));
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        final DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setQueryProcessorFactory(new QueryProcessor.ProcessorFactory(){

            public PreparedPlan getPreparedPlan(String query, String recursionGroup, CommandContext commandContext, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }

            public CapabilitiesFinder getCapabiltiesFinder() {
                return capFinder;
            }

            public QueryProcessor createQueryProcessor(String query, String recursionGroup, CommandContext commandContext, Object ... params) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }
        });
        cc.setMetadata((QueryMetadataInterface)tm);
        String sql = "select e1 from g1 where func(1, 1) = '2'";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT z.g1.e1 FROM z.g1 WHERE func(1, 1) = '2'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT func(1, 1)", Arrays.asList("hello world"));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[0]);
        sql = "select e1 from g1 where func1(1, 1) = '2'";
        plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT z.g1.e1 FROM z.g1 WHERE func1(1, 1) = '2'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT g1.e1 FROM g1 WHERE func1(1, 1) = '2'", Arrays.asList("hello world"));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList("hello world")});
    }

    @Test
    public void testMustPushdownOverMultipleSourcesWithView() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("misc.namespace.func", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from (select x.* from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2 order by e1 limit 10) as x";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1, g_0.e1 AS c_2 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", Arrays.asList(1));
        dataManager.addData("SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1, g_0.e1 AS c_2 FROM pm1.g1 AS g_0 ORDER BY c_0", Arrays.asList(1, "aa", "a"), Arrays.asList(2, "bb", "b"));
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setMetadata((QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList("aa")});
    }

    @Test
    public void testMustPushdownOverMultipleSourcesWithViewDupRemoval() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("misc.namespace.func", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from (select distinct x.* from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2 order by e1 limit 10) as x";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.FAILED_PLANNING);
    }

    @Test
    public void testDDLMetadata() throws Exception {
        String ddl = "CREATE VIRTUAL FUNCTION SourceFunc(msg varchar) RETURNS varchar OPTIONS(CATEGORY 'misc', DETERMINISM 'DETERMINISTIC', \"NULL-ON-NULL\" 'true', JAVA_CLASS '" + TestFunctionPushdown.class.getName() + "', JAVA_METHOD 'sourceFunc');CREATE VIEW X (Y varchar) as SELECT e1 from pm1.g1;";
        MetadataFactory mf = TestDDLParser.helpParse(ddl, "model");
        mf.getSchema().setPhysical(false);
        MetadataStore ms = mf.asMetadataStore();
        ms.merge((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore());
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(ms, "example1", new FunctionTree[0]);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("model.SourceFunc", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select sourceFunc(y) from x", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT sourceFunc(g_0.e1) FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        caps.setFunctionSupport("model.SourceFunc", false);
        TestOptimizer.helpPlan("select sourceFunc(y) from x", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testDDLMetadata1() throws Exception {
        String ddl = "CREATE foreign FUNCTION sourceFunc(msg varchar) RETURNS varchar options (nameinsource 'a.sourcefunc'); CREATE foreign FUNCTION b.sourceFunc(msg varchar) RETURNS varchar; CREATE foreign table X (Y varchar);";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL(ddl, "x", "phy");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("phy", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT sourceFunc(g_0.Y), phy.b.sourceFunc(g_0.Y) FROM phy.X AS g_0", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT sourceFunc(g_0.Y), phy.b.sourceFunc(g_0.Y) FROM phy.X AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dm = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dm.addData("SELECT a.sourcefunc(g_0.Y), b.sourceFunc(g_0.Y) FROM X AS g_0", new List[0]);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setMetadata((QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, cc, dm, new List[0]);
    }

    @Test
    public void testDDLMetadataNameConflict() throws Exception {
        String ddl = "CREATE foreign FUNCTION \"convert\"(msg integer, type varchar) RETURNS varchar; CREATE foreign table X (Y integer);";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL(ddl, "x", "phy");
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("phy", (SourceCapabilities)caps);
        TestOptimizer.helpPlan("select phy.convert(y, 'z') from x", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT phy.convert(g_0.Y, 'z') FROM phy.X AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testConcat2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("concat2", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select concat2(x.e1, x.e1) from pm1.g1 as x";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT concat2(g_0.e1, g_0.e1) FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        caps.setFunctionSupport("concat2", false);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 FROM pm1.g1 AS g_0", Arrays.asList("a"), Arrays.asList(new String[]{null}));
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList("aa"), Arrays.asList(new String[]{null})});
        caps.setFunctionSupport("concat", true);
        caps.setFunctionSupport("ifnull", true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT concat2(g_0.e1, g_0.e1) FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromUnitTime() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT from_unixtime(x.e2) from pm1.g1 as x";
        String expected = "SELECT from_unixtime(g_0.e2) FROM pm1.g1 AS g_0";
        caps.setFunctionSupport("from_unixtime", true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        expected = "SELECT g_0.e2 FROM pm1.g1 AS g_0";
        caps.setFunctionSupport("from_unixtime", false);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expected, Arrays.asList(1500000000));
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        try {
            TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(Timestamp.valueOf("2017-07-13 20:40:00.0"))});
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
        expected = "SELECT from_unixtime(g_0.e2) FROM pm1.g1 AS g_0";
        caps.setFunctionSupport("timestampadd", true);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expected}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testPartialProjectPushdown() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("select case when e1 = 1 then 1 else 0 end, e2 + e4 from pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT CASE WHEN g_0.e1 = '1' THEN 1 ELSE 0 END, g_0.e2, g_0.e4 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dm = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dm.addData("SELECT CASE WHEN g_0.e1 = '1' THEN 1 ELSE 0 END, g_0.e2, g_0.e4 FROM g1 AS g_0", Arrays.asList(1, 2, 3.1));
        TestProcessor.helpProcess(plan, dm, new List[]{Arrays.asList(1, 5.1)});
    }

    @Test
    public void testMustPushdownOverGrouping() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("create foreign function func (param integer) returns integer; create foreign table g1 (e1 integer)", "x", "y");
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        final DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setQueryProcessorFactory(new QueryProcessor.ProcessorFactory(){

            public PreparedPlan getPreparedPlan(String query, String recursionGroup, CommandContext commandContext, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }

            public CapabilitiesFinder getCapabiltiesFinder() {
                return capFinder;
            }

            public QueryProcessor createQueryProcessor(String query, String recursionGroup, CommandContext commandContext, Object ... params) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }
        });
        cc.setMetadata((QueryMetadataInterface)tm);
        String sql = "select func(e1) from g1 group by e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT y.g1.e1 FROM y.g1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT y.g1.e1 FROM y.g1", Arrays.asList(1), Arrays.asList(2));
        dataManager.addData("SELECT func(1)", Arrays.asList(2));
        dataManager.addData("SELECT func(2)", Arrays.asList(3));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(2), Arrays.asList(3)});
    }

    @Test
    public void testMustPushdownSubexpressionOverGrouping() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("create foreign function func (param integer) returns integer; create foreign table g1 (e1 integer, e2 integer)", "x", "y");
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        final DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setQueryProcessorFactory(new QueryProcessor.ProcessorFactory(){

            public PreparedPlan getPreparedPlan(String query, String recursionGroup, CommandContext commandContext, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }

            public CapabilitiesFinder getCapabiltiesFinder() {
                return capFinder;
            }

            public QueryProcessor createQueryProcessor(String query, String recursionGroup, CommandContext commandContext, Object ... params) throws TeiidProcessingException, TeiidComponentException {
                return null;
            }
        });
        cc.setMetadata((QueryMetadataInterface)tm);
        String sql = "select max(func(e2)) from g1 group by e1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT y.g1.e1, func(y.g1.e2) FROM y.g1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT y.g1.e1, func(y.g1.e2) FROM y.g1", Arrays.asList(1, 2), Arrays.asList(2, 3));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList(2), Arrays.asList(3)});
    }

    public static String sourceFunc(String msg) {
        return msg;
    }

    @Test
    public void testPartialProjectPushdownCorrelatedSubquery() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR_PROJECTION, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("select x.c, case when e1 = 1 then 1 else 0 end, (select e1 from pm1.g1 where pm1.g1.e1 = pm1.g2.e1) from pm1.g2, (select max(e1) as c from pm1.g2) x where x.c = pm1.g2.e1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT v_0.c_0, g_0.e1, (SELECT g_2.e1 FROM pm1.g1 AS g_2 WHERE g_2.e1 = g_0.e1) FROM pm1.g2 AS g_0, (SELECT MAX(g_1.e1) AS c_0 FROM pm1.g2 AS g_1) AS v_0 WHERE v_0.c_0 = g_0.e1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dm = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dm.addData("SELECT v_0.c_0, g_0.e1, (SELECT g_2.e1 FROM g1 AS g_2 WHERE g_2.e1 = g_0.e1) FROM g2 AS g_0, (SELECT MAX(g_1.e1) AS c_0 FROM g2 AS g_1) AS v_0 WHERE v_0.c_0 = g_0.e1", Arrays.asList("a", "a", "a"));
        TestProcessor.helpProcess(plan, dm, new List[]{Arrays.asList("a", 0, "a")});
    }

    @Test
    public void testMustPushdownSubexpression() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("create foreign function func (param integer) returns integer; create foreign table g1 (e1 integer)", "x", "y");
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder((SourceCapabilities)bsc);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setMetadata((QueryMetadataInterface)tm);
        String sql = "select xmlelement(name x, func(1) + e1) from g1";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)tm, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT func(1), y.g1.e1 FROM y.g1"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)tm);
        dataManager.addData("SELECT func(1), g1.e1 FROM g1", Arrays.asList(2, 0));
        TestProcessor.helpProcess(plan, cc, dataManager, new List[]{Arrays.asList("<x>2</x>")});
    }

    @Test
    public void testParseFormatNameCase() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ONLY_FORMAT_LITERALS, true);
        caps.setFunctionSupport("formattimestamp", true);
        caps.setTranslator((ExecutionFactory)new ExecutionFactory<Object, Object>(){

            public boolean supportsFormatLiteral(String literal, ExecutionFactory.Format format) {
                return literal.equals("yyyy");
            }
        });
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT stringkey from bqt1.smalla where formatTimestamp(timestampvalue, 'yyyy') = '1921' and parsebigdecimal(stringkey, 'yyyy') = 1 and formatTimestamp(timestampvalue, stringkey) = '19'", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT g_0.TimestampValue, g_0.StringKey FROM BQT1.SmallA AS g_0 WHERE formatTimestamp(g_0.TimestampValue, 'yyyy') = '1921'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    }

    @Test
    public void testSystemNameConflict() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("create foreign table t (x char); create foreign function chr(x char) returns string", "x", "y");
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        String sql = "SELECT chr(x) from t";
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        dataMgr.addData("SELECT y.chr(y.t.x) FROM y.t", Arrays.asList("a"));
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)tm, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc));
        TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), dataMgr, new List[]{Arrays.asList("a")});
    }
}

