/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestSetProcessing {
    @Test
    public void testExcept() throws Exception {
        String sql = "select e1, e2 from pm1.g2 except select e1, 1 from pm1.g2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g2.e1, pm1.g2.e2 FROM pm1.g2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("b", 2)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testIntersect() throws Exception {
        String sql = "select e1, e2 from pm1.g2 intersect select e1, 1 from pm1.g2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new String[]{"SELECT pm1.g2.e1 FROM pm1.g2", "SELECT pm1.g2.e1, pm1.g2.e2 FROM pm1.g2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        List[] expected = new List[]{Arrays.asList(null, 1), Arrays.asList("c", 1)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testIntersectExcept() {
        String sql = "select e1, e2 from pm1.g2 except select e1, 1 from pm1.g2 intersect select 'a', e2 from pm1.g2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 FROM pm1.g2 AS g_0", "SELECT g_0.e1, g_0.e2 FROM pm1.g2 AS g_0", "SELECT g_0.e2 FROM pm1.g2 AS g_0"});
        List[] expected = new List[]{Arrays.asList(null, 1), Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("b", 2), Arrays.asList("c", 1)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testUnionExcept() {
        String sql = "(select 'a' union select 'b' union select 'c') except select 'c'";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0]);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 4, 0, 0, 2});
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b")};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testUnionArrayNull() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create view v (col string[]) as select null union all select null", "x", "y");
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from v", (QueryMetadataInterface)metadata, new String[0]);
        List[] expected = new List[]{Collections.singletonList(null), Collections.singletonList(null)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testNestedUnionPlan() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL("create foreign table t1 (col string); create foreign table t2 (col string);create foreign table t3 (col string);create foreign table t4 (col string);", "x", "y");
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_INTERSECT, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("(select * from t1 union all select * from t2 union all select * from t3) intersect select * from t4", (QueryMetadataInterface)metadata, new String[]{"(SELECT g_3.col AS c_0 FROM y.t1 AS g_3 UNION ALL SELECT g_2.col AS c_0 FROM y.t2 AS g_2 UNION ALL SELECT g_1.col AS c_0 FROM y.t3 AS g_1) INTERSECT SELECT g_0.col AS c_0 FROM y.t4 AS g_0"}, new DefaultCapabilitiesFinder((SourceCapabilities)bsc), TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }
}

