/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.DependentCriteriaProcessor;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.util.CommandContext;

public class TestDependentCriteriaProcessor {
    @Test
    public void testNegatedSetCriteria() throws Exception {
        DependentAccessNode dan = new DependentAccessNode(0);
        SetCriteria sc = new SetCriteria((Expression)new ElementSymbol("e1"), Arrays.asList(new Constant((Object)1), new Constant((Object)2)));
        sc.setAllConstants(true);
        sc.negate();
        DependentCriteriaProcessor dcp = new DependentCriteriaProcessor(1, -1, (RelationalNode)dan, (Criteria)sc);
        Criteria result = dcp.prepareCriteria();
        Assert.assertEquals((Object)sc, (Object)result);
        Assert.assertFalse((boolean)dcp.hasNextCommand());
    }

    @Test
    public void testSetCriteria() throws Exception {
        DependentAccessNode dan = new DependentAccessNode(0);
        SetCriteria sc = new SetCriteria((Expression)new ElementSymbol("e1"), Arrays.asList(new Constant((Object)1), new Constant((Object)2)));
        sc.setAllConstants(true);
        DependentCriteriaProcessor dcp = new DependentCriteriaProcessor(1, -1, (RelationalNode)dan, (Criteria)sc);
        Criteria result = dcp.prepareCriteria();
        Assert.assertEquals((Object)new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)1)), (Object)result);
        Assert.assertTrue((boolean)dcp.hasNextCommand());
    }

    @Test
    public void testEvaluatedSetCriteria() throws Exception {
        DependentAccessNode dan = new DependentAccessNode(0);
        CommandContext cc = new CommandContext();
        dan.setContext(cc);
        List<Reference> references = Arrays.asList(new Reference(1), new Reference(2));
        for (Reference reference : references) {
            cc.getVariableContext().setGlobalValue(reference.getContextSymbol(), (Object)1);
        }
        SetCriteria sc = new SetCriteria((Expression)new ElementSymbol("e1"), references);
        sc.setAllConstants(true);
        DependentCriteriaProcessor dcp = new DependentCriteriaProcessor(1, -1, (RelationalNode)dan, (Criteria)sc);
        Criteria result = dcp.prepareCriteria();
        Assert.assertEquals((Object)new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)1)), (Object)result);
        Assert.assertFalse((boolean)dcp.hasNextCommand());
    }
}

