/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestRulePushSelectCriteria {
    @Test
    public void testElementsInCritieria() throws Exception {
        String criteria = "e1 = '1' OR ((e1 = '2' OR e1 = '4') AND e2 = 3)";
        HashSet<ElementSymbol> expected = new HashSet<ElementSymbol>(Arrays.asList(new ElementSymbol("e1")));
        Assert.assertEquals(expected, (Object)RulePushSelectCriteria.getElementsIncriteria((Criteria)QueryParser.getQueryParser().parseCriteria(criteria)));
    }

    @Test
    public void testElementsInCritieria1() throws Exception {
        String criteria = "e1 = '1' and ((e1 = '2' OR e1 = '4') AND e2 = 3) or e2 is null";
        HashSet<ElementSymbol> expected = new HashSet<ElementSymbol>(Arrays.asList(new ElementSymbol("e2")));
        Assert.assertEquals(expected, (Object)RulePushSelectCriteria.getElementsIncriteria((Criteria)QueryParser.getQueryParser().parseCriteria(criteria)));
    }

    @Test
    public void testPushAcrossFrameWithAccessNode() throws Exception {
        TempMetadataAdapter metadata = new TempMetadataAdapter((QueryMetadataInterface)RealMetadataFactory.example1Cached(), new TempMetadataStore());
        Command command = TestOptimizer.helpGetCommand("select * from (select * from pm1.g1 union select * from pm1.g2) x where e1 = 1", (QueryMetadataInterface)metadata, null);
        Command subCommand = TestOptimizer.helpGetCommand("select * from pm1.g1 union select * from pm1.g2", (QueryMetadataInterface)metadata, null);
        RelationalPlanner p = new RelationalPlanner();
        CommandContext cc = new CommandContext();
        p.initialize(command, null, (QueryMetadataInterface)metadata, null, null, cc);
        PlanNode root = p.generatePlan(command);
        PlanNode child = p.generatePlan(subCommand);
        PlanNode sourceNode = NodeEditor.findNodePreOrder((PlanNode)root, (int)64);
        sourceNode.addFirstChild(child);
        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, (Object)SymbolMap.createSymbolMap((GroupSymbol)((GroupSymbol)sourceNode.getGroups().iterator().next()), (List)((List)child.getFirstChild().getProperty(NodeConstants.Info.PROJECT_COLS)), (QueryMetadataInterface)metadata));
        PlanNode accessNode = NodeFactory.getNewNode((int)1);
        accessNode.addGroups((Collection)child.getFirstChild().getGroups());
        child.getFirstChild().addAsParent(accessNode);
        new RulePushSelectCriteria().execute(root, (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), new RuleStack(), AnalysisRecord.createNonRecordingRecord(), cc);
        accessNode = NodeEditor.findNodePreOrder((PlanNode)root, (int)1);
        Assert.assertEquals((long)16L, (long)accessNode.getParent().getType());
        Assert.assertNull((Object)NodeEditor.findNodePreOrder((PlanNode)accessNode, (int)16));
    }
}

