/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.SimpleMock;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.NativeMetadataRepository;
import org.teiid.query.parser.QueryParser;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.oracle.OracleExecutionFactory;
import org.teiid.translator.jdbc.teiid.TeiidExecutionFactory;

public class TestDynamicImportedMetaData {
    private FakeServer server;

    @Before
    public void setup() {
        this.server = new FakeServer(true);
    }

    @After
    public void tearDown() {
        this.server.stop();
    }

    private MetadataFactory getMetadata(Properties importProperties, Connection conn) throws TranslatorException {
        MetadataFactory mf = this.createMetadataFactory("test", importProperties);
        TeiidExecutionFactory tef = new TeiidExecutionFactory();
        tef.getMetadata(mf, conn);
        return mf;
    }

    private MetadataFactory createMetadataFactory(String schema, Properties importProperties) {
        VDBRepository vdbRepository = new VDBRepository();
        return new MetadataFactory("vdb", (Object)1, schema, vdbRepository.getRuntimeTypeMap(), importProperties, null);
    }

    @Test
    public void testUniqueReferencedKey() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/keys.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importKeys", "true");
        importProperties.setProperty("importer.schemaPattern", "x");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("VDB.X.A");
        List fks = t.getForeignKeys();
        Assert.assertEquals((long)1L, (long)fks.size());
        Assert.assertNotNull((Object)((ForeignKey)fks.get(0)).getPrimaryKey());
    }

    @Test
    public void testProcImport() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Procedure p = (Procedure)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getProcedures().get("VDB.SYS.GETXMLSCHEMAS");
        Assert.assertEquals((long)1L, (long)p.getResultSet().getColumns().size());
    }

    @Test
    public void testExcludes() throws Exception {
        this.server.deployVDB("vdb", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        importProperties.setProperty("importer.excludeTables", "VDB\\.(SYS|pg_catalog).*");
        importProperties.setProperty("importer.excludeProcedures", "VDB\\..*");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Assert.assertEquals((String)String.valueOf(((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables()), (long)3L, (long)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().size());
        Assert.assertEquals((long)0L, (long)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getProcedures().size());
    }

    @Test
    public void testDuplicateException() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        MetadataFactory mf1 = this.createMetadataFactory("y", new Properties());
        Table dup = mf.addTable("dup");
        Table dup1 = mf1.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        mf1.addColumn("x", "string", (ColumnSet)dup1);
        MetadataStore ms = mf.asMetadataStore();
        ms.addSchema((Schema)mf1.asMetadataStore().getSchemas().values().iterator().next());
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("TEST.X.DUP");
        Assert.assertEquals((Object)"\"test\".\"x\".\"dup\"", (Object)t.getNameInSource());
        importProperties.setProperty("importer.useFullSchemaName", Boolean.FALSE.toString());
        try {
            this.getMetadata(importProperties, (Connection)conn);
            Assert.fail();
        }
        catch (DuplicateRecordException duplicateRecordException) {
            // empty catch block
        }
    }

    @Test
    public void testUseCatalog() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.useCatalogName", Boolean.FALSE.toString());
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("X.DUP");
        Assert.assertEquals((Object)"\"x\".\"dup\"", (Object)t.getNameInSource());
    }

    @Test
    public void testUseCatalogSeparator() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        Connection conn1 = (Connection)SimpleMock.createSimpleMock((Object[])new Object[]{new ConnectionProxy((Connection)conn), conn}, (Class[])new Class[]{Connection.class});
        mf = this.getMetadata(importProperties, conn1);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("test:X.DUP");
        Assert.assertEquals((Object)"\"test\":\"x\".\"dup\"", (Object)t.getNameInSource());
    }

    @Test
    public void testUseQualified() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.useQualifiedName", Boolean.FALSE.toString());
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("DUP");
        Assert.assertEquals((Object)"\"dup\"", (Object)t.getNameInSource());
    }

    @Test
    public void testDDLMetadata() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE getTextFiles(IN pathAndPattern varchar) RETURNS (file clob, filpath string) OPTIONS(UUID 'uuid')";
        MetadataFactory mf = this.createMetadataFactory("MarketData", new Properties());
        QueryParser.getQueryParser().parseDDL(mf, ddl);
        MetadataStore ms = mf.asMetadataStore();
        String ddl2 = "CREATE VIEW stock (symbol string, price bigdecimal) OPTIONS (UUID 'uuid')AS select stock.* from (call MarketData.getTextFiles('*.txt')) f, TEXTTABLE(f.file COLUMNS symbol string, price bigdecimal HEADER) stock;";
        MetadataFactory m2 = this.createMetadataFactory("portfolio", new Properties());
        QueryParser.getQueryParser().parseDDL(m2, ddl2);
        m2.getSchema().setPhysical(false);
        m2.mergeInto(ms);
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties props = new Properties();
        props.setProperty("importer.importProcedures", Boolean.TRUE.toString());
        MetadataStore store = this.getMetadata(props, (Connection)conn).asMetadataStore();
        Procedure p = store.getSchema("test").getProcedure("test.MarketData.getTextFiles");
        Assert.assertNotNull((Object)p);
        ProcedureParameter pp = (ProcedureParameter)p.getParameters().get(0);
        Assert.assertEquals((Object)"pathAndPattern", (Object)pp.getName());
        Assert.assertEquals((Object)"\"pathAndPattern\"", (Object)pp.getNameInSource());
        Assert.assertEquals((Object)ProcedureParameter.Type.In, (Object)pp.getType());
        Table t = store.getSchema("test").getTable("test.portfolio.stock");
        Assert.assertNotNull((Object)t);
        List columns = t.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((Object)"symbol", (Object)((Column)columns.get(0)).getName());
        Assert.assertEquals((Object)"price", (Object)((Column)columns.get(1)).getName());
    }

    @Test
    public void testImportFunction() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("dup");
        mf.addColumn("x", "string", (ColumnSet)dup);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importPushdownFunctions", Boolean.TRUE.toString());
        mf = this.createMetadataFactory("test", importProperties);
        NativeMetadataRepository nmr = new NativeMetadataRepository();
        OracleExecutionFactory oef = new OracleExecutionFactory();
        oef.start();
        DataSource ds = (DataSource)Mockito.mock(DataSource.class);
        Mockito.stub((Object)ds.getConnection()).toReturn((Object)conn);
        nmr.loadMetadata(mf, (ExecutionFactory)oef, (Object)ds);
        NavigableMap functions = ((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getFunctions();
        Assert.assertEquals((long)18L, (long)functions.size());
    }

    @Test
    public void testIgnorePkIndex() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("x");
        mf.addColumn("x", "string", (ColumnSet)dup);
        mf.addPrimaryKey("foo", Arrays.asList("x"), dup);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        mf.addIndex("foo", false, Arrays.asList("x"), dup);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importKeys", Boolean.TRUE.toString());
        importProperties.setProperty("importer.importIndexes", Boolean.TRUE.toString());
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("test.X.X");
        Assert.assertNotNull((Object)t.getPrimaryKey());
        Assert.assertEquals((long)0L, (long)t.getUniqueKeys().size());
        Assert.assertEquals((long)0L, (long)t.getIndexes().size());
    }

    @Test
    public void testDroppedFk() throws Exception {
        ModelMetaData mmd = new ModelMetaData();
        mmd.addSourceMetadata("ddl", "create foreign table x (y integer primary key);create foreign table z (y integer, foreign key (y) references x)");
        mmd.setName("foo");
        mmd.addSourceMapping("x", "x", "x");
        this.server.addTranslator("x", new ExecutionFactory());
        this.server.deployVDB("vdb", new ModelMetaData[]{mmd});
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importKeys", "true");
        importProperties.setProperty("importer.tableNamePattern", "z");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("test")).getTables().get("vdb.foo.z");
        List fks = t.getForeignKeys();
        Assert.assertEquals((long)0L, (long)fks.size());
    }

    @Test
    public void testMultipleFK() throws Exception {
        ModelMetaData mmd = new ModelMetaData();
        mmd.addSourceMetadata("ddl", "create foreign table x (y integer, z integer, primary key (y, z));create foreign table z (y integer, z integer, y1 integer, z1 integer, foreign key (y, z) references x (y, z), foreign key (y1, z1) references x (y, z))");
        mmd.setName("foo");
        mmd.addSourceMapping("x", "x", "x");
        this.server.addTranslator("x", new ExecutionFactory());
        this.server.deployVDB("vdb", new ModelMetaData[]{mmd});
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:vdb");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.importKeys", "true");
        MetadataFactory mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("test")).getTables().get("vdb.foo.z");
        List fks = t.getForeignKeys();
        Assert.assertEquals((long)2L, (long)fks.size());
    }

    @Test
    public void testMultiSource() throws Exception {
        ModelMetaData mmd = new ModelMetaData();
        mmd.addSourceMetadata("ddl", "create foreign table x (y integer primary key);");
        mmd.setName("foo");
        mmd.addSourceMapping("x", "x", "x");
        this.server.addTranslator("x", new ExecutionFactory());
        this.server.deployVDB("vdb", new ModelMetaData[]{mmd});
        TeiidExecutionFactory tef = new TeiidExecutionFactory(){

            public void closeConnection(Connection connection, DataSource factory) {
            }
        };
        tef.setSupportsDirectQueryProcedure(true);
        tef.start();
        this.server.addTranslator("teiid", (ExecutionFactory)tef);
        DataSource ds = (DataSource)Mockito.mock(DataSource.class);
        Mockito.stub((Object)ds.getConnection()).toReturn((Object)this.server.getDriver().connect("jdbc:teiid:vdb", null));
        this.server.addConnectionFactory("teiid1", ds);
        this.server.addConnectionFactory("teiid2", ds);
        this.server.deployVDB(new FileInputStream(UnitTestUtil.getTestDataFile((String)"multi.xml")));
        ConnectionImpl c = this.server.createConnection("jdbc:teiid:multi", null);
        Statement s = c.createStatement();
        s.execute("call native('select ?', 'b')");
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        s.execute("call native(request=>'select ?', variable=>('b',), target=>'teiid1')");
        rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Object[] result = (Object[])rs.getArray(1).getArray();
        Assert.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])result);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testMultiSourceImportError() throws Exception {
        ModelMetaData mmd = new ModelMetaData();
        mmd.addSourceMetadata("ddl", "create foreign table x (y integer primary key);");
        mmd.setName("foo");
        mmd.addSourceMapping("x", "x", "x");
        this.server.addTranslator("x", new ExecutionFactory());
        this.server.deployVDB("vdb", new ModelMetaData[]{mmd});
        TeiidExecutionFactory tef = new TeiidExecutionFactory(){

            public void closeConnection(Connection connection, DataSource factory) {
            }
        };
        tef.start();
        this.server.addTranslator("teiid", (ExecutionFactory)tef);
        DataSource ds = (DataSource)Mockito.mock(DataSource.class);
        ConnectionImpl c = this.server.getDriver().connect("jdbc:teiid:vdb", null);
        DatabaseMetaData dbmd = (DatabaseMetaData)SimpleMock.createSimpleMock((Object[])new Object[]{new BadMetadata(), c.getMetaData()}, (Class[])new Class[]{DatabaseMetaData.class});
        Connection mock = (Connection)Mockito.mock(Connection.class);
        Mockito.stub((Object)mock.getMetaData()).toReturn((Object)dbmd);
        Mockito.stub((Object)ds.getConnection()).toReturn((Object)mock);
        DataSource ds1 = (DataSource)Mockito.mock(DataSource.class);
        Mockito.stub((Object)ds1.getConnection()).toReturn((Object)this.server.getDriver().connect("jdbc:teiid:vdb", null));
        this.server.addConnectionFactory("teiid1", ds);
        this.server.addConnectionFactory("teiid2", ds1);
        this.server.deployVDB(new FileInputStream(UnitTestUtil.getTestDataFile((String)"multi.xml")));
    }

    @Test
    public void testUseScale() throws Exception {
        MetadataFactory mf = this.createMetadataFactory("x", new Properties());
        Table dup = mf.addTable("x");
        Column c = mf.addColumn("x", "bigdecimal", (ColumnSet)dup);
        c.setPrecision(10);
        c.setScale(2);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB("test", ms);
        ConnectionImpl conn = this.server.createConnection("jdbc:teiid:test");
        Properties importProperties = new Properties();
        importProperties.setProperty("importer.useQualifiedName", Boolean.FALSE.toString());
        mf = this.getMetadata(importProperties, (Connection)conn);
        Table t = (Table)((Schema)mf.asMetadataStore().getSchemas().get("TEST")).getTables().get("x");
        c = t.getColumnByName("x");
        Assert.assertEquals((long)10L, (long)c.getPrecision());
        Assert.assertEquals((long)2L, (long)c.getScale());
    }

    public static class ConnectionProxy {
        private final Connection conn;

        private ConnectionProxy(Connection conn) {
            this.conn = conn;
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            DatabaseMetaData dmd = this.conn.getMetaData();
            dmd = (DatabaseMetaData)SimpleMock.createSimpleMock((Object[])new Object[]{new DatabaseMetaDataProxy(), dmd}, (Class[])new Class[]{DatabaseMetaData.class});
            return dmd;
        }
    }

    public static class DatabaseMetaDataProxy {
        public String getCatalogSeparator() {
            return ":";
        }
    }

    public static final class BadMetadata {
        public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
            throw new SQLException();
        }
    }
}

