/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.SymmetricCryptor;

public class EncryptedStorageManager
implements StorageManager {
    private static final String DEFAULT_ALGORITHM = "AES/ECB/NoPadding";
    private StorageManager manager;
    private SecretKey key;

    public EncryptedStorageManager(StorageManager manager) {
        this.manager = manager;
    }

    @Override
    public void initialize() throws TeiidComponentException {
        this.manager.initialize();
        try {
            this.key = SymmetricCryptor.generateKey();
        }
        catch (CryptoException e) {
            throw new TeiidComponentException((Throwable)e);
        }
    }

    @Override
    public EncryptedFileStore createFileStore(String name) {
        FileStore file = this.manager.createFileStore(name);
        try {
            return new EncryptedFileStore(file, this.key);
        }
        catch (GeneralSecurityException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    @Override
    public long getMaxStorageSpace() {
        return this.manager.getMaxStorageSpace();
    }

    static final class EncryptedFileStore
    extends FileStore {
        private final FileStore file;
        private volatile long len;
        private Cipher encrypt;
        private Cipher decrypt;
        private int blockSize;

        private EncryptedFileStore(FileStore file, SecretKey key) throws GeneralSecurityException {
            this.file = file;
            this.decrypt = Cipher.getInstance(EncryptedStorageManager.DEFAULT_ALGORITHM);
            this.decrypt.init(2, key);
            this.encrypt = Cipher.getInstance(EncryptedStorageManager.DEFAULT_ALGORITHM);
            this.blockSize = this.encrypt.getBlockSize();
            this.encrypt.init(1, key);
        }

        @Override
        public synchronized void setLength(long length) throws IOException {
            this.len = length;
            if (length % (long)this.blockSize == 0L) {
                this.file.setLength(length);
            } else {
                this.file.setLength((length / (long)this.blockSize + 1L) * (long)this.blockSize);
            }
        }

        @Override
        protected void removeDirect() {
            this.file.remove();
        }

        @Override
        protected synchronized int readWrite(long fileOffset, byte[] b, int offSet, int length, boolean write) throws IOException {
            if (length == 0) {
                return 0;
            }
            long block = fileOffset / (long)this.blockSize;
            int remainder = (int)(fileOffset % (long)this.blockSize);
            if (!write) {
                if (fileOffset > this.len) {
                    throw new IOException("Invalid file position " + fileOffset + " length " + length);
                }
                length = (int)Math.min(Integer.MAX_VALUE, Math.min(this.len - fileOffset, (long)length));
            }
            long adjustedfileOffset = fileOffset;
            int adjustedLength = length;
            byte[] buffer = b;
            int bufferOffset = offSet;
            int remainingLength = (int)(((long)length + fileOffset) % (long)this.blockSize);
            if (remainder != 0 || remainingLength != 0) {
                adjustedfileOffset -= (long)remainder;
                if ((adjustedLength += remainder) % this.blockSize != 0) {
                    adjustedLength = (adjustedLength / this.blockSize + 1) * this.blockSize;
                }
                buffer = new byte[adjustedLength];
                bufferOffset = 0;
            }
            int blocks = adjustedLength / this.blockSize;
            int blockOffset = 0;
            if (!write) {
                this.file.readFully(adjustedfileOffset, buffer, bufferOffset, adjustedLength);
                for (int i = 0; i < blocks; ++i) {
                    try {
                        this.decrypt.doFinal(buffer, blockOffset, this.blockSize, buffer, blockOffset);
                        this.xorByBlock(buffer, 0, block + (long)i, blockOffset);
                    }
                    catch (GeneralSecurityException e) {
                        throw new IOException(e);
                    }
                    blockOffset += this.blockSize;
                }
                if (adjustedLength != length) {
                    System.arraycopy(buffer, remainder, b, offSet, length);
                }
                return length;
            }
            if (remainder != 0) {
                this.readFully(fileOffset - (long)remainder, buffer, 0, remainder);
            } else if (buffer == b) {
                buffer = new byte[adjustedLength];
            }
            System.arraycopy(b, offSet, buffer, remainder, length);
            for (int i = 0; i < blocks; ++i) {
                try {
                    if (i + 1 == blocks && remainingLength != 0 && fileOffset + (long)length < this.len) {
                        this.readFully(fileOffset + (long)length, buffer, blockOffset + remainingLength, (int)Math.min((long)(this.blockSize - remainingLength), this.len - fileOffset - (long)length));
                    }
                    this.xorByBlock(buffer, offSet, block + (long)i, blockOffset);
                    this.encrypt.doFinal(buffer, blockOffset, this.blockSize, buffer, blockOffset);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
                blockOffset += this.blockSize;
            }
            this.file.write(adjustedfileOffset, buffer, 0, adjustedLength);
            this.len = Math.max(this.len, fileOffset + (long)length);
            return length;
        }

        private void xorByBlock(byte[] b, int offSet, long blockMask, int blockOffset) {
            for (int j = 0; j < this.blockSize && blockMask > 0L; blockMask >>= 8, ++j) {
                int n = offSet + blockOffset + j;
                b[n] = (byte)((long)b[n] ^ blockMask);
            }
        }

        @Override
        public long getLength() {
            return this.len;
        }

        FileStore getFile() {
            return this.file;
        }
    }
}

