/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.EncryptedStorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.TestFileStorageManager;

public class TestEncryptedStorageManager {
    @Test
    public void testSetLength() throws Exception {
        MemoryStorageManager msm = new MemoryStorageManager();
        EncryptedStorageManager ssm = new EncryptedStorageManager((StorageManager)msm);
        ssm.initialize();
        String tsID = "0";
        EncryptedStorageManager.EncryptedFileStore store = ssm.createFileStore(tsID);
        TestFileStorageManager.writeBytes((FileStore)store);
        Assert.assertEquals((long)1L, (long)msm.getCreated());
        TestFileStorageManager.writeBytes((FileStore)store);
        Assert.assertEquals((long)4096L, (long)store.getLength());
        Assert.assertEquals((long)4096L, (long)store.getFile().getLength());
        store.setLength(256L);
        Assert.assertEquals((long)256L, (long)store.getLength());
        Assert.assertEquals((long)256L, (long)store.getFile().getLength());
        store.setLength(100L);
        Assert.assertEquals((long)100L, (long)store.getLength());
        Assert.assertEquals((long)112L, (long)store.getFile().getLength());
        store.readFully(0L, new byte[100], 0, 100);
    }

    @Test
    public void testReadWrite() throws Exception {
        MemoryStorageManager msm = new MemoryStorageManager();
        EncryptedStorageManager ssm = new EncryptedStorageManager((StorageManager)msm);
        ssm.initialize();
        String tsID = "0";
        EncryptedStorageManager.EncryptedFileStore store = ssm.createFileStore(tsID);
        for (int i = 0; i < 500; ++i) {
            byte[] b = new byte[i];
            Arrays.fill(b, (byte)i);
            store.write(b, 0, i);
            store.readFully(store.getLength() - (long)b.length, b, 0, b.length);
            for (int j = 0; j < b.length; ++j) {
                Assert.assertEquals((long)((byte)i), (long)b[j]);
            }
        }
        int start = 0;
        for (int i = 0; i < 500; ++i) {
            byte[] b = new byte[i];
            store.readFully((long)start, b, 0, b.length);
            for (int j = 0; j < b.length; ++j) {
                Assert.assertEquals((long)((byte)i), (long)b[j]);
            }
            start += i;
        }
        store.readFully(0L, new byte[(int)store.getLength()], 0, (int)store.getLength());
        store.write(16L, new byte[100], 0, 100);
        store.write((long)((int)store.getLength() - 100), new byte[99], 0, 99);
    }

    @Test(expected=IOException.class)
    public void testInvalidRead() throws Exception {
        MemoryStorageManager msm = new MemoryStorageManager();
        EncryptedStorageManager ssm = new EncryptedStorageManager((StorageManager)msm);
        ssm.initialize();
        String tsID = "0";
        EncryptedStorageManager.EncryptedFileStore store = ssm.createFileStore(tsID);
        store.read(1L, new byte[1], 0, 1);
    }
}

