/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.cdk.CommandBuilder;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.Command;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestLanguageBridgeFactory {
    @Before
    public void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
    }

    @After
    public void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    @Test
    public void testFromUnixtimeRewrite() throws Exception {
        String input = "select from_unixtime(intnum) from bqt1.Smalla";
        CommandBuilder commandBuilder = new CommandBuilder((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        commandBuilder.getLanguageBridgeFactory().setSupportFromUnixtime(false);
        Command obj = commandBuilder.getCommand(input, true, true);
        Assert.assertEquals((Object)"SELECT timestampadd(SQL_TSI_SECOND, g_0.IntNum, {ts '1969-12-31 18:00:00.0'}) FROM SmallA AS g_0", (Object)obj.toString());
    }
}

