/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestBatchIterator {
    @Test
    public void testReset() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)}, 1));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        bi.setBuffer(bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR), true);
        bi.mark();
        bi.nextTuple();
        bi.nextTuple();
        bi.reset();
        bi.nextTuple();
    }

    @Test
    public void testReset1() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(2), Arrays.asList(3)}, 2));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tb = bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR);
        bi.setBuffer(tb, true);
        bi.nextTuple();
        bi.mark();
        bi.nextTuple();
        bi.reset();
        Assert.assertEquals((long)2L, (long)bi.getCurrentIndex());
        Assert.assertEquals((Object)2, bi.nextTuple().get(0));
    }

    @Test
    public void testReset2() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(2)}, 2));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tb = bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR);
        bi.setBuffer(tb, true);
        bi.hasNext();
        bi.mark();
        bi.nextTuple();
        bi.nextTuple();
        Assert.assertNull((Object)bi.nextTuple());
        bi.reset();
        bi.hasNext();
        Assert.assertEquals((long)1L, (long)bi.getCurrentIndex());
        Assert.assertEquals((Object)1, bi.nextTuple().get(0));
    }

    @Test
    public void testBatchReadDuringMark() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)}, 2));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        bi.setBuffer(bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR), true);
        bi.mark();
        Assert.assertNotNull((Object)bi.nextTuple());
        Assert.assertNotNull((Object)bi.nextTuple());
        Assert.assertNotNull((Object)bi.nextTuple());
        bi.reset();
        Assert.assertNotNull((Object)bi.nextTuple());
        Assert.assertNotNull((Object)bi.nextTuple());
        Assert.assertNotNull((Object)bi.nextTuple());
        Assert.assertNotNull((Object)bi.nextTuple());
        Assert.assertNull((Object)bi.nextTuple());
    }

    @Test
    public void testDisableSave() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)}, 2));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tb = bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR);
        bi.setBuffer(tb, false);
        bi.setPosition(2L);
        Assert.assertTrue((boolean)bi.hasNext());
        tb.setForwardOnly(true);
        bi.setPosition(1L);
        bi.disableSave();
        for (int i = 0; i < 6; ++i) {
            Assert.assertNotNull((Object)bi.nextTuple());
        }
        Assert.assertNull((Object)bi.nextTuple());
        Assert.assertEquals((long)0L, (long)tb.getManagedRowCount());
    }

    @Test
    public void testReadAhead() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)}, 2));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tb = bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR);
        bi.setBuffer(tb, false);
        bi.nextTuple();
        Assert.assertEquals((long)1L, (long)bi.available());
        Assert.assertEquals((long)2L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(100L);
        Assert.assertEquals((long)4L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(3L);
        Assert.assertEquals((long)4L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(5L);
        Assert.assertEquals((long)6L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(8L);
        for (int i = 0; i < 5; ++i) {
            Assert.assertNotNull((Object)bi.nextTuple());
        }
        Assert.assertNull((Object)bi.nextTuple());
    }

    @Test
    public void testReadAheadMark() throws Exception {
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)}, 2));
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tb = bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR);
        bi.setBuffer(tb, true);
        bi.nextTuple();
        Assert.assertEquals((long)1L, (long)bi.available());
        Assert.assertEquals((long)0L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(100L);
        Assert.assertEquals((long)4L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(2L);
        Assert.assertEquals((long)4L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(5L);
        Assert.assertEquals((long)6L, (long)bi.getBuffer().getRowCount());
        bi.readAhead(8L);
        for (int i = 0; i < 6; ++i) {
            Assert.assertNotNull((Object)bi.nextTuple());
        }
        Assert.assertNull((Object)bi.nextTuple());
    }

    @Test
    public void testNoSaveForwardOnly() throws Exception {
        int i;
        BatchIterator bi = new BatchIterator((BatchCollector.BatchProducer)new FakeRelationalNode(1, new List[]{Arrays.asList(1), Arrays.asList(1), Arrays.asList(1), Arrays.asList(1)}, 2){

            @Override
            public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
                TupleBatch tb = super.nextBatchDirect();
                tb.setRowOffset(tb.getBeginRow() + 3L);
                return tb;
            }
        });
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TupleBuffer tb = bm.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, DataTypeManager.DefaultDataClasses.INTEGER)), "test", BufferManager.TupleSourceType.PROCESSOR);
        tb.setForwardOnly(true);
        bi.setBuffer(tb, false);
        tb.addTuple(Arrays.asList(2));
        tb.addTuple(Arrays.asList(2));
        tb.addTuple(Arrays.asList(2));
        Assert.assertEquals((long)3L, (long)bi.getBuffer().getManagedRowCount());
        bi.nextTuple();
        Assert.assertEquals((long)2L, (long)bi.available());
        Assert.assertEquals((long)0L, (long)bi.getBuffer().getManagedRowCount());
        for (i = 0; i < 2; ++i) {
            Assert.assertNotNull((Object)bi.nextTuple());
            Assert.assertEquals((long)0L, (long)bi.getBuffer().getManagedRowCount());
        }
        bi.readAhead(3L);
        Assert.assertEquals((long)2L, (long)bi.getBuffer().getManagedRowCount());
        for (i = 0; i < 4; ++i) {
            Assert.assertNotNull((Object)bi.nextTuple());
            Assert.assertEquals((long)0L, (long)bi.getBuffer().getManagedRowCount());
        }
        Assert.assertNull((Object)bi.nextTuple());
        Assert.assertEquals((long)0L, (long)bi.getBuffer().getManagedRowCount());
    }
}

