/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestSOAPWebService {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testVDBDeployment() throws Exception {
        Collection vdbs = this.admin.getVDBs();
        Assert.assertTrue((boolean)vdbs.isEmpty());
        Assert.assertTrue((boolean)this.admin.getDataSourceTemplateNames().contains("webservice"));
        String raSource = "web-ds";
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(raSource));
        this.admin.deploy("addressing-service.war", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"addressing-service.war")));
        Properties p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "http://localhost:8080/jboss-jaxws-addressing/AddressingService");
        this.admin.createDataSource(raSource, "webservice", p);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(raSource));
        this.admin.deploy("soapsvc-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"soapsvc-vdb.xml")));
        vdbs = this.admin.getVDBs();
        Assert.assertFalse((boolean)vdbs.isEmpty());
        VDB vdb = this.admin.getVDB("WSMSG", "1");
        AdminUtil.waitForVDBLoad(this.admin, "WSMSG", 1, 3);
        vdb = this.admin.getVDB("WSMSG", "1");
        Assert.assertTrue((boolean)vdb.isValid());
        Assert.assertTrue((boolean)vdb.getStatus().equals((Object)VDB.Status.ACTIVE));
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:WSMSG@mm://localhost:31000;user=user;password=user;", null);
        Statement stmt = conn.createStatement();
        String sql = "SELECT *\nFROM ADDRESSINGSERVICE.SAYHELLO\nWHERE MESSAGEID = 'UUID-100' AND SAYHELLO = 'Teiid'\nAND ADDRESSINGSERVICE.SAYHELLO.To = 'http://www.w3.org/2005/08/addressing/anonymous'\nAND ADDRESSINGSERVICE.SAYHELLO.ReplyTo = 'http://www.w3.org/2005/08/addressing/anonymous'\nAND ADDRESSINGSERVICE.SAYHELLO.Action = 'http://www.w3.org/2005/08/addressing/ServiceIface/sayHello'";
        ResultSet rs = stmt.executeQuery(sql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Hello World!", (Object)rs.getString(1));
        conn.close();
    }
}

