/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.Options;

public class TestBufferManagerImpl {
    @Test
    public void testReserve() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager());
        bufferManager.setMaxProcessingKB(1024);
        bufferManager.setMaxReserveKB(1024);
        bufferManager.initialize();
        bufferManager.setNominalProcessingMemoryMax(512000);
        Assert.assertEquals((long)512000L, (long)bufferManager.reserveBuffers(1024000, BufferManager.BufferReserveMode.NO_WAIT));
        Assert.assertEquals((long)1024000L, (long)bufferManager.reserveBuffersBlocking(1024000, new long[]{0L, 0L}, true));
        Assert.assertEquals((long)0L, (long)bufferManager.reserveBuffersBlocking(1024000, new long[]{0L, 0L}, false));
        bufferManager.releaseBuffers(512000);
        Assert.assertEquals((long)24576L, (long)bufferManager.reserveBuffers(1024000, BufferManager.BufferReserveMode.NO_WAIT));
    }

    @Test
    public void testLargeReserve() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager());
        bufferManager.setMaxReserveKB(0x40000B);
        Assert.assertEquals((long)0x40000BL, (long)bufferManager.getMaxReserveKB());
    }

    @Test(expected=IOException.class)
    public void testFileStoreMax() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager(){

            public long getMaxStorageSpace() {
                return 640L;
            }
        });
        bufferManager.setMaxActivePlans(20);
        bufferManager.initialize();
        FileStore fs = bufferManager.createFileStore("x");
        fs.write(new byte[10], 0, 10);
    }

    @Test(expected=TeiidComponentException.class)
    public void testTupleBufferMax() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager(){

            public long getMaxStorageSpace() {
                return 640L;
            }
        });
        bufferManager.setMaxReserveKB(10);
        bufferManager.setMaxActivePlans(20);
        bufferManager.initialize();
        TupleBuffer tb = bufferManager.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, String.class)), "x", BufferManager.TupleSourceType.PROCESSOR);
        for (int i = 0; i < 1024; ++i) {
            tb.addTuple(Arrays.asList("a"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTupleBufferSessionMax() throws Exception {
        BufferManagerImpl bufferManager = new BufferManagerImpl();
        bufferManager.setCache((Cache)new MemoryStorageManager(){

            public long getMaxStorageSpace() {
                return 64000L;
            }
        });
        bufferManager.setMaxReserveKB(10);
        bufferManager.setMaxActivePlans(10);
        bufferManager.setOptions(new Options().maxSessionBufferSizeEstimate(100000L));
        bufferManager.initialize();
        CommandContext context = new CommandContext();
        context.setSession(new SessionMetadata());
        CommandContext.pushThreadLocalContext((CommandContext)context);
        try {
            ArrayList<TupleBuffer> tupleBuffers = new ArrayList<TupleBuffer>();
            for (int i = 0; i < 36; ++i) {
                TupleBuffer tb = bufferManager.createTupleBuffer(Arrays.asList(new ElementSymbol("x", null, String.class)), "x", BufferManager.TupleSourceType.PROCESSOR);
                try {
                    for (int j = 0; j < 50; ++j) {
                        tb.addTuple(Arrays.asList("a"));
                    }
                    tb.saveBatch();
                    if (i % 2 == 0) {
                        tb.remove();
                    }
                }
                catch (TeiidComponentException e) {
                    Assert.assertEquals((long)34L, (long)i);
                    CommandContext.popThreadLocalContext();
                    return;
                }
                tupleBuffers.add(tb);
            }
        }
        finally {
            CommandContext.popThreadLocalContext();
        }
        Assert.fail();
    }

    @Test
    public void testProcessorBatchSize() {
        BufferManagerImpl bm = BufferManagerFactory.createBufferManager();
        int processorBatchSize = bm.getProcessorBatchSize();
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        ElementSymbol a = new ElementSymbol("a");
        a.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol b = new ElementSymbol("b");
        b.setType(DataTypeManager.DefaultDataClasses.STRING);
        elements.add(a);
        Assert.assertEquals((long)(processorBatchSize * 8), (long)bm.getProcessorBatchSize(elements));
        elements.add(b);
        Assert.assertEquals((long)(processorBatchSize * 4), (long)bm.getProcessorBatchSize(elements));
        elements.add(b);
        Assert.assertEquals((long)(processorBatchSize * 2), (long)bm.getProcessorBatchSize(elements));
        elements.add(b);
        elements.add(b);
        Assert.assertEquals((long)processorBatchSize, (long)bm.getProcessorBatchSize(elements));
        elements.addAll(Collections.nCopies(28, b));
        Assert.assertEquals((long)(processorBatchSize / 2), (long)bm.getProcessorBatchSize(elements));
        elements.addAll(Collections.nCopies(100, b));
        Assert.assertEquals((long)(processorBatchSize / 4), (long)bm.getProcessorBatchSize(elements));
        elements.addAll(Collections.nCopies(375, b));
        Assert.assertEquals((long)(processorBatchSize / 8), (long)bm.getProcessorBatchSize(elements));
    }
}

