/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.File;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.postgresql.Driver;
import org.postgresql.core.v3.ExtendedQueryExectutorImpl;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.PgCatalogMetadataStore;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.TestEmbeddedServer;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;

public class TestODBCSocketTransport {
    private static final TestEmbeddedServer.MockTransactionManager TRANSACTION_MANAGER = new TestEmbeddedServer.MockTransactionManager();
    private static FakeOdbcServer odbcServer = new FakeOdbcServer();
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        odbcServer.start(Mode.LEGACY);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        odbcServer.stop();
    }

    @Before
    public void setUp() throws Exception {
        String database = "parts";
        TRANSACTION_MANAGER.reset();
        this.connect(database);
    }

    private void connect(String database) throws SQLException {
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = d.connect("jdbc:postgresql://" + TestODBCSocketTransport.odbcServer.addr.getHostName() + ":" + TestODBCSocketTransport.odbcServer.odbcTransport.getPort() + "/" + database, p);
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet(s.getResultSet());
    }

    @Test
    public void testTransactionalMultibatch() throws Exception {
        Statement s = this.conn.createStatement();
        this.conn.setAutoCommit(false);
        Assert.assertTrue((boolean)s.execute("select tables.name from tables, columns limit 1025"));
        int count = 0;
        while (s.getResultSet().next()) {
            ++count;
        }
        Assert.assertEquals((long)1025L, (long)count);
        this.conn.setAutoCommit(true);
    }

    @Test
    public void testMultibatchSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables, columns limit 7000"));
        ResultSet rs = s.getResultSet();
        int i = 0;
        while (rs.next()) {
            ++i;
            rs.getString(1);
        }
        Assert.assertEquals((long)7000L, (long)i);
    }

    @Test
    public void testMultibatchSelectPrepared() throws Exception {
        PreparedStatement s = this.conn.prepareStatement("select * from (select * from tables order by name desc limit 21) t1, (select * from tables order by name desc limit 21) t2 where t1.name > ?");
        this.conn.setAutoCommit(false);
        s.setFetchSize(100);
        s.setString(1, "0");
        ResultSet rs = s.executeQuery();
        int i = 0;
        while (rs.next()) {
            ++i;
            rs.getString(1);
        }
        Assert.assertEquals((long)441L, (long)i);
    }

    @Test
    public void testBlob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select to_bytes('abc', 'UTF-16')"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        byte[] bytes = rs.getBytes(1);
        Assert.assertEquals((Object)"abc", (Object)new String(bytes, Charset.forName("UTF-16")));
    }

    @Test
    public void testClob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select cast('abc' as clob)"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String clob = rs.getString(1);
        Assert.assertEquals((Object)"abc", (Object)clob);
    }

    @Test
    public void testLargeClob() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select cast(repeat('_', 3000) as clob)"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String clob = rs.getString(1);
        Assert.assertEquals((long)3000L, (long)clob.length());
    }

    @Test
    public void testMultiRowBuffering() throws Exception {
        Statement s = this.conn.createStatement();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 11; ++i) {
            sb.append("select '' union all ");
        }
        sb.append("select ''");
        Assert.assertTrue((boolean)s.execute(sb.toString()));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String str = rs.getString(1);
        Assert.assertEquals((long)0L, (long)str.length());
    }

    @Test
    public void testTransactionCycle() throws Exception {
        this.conn.setAutoCommit(false);
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        this.conn.setAutoCommit(true);
    }

    @Test
    public void testRollbackSavepointNoOp() throws Exception {
        this.conn.setAutoCommit(false);
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("rollback to foo1"));
        Assert.assertFalse((boolean)this.conn.getAutoCommit());
    }

    @Test
    public void testTxnStatement() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("begin work"));
        Assert.assertFalse((boolean)s.execute("rollback transaction"));
    }

    @Test
    public void testPk() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'pg_attribute' AND n.nspname = E'pg_catalog'");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testPkPrepared() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = E'pg_attribute' AND n.nspname = E'pg_catalog'");
        ResultSet rs = stmt.executeQuery();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testColumnMetadataWithAlias() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select ta.attname as x from pg_catalog.pg_attribute ta limit 1");
        ResultSet rs = stmt.executeQuery();
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void testPreparedError() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select cast(? as integer)");
        stmt.setString(1, "a");
        try {
            stmt.executeQuery();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error converting"));
        }
    }

    @Test
    public void testPreparedError1() throws Exception {
        PreparedStatement stmt = this.conn.prepareStatement("select");
        try {
            stmt.executeQuery();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Parsing error"));
        }
    }

    @Test
    public void testEscapedLiteral() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select E'\\n\\thello pg'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"\n\thello pg", (Object)rs.getString(1));
    }

    @Test
    public void testPgProc() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from pg_proc");
        rs.next();
        Assert.assertEquals((Object)"oid", (Object)rs.getArray("proargtypes").getBaseTypeName());
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursor() throws Exception {
        Statement stmt = this.conn.createStatement();
        ExtendedQueryExectutorImpl.simplePortal = "foo";
        try {
            Assert.assertFalse((boolean)stmt.execute("declare \"foo\" cursor for select * from pg_proc limit 13;"));
            stmt.execute("fetch \"foo\"");
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)1L, (long)rowCount);
            Assert.assertFalse((boolean)stmt.execute("move 5 in \"foo\""));
            stmt.execute("fetch 10 in \"foo\"");
            rs = stmt.getResultSet();
            rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)7L, (long)rowCount);
            stmt.execute("close \"foo\"");
            Assert.assertFalse((boolean)stmt.execute("declare \"foo\" cursor for select * from pg_proc;"));
            try {
                stmt.execute("fetch 9999999999 in \"foo\"");
                Assert.fail();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            ExtendedQueryExectutorImpl.simplePortal = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCursorUnquoted() throws Exception {
        Statement stmt = this.conn.createStatement();
        ExtendedQueryExectutorImpl.simplePortal = "foo";
        try {
            Assert.assertFalse((boolean)stmt.execute("declare foo cursor for select * from pg_proc limit 13;"));
            stmt.execute("fetch foo");
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)1L, (long)rowCount);
            Assert.assertFalse((boolean)stmt.execute("move 5 in foo"));
            stmt.execute("fetch 10 in \"foo\"");
            rs = stmt.getResultSet();
            rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)7L, (long)rowCount);
            stmt.execute("close foo");
        }
        finally {
            ExtendedQueryExectutorImpl.simplePortal = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScrollCursor() throws Exception {
        Statement stmt = this.conn.createStatement();
        ExtendedQueryExectutorImpl.simplePortal = "foo";
        try {
            Assert.assertFalse((boolean)stmt.execute("declare \"foo\" insensitive scroll cursor for select * from pg_proc limit 11;"));
            Assert.assertFalse((boolean)stmt.execute("move 5 in \"foo\""));
            stmt.execute("fetch 7 in \"foo\"");
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)6L, (long)rowCount);
            Assert.assertFalse((boolean)stmt.execute("move backward 2 in \"foo\""));
            stmt.execute("fetch 6 in \"foo\"");
            rs = stmt.getResultSet();
            rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)1L, (long)rowCount);
            stmt.execute("close \"foo\"");
        }
        finally {
            ExtendedQueryExectutorImpl.simplePortal = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScrollCursorWithHold() throws Exception {
        Statement stmt = this.conn.createStatement();
        ExtendedQueryExectutorImpl.simplePortal = "foo";
        try {
            Assert.assertFalse((boolean)stmt.execute("declare \"foo\" insensitive scroll cursor with hold for select * from pg_proc;"));
            Assert.assertFalse((boolean)stmt.execute("move 5 in \"foo\""));
            stmt.execute("fetch 7 in \"foo\"");
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                ++rowCount;
            }
            Assert.assertEquals((long)7L, (long)rowCount);
            stmt.execute("close \"foo\"");
        }
        finally {
            ExtendedQueryExectutorImpl.simplePortal = null;
        }
    }

    @Test
    public void testScrollCursorOtherFetches() throws Exception {
        Statement stmt = this.conn.createStatement();
        ExtendedQueryExectutorImpl.simplePortal = "foo";
        try {
            Assert.assertFalse((boolean)stmt.execute("declare \"foo\" insensitive scroll cursor for values (1), (2), (3);"));
            stmt.execute("fetch first in \"foo\"");
            ResultSet rs = stmt.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            stmt.execute("fetch last in \"foo\"");
            rs = stmt.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            stmt.execute("fetch absolute 2 in \"foo\"");
            rs = stmt.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            stmt.execute("fetch relative 1 in \"foo\"");
            rs = stmt.getResultSet();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            ExtendedQueryExectutorImpl.simplePortal = null;
        }
    }

    @Test
    public void testPgProcedure() throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select has_function_privilege(100, 'foo')");
        rs.next();
    }

    @Test
    public void testPreparedUpdate() throws Exception {
        Statement stmt = this.conn.createStatement();
        Assert.assertFalse((boolean)stmt.execute("create local temporary table x (y string)"));
        PreparedStatement ps = this.conn.prepareStatement("delete from x");
        Assert.assertFalse((boolean)ps.execute());
        Assert.assertNull((Object)ps.getMetaData());
    }

    @Test
    public void testSelectSsl() throws Exception {
        this.conn.close();
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        p.setProperty("ssl", "true");
        p.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
        this.conn = d.connect("jdbc:postgresql://" + TestODBCSocketTransport.odbcServer.addr.getHostName() + ":" + TestODBCSocketTransport.odbcServer.odbcTransport.getPort() + "/parts", p);
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet("TestODBCSocketTransport/testSelect", s.getResultSet());
    }

    @Test
    public void testPayload() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("SET PAYLOAD x y"));
        Assert.assertTrue((boolean)s.execute("SELECT commandpayload('x')"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String str = rs.getString(1);
        Assert.assertEquals((Object)"y", (Object)str);
    }

    @Test
    public void testShowPlan() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("SET SHOWPLAN ON"));
        Assert.assertTrue((boolean)s.execute("SELECT 1"));
        Assert.assertTrue((boolean)s.execute("SHOW PLAN"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String str = rs.getString(1);
        Assert.assertTrue((boolean)str.startsWith("ProjectNode\n  + Relational Node ID:0\n  + Output Columns:expr1 (integer)\n  + Statistics:\n    0: Node Output Rows: 1"));
    }

    @Test
    public void testSetEmptyLiteral() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("SET min_client_messages TO ''"));
        Assert.assertTrue((boolean)s.execute("SHOW min_client_messages"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"", (Object)rs.getString(1));
    }

    @Test
    public void testSetNonString() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertFalse((boolean)s.execute("SET extra_float_digits TO 2"));
        Assert.assertTrue((boolean)s.execute("SHOW extra_float_digits"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"2", (Object)rs.getString(1));
    }

    @Test
    public void testColons() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select 'a::b'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a::b", (Object)rs.getString(1));
        rs = s.executeQuery("select ' a::b'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)" a::b", (Object)rs.getString(1));
        rs = s.executeQuery("select name::varchar from tables where name = 'Columns'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"Columns", (Object)rs.getString(1));
    }

    @Test
    public void testInt2Vector() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select indkey FROM pg_index order by oid");
        TestMMDatabaseMetaData.compareResultSet(rs);
    }

    @Test
    public void test_pg_client_encoding() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select pg_client_encoding()");
        rs.next();
        Assert.assertEquals((Object)"UTF8", (Object)rs.getString(1));
        s.execute("set client_encoding UTF8");
        rs = s.executeQuery("select pg_client_encoding()");
        rs.next();
        Assert.assertEquals((Object)"UTF8", (Object)rs.getString(1));
    }

    @Test
    public void test_table_with_underscore() throws Exception {
        DatabaseMetaData metadata = this.conn.getMetaData();
        ResultSet rs = metadata.getTables(null, null, "pg_index", null);
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void test_pg_cast() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select '2011-01-01'::date");
        rs.next();
        Assert.assertEquals((Object)"2011-01-01", (Object)rs.getString(1));
    }

    @Test(expected=SQLException.class)
    public void test_pg_client_encoding1() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set client_encoding LATIN1");
    }

    @Test
    public void testArray() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select (1,2)");
        rs.next();
        Array result = rs.getArray(1);
        ResultSet rs1 = result.getResultSet();
        rs1.next();
        Assert.assertEquals((long)1L, (long)rs1.getInt(1));
    }

    @Test
    public void testClientIp() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from objecttable('teiid_context' COLUMNS y string 'teiid_row.session.IPAddress') as X"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String value = rs.getString(1);
        Assert.assertNotNull((Object)value);
    }

    @Test
    public void testVDBConnectionProperty() throws Exception {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("x");
        vdb.addProperty("connection.foo", "bar");
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setSchemaSourceType("ddl");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.setSchemaText("create view v as select 1");
        vdb.addModel(mmd);
        TestODBCSocketTransport.odbcServer.server.deployVDB(vdb);
        this.conn.close();
        this.connect("x");
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("show foo"));
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String value = rs.getString(1);
        Assert.assertEquals((Object)"bar", (Object)value);
    }

    @Test
    public void testDecimalPrecision() throws Exception {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("decimal");
        vdb.addProperty("connection.foo", "bar");
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view v (x decimal(2), y decimal) as select 1.0, 2.0");
        vdb.addModel(mmd);
        TestODBCSocketTransport.odbcServer.server.deployVDB(vdb);
        this.conn.close();
        this.connect("decimal");
        Statement s = this.conn.createStatement();
        s.execute("select * from v");
        ResultSetMetaData metadata = s.getResultSet().getMetaData();
        Assert.assertEquals((long)2L, (long)metadata.getPrecision(1));
        Assert.assertEquals((long)0L, (long)metadata.getScale(1));
        Assert.assertEquals((long)32767L, (long)metadata.getPrecision(2));
        Assert.assertEquals((long)16383L, (long)metadata.getScale(2));
        s.execute("select atttypmod from pg_attribute where attname = 'y'");
        s.getResultSet().next();
        Assert.assertEquals((long)2147434499L, (long)s.getResultSet().getInt(1));
    }

    @Test
    public void testTransactionCycleDisabled() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("set disableLocalTxn true");
        this.conn.setAutoCommit(false);
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        this.conn.setAutoCommit(true);
    }

    @Test
    public void testGropuByPositional() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("select name, count(schemaname) from tables group by 1");
    }

    @Test
    public void testImplicitPortalClosing() throws Exception {
        Statement statement = this.conn.createStatement();
        ResultSet rs = statement.executeQuery("select session_id()");
        rs.next();
        String id = rs.getString(1);
        statement.close();
        PreparedStatement s = this.conn.prepareStatement("select 1");
        s.executeQuery();
        s.executeQuery();
        s.executeQuery();
        int runningCount = 0;
        for (RequestMetadata request : TestODBCSocketTransport.odbcServer.server.getDqp().getRequestsForSession(id)) {
            if (request.getState() != Request.ProcessingState.PROCESSING) continue;
            ++runningCount;
        }
        Assert.assertEquals((long)1L, (long)runningCount);
        s.close();
    }

    @Test
    public void testExportedKey() throws Exception {
        String sql = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"exported-fk-query.txt"));
        Statement s = this.conn.createStatement();
        s.execute(sql);
        ResultSet rs = s.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"STATUS_ID", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRegClass() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select '\"pg_catalog.pg_class\"'::regclass");
        rs.next();
        int oid = rs.getInt(1);
        rs = s.executeQuery("select oid from pg_class where relname='pg_class'");
        rs.next();
        int oid1 = rs.getInt(1);
        Assert.assertEquals((long)oid, (long)oid1);
    }

    @Test
    public void testApplicationName() throws Exception {
        Statement s = this.conn.createStatement();
        this.checkApplicationName(s, "ODBC");
        s.execute("set application_name to other");
        this.checkApplicationName(s, "other");
    }

    @Test
    public void testGeometry() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("SELECT ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))')");
        ResultSet rs = s.getResultSet();
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((Object)"geometry", (Object)rsmd.getColumnTypeName(1));
        Assert.assertEquals((Object)"00200000030000000000000001000000054044000000000000000000000000000040490000000000004049000000000000000000000000000040490000000000000000000000000000000000000000000040440000000000000000000000000000", (Object)rs.getString(1));
    }

    @Test
    public void testConstraintDef() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("SELECT pg_get_constraintdef((select oid from pg_constraint where contype = 'f' and conrelid = (select oid from pg_class where relname = 'Functions')), true)");
        ResultSet rs = s.getResultSet();
        rs.next();
        Assert.assertEquals((Object)"FOREIGN KEY (VDBName,SchemaName) REFERENCES SYS.Schemas(VDBName,Name)", (Object)rs.getString(1));
    }

    @Test
    public void testXML() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("SELECT xmlelement(name x)");
        ResultSet rs = s.getResultSet();
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        Assert.assertEquals((Object)"xml", (Object)rsmd.getColumnTypeName(1));
        Assert.assertEquals((Object)"<x></x>", (Object)rs.getString(1));
    }

    @Test
    public void testVersion() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("SELECT version()");
        ResultSet rs = s.getResultSet();
        rs.next();
        Assert.assertEquals((Object)PgCatalogMetadataStore.POSTGRESQL_VERSION, (Object)rs.getString(1));
    }

    private void checkApplicationName(Statement s, String value) throws SQLException {
        ResultSet rs = s.executeQuery("show application_name");
        rs.next();
        Assert.assertEquals((Object)value, (Object)rs.getString(1));
        rs.close();
        rs = s.executeQuery("select session_id()");
        rs.next();
        String sessionId = rs.getString(1);
        rs.close();
        SessionMetadata current = null;
        for (SessionMetadata session : TestODBCSocketTransport.odbcServer.server.getSessionService().getActiveSessions()) {
            if (!session.getSessionId().equals(sessionId)) continue;
            current = session;
            break;
        }
        Assert.assertEquals((Object)value, (Object)current.getApplicationName());
    }

    static class FakeOdbcServer {
        InetSocketAddress addr;
        ODBCSocketListener odbcTransport;
        FakeServer server;

        FakeOdbcServer() {
        }

        public void start(Mode mode) throws Exception {
            SocketConfiguration config = new SocketConfiguration();
            SSLConfiguration sslConfig = new SSLConfiguration();
            if (mode == Mode.LOGIN) {
                sslConfig.setMode("login");
            } else if (mode == Mode.ENABLED || mode == Mode.LEGACY) {
                sslConfig.setMode("enabled");
                sslConfig.setAuthenticationMode("1-way");
                sslConfig.setKeystoreFilename(UnitTestUtil.getTestDataFile((String)"keystore.jks").getAbsolutePath());
                sslConfig.setKeystorePassword("password");
            } else {
                sslConfig.setMode("disabled");
            }
            config.setSSLConfiguration(sslConfig);
            this.addr = new InetSocketAddress(0);
            config.setBindAddress(this.addr.getHostName());
            config.setPortNumber(this.addr.getPort());
            this.server = new FakeServer(false);
            EmbeddedConfiguration ec = new EmbeddedConfiguration();
            ec.setTransactionManager((TransactionManager)TRANSACTION_MANAGER);
            this.server.start(ec, false);
            LogonImpl logon = (LogonImpl)Mockito.mock(LogonImpl.class);
            this.odbcTransport = new ODBCSocketListener(this.addr, config, (ClientServiceRegistryImpl)Mockito.mock(ClientServiceRegistryImpl.class), (StorageManager)BufferManagerFactory.getStandaloneBufferManager(), 100000, logon, this.server.getDriver());
            this.odbcTransport.setMaxBufferSize(1000);
            if (mode == Mode.LEGACY) {
                this.odbcTransport.setRequireSecure(false);
            }
            this.server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        }

        public void stop() {
            this.server.stop();
            this.odbcTransport.stop();
        }
    }

    static enum Mode {
        LEGACY,
        ENABLED,
        LOGIN,
        DISABLED;

    }
}

