/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.query.processor.relational.TupleSourceValueIterator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.ValueIteratorSource;

public class DependentValueSource
implements ValueIteratorSource {
    private TupleBuffer buffer;
    private List<? extends Expression> schema;
    private Map<Expression, Set<Object>> cachedSets;
    private boolean unused;
    private boolean distinct;

    public DependentValueSource(TupleBuffer tb) {
        this(tb, tb.getSchema());
    }

    public DependentValueSource(TupleBuffer tb, List<? extends Expression> schema) {
        this.buffer = tb;
        this.schema = schema;
    }

    public TupleBuffer getTupleBuffer() {
        return this.buffer;
    }

    @Override
    public TupleSourceValueIterator getValueIterator(Expression valueExpression) throws TeiidComponentException {
        TupleBuffer.TupleBufferTupleSource its = this.buffer.createIndexedTupleSource();
        int index = 0;
        if (valueExpression != null) {
            if (valueExpression instanceof org.teiid.query.sql.symbol.Array) {
                final org.teiid.query.sql.symbol.Array array = (org.teiid.query.sql.symbol.Array)valueExpression;
                List<Expression> exprs = array.getExpressions();
                final int[] indexes = new int[exprs.size()];
                for (int i = 0; i < exprs.size(); ++i) {
                    indexes[i] = this.getIndex(exprs.get(i));
                }
                return new TupleSourceValueIterator(its, index){

                    @Override
                    public Object next() throws TeiidComponentException {
                        List<?> tuple = super.nextTuple();
                        Object[] a = (Object[])Array.newInstance(array.getComponentType(), indexes.length);
                        for (int i = 0; i < indexes.length; ++i) {
                            a[i] = tuple.get(indexes[i]);
                            if (a[i] != null) continue;
                            return null;
                        }
                        return new ArrayImpl(a);
                    }
                };
            }
            index = this.getIndex(valueExpression);
        }
        return new TupleSourceValueIterator(its, index);
    }

    private int getIndex(Expression valueExpression) {
        int index = this.schema.indexOf(valueExpression);
        Assertion.assertTrue((index != -1 ? 1 : 0) != 0);
        return index;
    }

    @Override
    public Set<Object> getCachedSet(Expression valueExpression) throws TeiidComponentException, TeiidProcessingException {
        AbstractSet result = null;
        if (this.cachedSets != null) {
            result = this.cachedSets.get(valueExpression);
        }
        if (result == null) {
            if (this.buffer.getRowCount() > (long)this.buffer.getBatchSize()) {
                return null;
            }
            TupleSourceValueIterator ve = this.getValueIterator(valueExpression);
            int index = 0;
            Class<?> type = null;
            if (valueExpression instanceof org.teiid.query.sql.symbol.Array) {
                type = ((org.teiid.query.sql.symbol.Array)valueExpression).getComponentType();
            } else {
                if (valueExpression != null) {
                    index = this.schema.indexOf(valueExpression);
                    Assertion.assertTrue((index != -1 ? 1 : 0) != 0);
                }
                type = this.schema.get(index).getType();
            }
            result = !DataTypeManager.isHashable(type) ? new TreeSet<Object>(Constant.COMPARATOR) : new HashSet<Object>();
            while (ve.hasNext()) {
                Object value = ve.next();
                if (value == null) continue;
                result.add((Object)value);
            }
            ve.close();
            if (this.cachedSets == null) {
                this.cachedSets = new HashMap<Expression, Set<Object>>();
            }
            this.cachedSets.put(valueExpression, result);
        }
        return result;
    }

    @Override
    public boolean isUnused() {
        return this.unused;
    }

    @Override
    public void setUnused(boolean unused) {
        this.unused = unused;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<? extends Expression> getSchema() {
        return this.schema;
    }
}

